~VERSION INFORMATION
VERS.           2.0   :CWLS Log ASCII Standard - VERSION 2.0
WRAP.           NO    :One Line per depth step
PROD.  Schlumberger   :LAS Producer
PROG.  DLIS to ASCII 17C0-154                          :LAS Program name and version
CREA.        2010/05/17 16:15                          :LAS Creation date {YYYY/MM/DD hh:mm}
DLIS_CREA.  2010-May-15 20:39                          :DLIS Creation date and time {YYYY-MMM-DD hh:mm}
SOURCE.     AIT_TLD_MCFL_CNL_023PUP.DLIS               :DLIS File Name
FILE-ID.     AIT_TLD_MCFL_CNL_023PUP                   :File Identification Number
#--------------------------------------------------
~WELL INFORMATION
#MNEM.UNIT      DATA             DESCRIPTION
#---- ------ --------------   -----------------------------
STRT .M      2578.1508       :START DEPTH     
STOP .M      2782.9764       :STOP DEPTH     
STEP .M       0.1524         :STEP     
NULL .          -999.25      :NULL VALUE
COMP .        Nalcor Energy Oil and Gas                :COMPANY
WELL .        Nalcor et al Seamus 1                    :WELL
FLD  .        Parson's Pond                            :FIELD
LOC  .        Latitude: 49.98 N                        :LOCATION
CNTY .        Stoneham #11                             :COUNTY
STAT .        Newfoundland                             :STATE
CTRY .                                                 :COUNTRY
API  .                                                 :API NUMBER
UWI  .                                                 :UNIQUE WELL ID
DATE .        15-May-2010                              :LOG DATE {DD-MMM-YYYY}
SRVC .        Schlumberger                             :SERVICE COMPANY
LATI .DEG     46 DEG 23 MIN 57.8 S                     :LATITUDE
LONG .DEG     48 DEG 27 MIN 52.1 S                     :LONGITUDE
GDAT .                                                 :GeoDetic Datum
SECT .        49.98 N                                  :Section
TOWN .        57.70 W                                  :Township
#-----------------------------------------------------------------------------
~PARAMETER INFORMATION
#MNEM.UNIT    VALUE                      DESCRIPTION
#---- -----   --------------------       ------------------------
RUN  .          Run 1                    :RUN NUMBER
PDAT .        Ground Level               :Permanent Datum
EPD  .M          20.690001               :Elevation of Permanent Datum above Mean Sea Level
LMF  .          Kelly Bushing            :Logging Measured From (Name of Logging Elevation Reference)
APD  .M           6.299999               :Elevation of Depth Reference (LMF) above Permanent Datum
#-----------------------------------------------------------------------------
~CURVE INFORMATION
#MNEM.UNIT   API CODE                                  DESCRIPTION
#---- -----  --------                                  -----------------------
DEPT .M                                                :DEPTH (BOREHOLE) {F10.4}
AO10 .OHMM                                             :Array Induction One Foot Resistivity A10 {F13.4}
AO20 .OHMM                                             :Array Induction One Foot Resistivity A20 {F13.4}
AO30 .OHMM                                             :Array Induction One Foot Resistivity A30 {F13.4}
AO60 .OHMM                                             :Array Induction One Foot Resistivity A60 {F13.4}
AO90 .OHMM                                             :Array Induction One Foot Resistivity A90 {F13.4}
BS   .MM                                               :Bit Size {F13.4}
GR   .GAPI                                             :Gamma-Ray {F13.4}
HCAL .MM                                               :HRCC Cal. Caliper {F13.4}
HDPH_DOL.V/V                                           :HiRes Density Porosity (matrix Dolomite) {F13.4}
HDPH_LIM.V/V                                           :HiRes Density Porosity (matrix Limestone) {F13.4}
HDPH_SAN.V/V                                           :HiRes Density Porosity (matrix Sandstone) {F13.4}
HDRA .K/M3                                             :HRDD Density Correction {F13.4}
HNPO_DOL.V/V                                           :HiRes Enhanced Thermal Neutron Porosity (matrix Dolomite) {F13.4}
HNPO_LIM.V/V                                           :HiRes Enhanced Thermal Neutron Porosity (matrix Limestone) {F13.4}
HNPO_SAN.V/V                                           :HiRes Enhanced Thermal Neutron Porosity (matrix Sandstone) {F13.4}
PEF8 .                                                 :HRDD High Resolution Formation Photoelectric Factor {F13.4}
RHO8 .K/M3                                             :HRDD High Resolution Formation Density {F13.4}
SP   .MV                                               :SP Shifted {F13.4}
TENS .LBF                                              :Cable Tension {F13.4}
#-----------------------------------------------------------------------------
# 
#     DEPT        AO10         AO20         AO30         AO60         AO90         BS           GR           HCAL       HDPH_DOL     HDPH_LIM     HDPH_SAN       HDRA       HNPO_DOL     HNPO_LIM     HNPO_SAN       PEF8         RHO8         SP           TENS
#
~A  
 2578.1508      36.6097      84.2794     142.2823      91.1499     100.4558     216.0000     101.9552     298.7674       0.1926       0.1265       0.0948     207.3584       0.1551       0.1755       0.2266       5.8188    2462.0752     152.0625    4340.0000
 2578.3032      36.6097      84.2794     142.2823      91.1499     100.4558     216.0000     100.7754     300.7211       0.1926       0.1265       0.0948     207.3584       0.1694       0.1910       0.2428       5.8188    2462.0752     153.9375    4362.0000
 2578.4556      36.6097      84.2794     142.2823      91.1499     100.4558     216.0000      98.7157     302.7678       0.1926       0.1265       0.0948     207.3584       0.1655       0.1866       0.2383       5.8188    2462.0752     154.3125    4348.0000
 2578.6080      36.6097      84.2794     142.2823      91.1499     100.4558     216.0000      98.7492     283.6029       0.1926       0.1265       0.0948     207.3584       0.1498       0.1693       0.2203       5.8188    2462.0752     154.6875    4293.0000
 2578.7604      36.6097      84.2794     142.2823      91.1499     100.4558     216.0000     100.9171     292.1620       0.1926       0.1265       0.0948     207.3584       0.1677       0.1893       0.2410       5.8188    2462.0752     154.0000    4295.0000
 2578.9128      36.6097      84.2794     142.2823      91.1499     100.4558     216.0000     101.3193     286.2079       0.1926       0.1265       0.0948     207.3584       0.1555       0.1761       0.2272       5.8188    2462.0752     151.1250    4271.0000
 2579.0652      36.6097      84.2794     142.2823      91.1499     100.4558     216.0000      99.0430     287.6034       0.1926       0.1265       0.0948     207.3584       0.1640       0.1856       0.2370       5.8188    2462.0752     150.0625    4274.0000
 2579.2176      36.6097      84.2794     142.2823      91.1499     100.4558     216.0000      99.0430     292.5341       0.1926       0.1265       0.0948     207.3584       0.1689       0.1912       0.2426       5.8188    2462.0752     146.1875    4252.0000
 2579.3700      36.6097      84.2794     142.2823      91.1499     100.4558     216.0000      97.3400     306.6752       0.1827       0.1158       0.0836     186.3792       0.2065       0.2326       0.2850       5.4329    2512.0198     149.0000    4264.0000
 2579.5224      41.8636     101.3579     261.5492      99.8366     108.5262     216.0000     102.6577     285.9287       0.1897       0.1234       0.0915     163.3971       0.2171       0.2446       0.2969       4.8386    2499.0427     146.5000    4279.0000
 2579.6748      51.3024     242.2901     366.0044      84.3383      89.8764     216.0000     103.1997     286.4870       0.1607       0.0920       0.0590     145.7083       0.2009       0.2264       0.2788       4.7957    2552.6626     144.9375    4268.0000
 2579.8272      49.5211     226.9929     199.8274      59.3570      61.5352     216.0000     105.1509     291.5108       0.1171       0.0448       0.0101     158.8955       0.1653       0.1869       0.2384       4.8702    2633.3562     143.9375    4202.0000
 2579.9796      70.8826     243.2939     239.7440      52.7129      54.2101     216.0000     102.3263     304.8145       0.1297       0.0584       0.0242     189.7237       0.1379       0.1561       0.2065       4.5046    2610.0859     138.1250    4223.0000
 2580.1320      52.3608     119.0049     192.4571      57.7692      59.4088     216.0000     103.4102     296.4416       0.1711       0.1033       0.0707     233.0668       0.1377       0.1558       0.2063       5.0145    2533.3767     141.5625    4261.0000
 2580.2844      35.7268      56.6001      81.2781      42.3508      42.8583     216.0000     104.2786     279.8816       0.1629       0.0944       0.0614     260.7124       0.1807       0.2035       0.2557       6.0775    2548.6089     138.5625    4294.0000
 2580.4368      40.3333      62.1281     113.4199      32.8679      33.1371     216.0000     106.0130     297.0928       0.1302       0.0590       0.0248     261.2088       0.1426       0.1614       0.2120       5.3856    2609.0886     136.6875    4399.0000
 2580.5892      47.9497      51.4183      80.6492      52.0205      52.1636     216.0000     106.3382     285.3705       0.0900       0.0155      -0.0203     229.8107       0.1626       0.1838       0.2353       4.9543    2683.5640     128.4375    4391.0000
 2580.7416      24.6424      31.9191      42.0798      40.6758      40.4517     216.0000     109.6972     281.9283       0.1104       0.0376       0.0026     195.6933       0.1716       0.1936       0.2455       4.4247    2645.6731     136.2500    4256.0000
 2580.8940      50.6429      55.4217      53.7805      62.6533      62.1723     216.0000     112.2987     286.2079       0.1211       0.0492       0.0146     172.3082       0.1640       0.1855       0.2369       4.6995    2625.9255     121.3750    4237.0000
 2581.0464      84.2790      66.5020      76.8059      57.7201      57.9810     216.0000     112.6239     294.3018       0.1592       0.0903       0.0573     171.8178       0.1684       0.1899       0.2417       4.8882    2555.5083     133.2500    4229.0000
 2581.1988      60.1581      92.8205      95.9179      41.8228      42.5747     216.0000     109.6709     273.7414       0.1440       0.0740       0.0403     177.2327       0.1490       0.1686       0.2195       5.2579    2583.5076     126.9375    4256.0000
 2581.3512      35.2872      52.3058      38.1388      37.2020      37.5142     216.0000     101.5412     277.2766       0.1755       0.1080       0.0755     187.7983       0.1682       0.1899       0.2416       5.0560    2525.3469     126.9375    4220.0000
 2581.5036      55.1025     103.7870      89.0145      40.3053      40.7167     216.0000      97.5305     277.6488       0.1775       0.1101       0.0778     189.4779       0.1606       0.1815       0.2329       4.8070    2521.6885     126.6250    4205.0000
 2581.6560      75.1465     140.4246     183.9828      71.2036      72.2709     216.0000      95.4973     270.2991       0.2087       0.1439       0.1128     171.5736       0.1281       0.1454       0.1952       5.5482    2463.8799     123.1875    4204.0000
 2581.8084      38.6645      77.0362      92.4633      73.4559      74.5772     216.0000      99.4766     294.5809       0.2990       0.2416       0.2140     155.3237       0.1744       0.1968       0.2487       5.4331    2296.8394     118.8750    4220.0000
 2581.9608      47.7146      41.9517      58.5449      71.3045      72.4248     216.0000     100.4521     319.5138       0.2410       0.1788       0.1490     148.3126       0.2069       0.2326       0.2853       5.2939    2404.1946     119.8750    4177.0000
 2582.1132      37.6634      34.7017     105.1616     146.7920     149.2576     216.0000     100.7773     323.6073       0.2246       0.1611       0.1306     180.0659       0.1486       0.1682       0.2191       5.2054    2434.5024     123.0000    4206.0000
 2582.2656      54.7397      53.2143     143.8403     260.5559     264.0045     216.0000      98.6755     324.1655       0.2236       0.1600       0.1295     210.2311       0.1395       0.1578       0.2083       5.2565    2436.3494     119.3125    4212.0000
 2582.4180      67.6877      85.7452     309.8745     453.0243     453.5872     216.0000      98.2095     333.0967       0.2051       0.1400       0.1088     240.2818       0.1706       0.1922       0.2441       5.6949    2470.5491     116.5000    4292.0000
 2582.5704      54.8748     125.3765     441.9171     313.1090     311.4456     216.0000      96.9087     311.3269       0.1535       0.0842       0.0509     254.9102       0.1392       0.1577       0.2082       5.1675    2565.9436     117.1875    4367.0000
 2582.7228      43.2773     111.2286     169.0467      80.0368      79.3400     216.0000      97.3076     306.1170       0.1096       0.0367       0.0016     251.4477       0.1164       0.1319       0.1811       5.1543    2647.2954     112.1250    4346.0000
 2582.8752      42.9231     133.0572     127.4630      59.8948      59.1066     216.0000      96.4195     291.2317       0.1477       0.0779       0.0444     232.5325       0.1469       0.1661       0.2170       4.9769    2576.7095     115.2500    4354.0000
 2583.0276      37.1915      95.5941      84.2199      50.0397      49.2501     216.0000     100.2855     284.5333       0.1178       0.0455       0.0108     193.6295       0.1653       0.1866       0.2382       5.2361    2632.1277     107.4375    4273.0000
 2583.1800      24.0387      39.1530      31.2692      17.6349      17.4256     216.0000     102.3450     287.1382       0.1011       0.0275      -0.0078     174.3662       0.1371       0.1555       0.2058       4.2705    2662.9321     111.3750    4265.0000
 2583.3324      42.0294      65.6764      69.1654      32.7876      31.5988     216.0000     102.7235     280.6259       0.1592       0.0904       0.0573     166.2438       0.1665       0.1881       0.2397       4.5582    2555.4236     107.9375    4250.0000
 2583.4848      34.0609      46.8481      69.6611      45.8165      44.4689     216.0000     101.0255     277.2766       0.1792       0.1120       0.0797     168.1733       0.1928       0.2167       0.2693       5.2963    2518.4153     107.6250    4297.0000
 2583.6372      24.1508      21.3573      30.0436      27.9082      26.6245     216.0000      99.9416     292.6272       0.1660       0.0977       0.0649     185.6203       0.1725       0.1946       0.2464       5.1485    2542.8936     103.6875    4241.0000
 2583.7896      42.9944      16.0383      24.8039      52.2409      49.7027     216.0000     101.8927     298.7674       0.1019       0.0284      -0.0069     196.4109       0.1554       0.1758       0.2270       5.1038    2661.4292     107.4375    4297.0000
 2583.9420      43.1682      42.1725      59.2598      71.1231      68.2016     216.0000      98.2672     287.5103       0.1122       0.0395       0.0046     211.0655       0.1447       0.1640       0.2146       4.6481    2642.4402      97.6250    4319.0000
 2584.0944      47.8935      67.1543     111.2473      79.1687      75.6605     216.0000      95.8825     273.1832       0.1496       0.0800       0.0465     209.7344       0.1412       0.1603       0.2107       5.5741    2573.2703      97.6250    4296.0000
 2584.2468      41.4591     149.5774     455.0566      66.2347      64.1040     216.0000      97.6168     300.3489       0.1476       0.0779       0.0443     207.2272       0.1795       0.2036       0.2550       5.1713    2576.8713      97.6250    4213.0000
 2584.3992      34.8878     140.6471     181.8491      61.9358      57.3837     216.0000     100.3751     303.5121       0.1839       0.1171       0.0850     204.5875       0.2253       0.2543       0.3062       4.8447    2509.8242      97.6250    4256.0000
 2584.5516      38.1835      86.2996     125.9714      69.7121      64.4154     216.0000     104.4942     299.3256       0.1909       0.1246       0.0928     206.3828       0.2171       0.2455       0.2972       5.6266    2496.8884      87.8750    4456.0000
 2584.7040      36.9690      50.0099      57.0420      74.1871      65.0838     216.0000     100.6685     298.7674       0.1648       0.0964       0.0636     210.8006       0.2170       0.2448       0.2969       5.6187    2545.0754      82.4375    4415.0000
 2584.8564      36.6884      36.0825      78.8664     137.0885     125.4221     216.0000     101.1905     303.2330       0.1679       0.0997       0.0670     207.5410       0.2212       0.2492       0.3015       5.2779    2539.4644      87.0625    4269.0000
 2585.0088      53.6541      44.2765      82.4054     139.6867     129.6022     216.0000      97.9387     280.8119       0.1667       0.0985       0.0657     190.2382       0.1465       0.1668       0.2171       5.3106    2541.5188      84.0625    4244.0000
 2585.1612      57.7065      52.9029      72.1296      84.9674      79.8899     216.0000      98.4040     292.5341       0.2019       0.1365       0.1051     172.4160       0.1744       0.1974       0.2490       5.2316    2476.5144      86.3750    4158.0000
 2585.3136      44.2108      50.0430      48.2070      42.4983      40.7264     216.0000      94.8469     296.5346       0.2432       0.1813       0.1515     174.5298       0.1886       0.2128       0.2649       6.0819    2400.0251      78.8125    4238.0000
 2585.4660      46.2606     106.2988      94.5063      71.2552      64.3527     216.0000      99.6882     323.0491       0.1968       0.1311       0.0995     168.8862       0.1582       0.1793       0.2303       5.5504    2485.8372      78.1250    4312.0000
 2585.6184      36.7682     358.9382     102.9772      51.9029      48.7508     216.0000      98.2791     271.8807       0.2282       0.1650       0.1346     156.0011       0.1832       0.2077       0.2592       5.0062    2427.8530      74.5000    4260.0000
 2585.7708      32.2879      95.7427     140.2788      96.6478      81.6564     216.0000     100.4137     285.0915       0.2216       0.1578       0.1272     125.5100       0.1823       0.2071       0.2582       5.4527    2440.1140      71.0625    4293.0000
 2585.9232      32.9470      30.8268      43.0327      64.7687      60.4369     216.0000      95.2472     311.3269       0.2081       0.1432       0.1121     116.9326       0.2521       0.2841       0.3356       5.1091    2465.0811      68.3750    4272.0000
 2586.0756      23.5300      12.1072      16.1203      32.7693      30.3052     216.0000      99.9811     313.0015       0.1964       0.1306       0.0990     138.9470       0.2448       0.2776       0.3281       5.3358    2486.6445      62.1875    4399.0000
 2586.2280      46.9605      29.3483      46.7422      71.0293      67.3063     216.0000     100.9899     316.9089       0.2137       0.1494       0.1184     170.0621       0.2113       0.2406       0.2912       5.3226    2454.5837      58.5625    4340.0000
 2586.3804      54.8754      51.3612      85.0313      97.1394      91.7947     216.0000     103.8824     285.0915       0.2154       0.1512       0.1203     206.4145       0.1984       0.2258       0.2767       5.7154    2451.5134      58.5625    4254.0000
 2586.5328      37.7938      52.8522      60.2676      45.2740      45.5802     216.0000      99.5821     271.8807       0.1758       0.1083       0.0759     229.9848       0.2484       0.2794       0.3314       5.4206    2524.7942      58.5625    4182.0000
 2586.6852      35.8857      65.1972      36.5895      28.4519      27.8869     216.0000     101.0996     265.3683       0.1708       0.1030       0.0703     248.4598       0.1927       0.2187       0.2700       5.6205    2533.9475      56.0000    4208.0000
 2586.8376      23.2316      50.5953      49.3616      32.0181      31.1413     216.0000     104.2774     277.2766       0.1655       0.0971       0.0643     240.5286       0.1734       0.1974       0.2482       5.6031    2543.9053      52.1875    4156.0000
 2586.9900      22.6781      55.1945      43.5228      30.5590      29.7412     216.0000     107.8005     287.3243       0.2065       0.1415       0.1103     202.9064       0.1811       0.2062       0.2571       5.4649    2467.9971      49.2500    4239.0000
 2587.1424      30.5657      75.1044      69.9662      43.3408      42.0233     216.0000     103.2171     307.2334       0.2696       0.2098       0.1811     155.8881       0.2219       0.2514       0.3027       4.9103    2351.2158      45.4375    4182.0000
 2587.2948      32.3155     100.8956     141.6289      81.5755      80.9783     216.0000      99.4232     293.4644       0.3135       0.2573       0.2303     121.5808       0.2574       0.2921       0.3419       5.5457    2270.0730      39.0625    4221.0000
 2587.4472      36.7080      85.8051     144.2298     170.0685     161.6330     216.0000      98.0008     300.1629       0.2349       0.1722       0.1421     102.8082       0.2673       0.3031       0.3527       5.5449    2415.4609      36.2500    4293.0000
 2587.5996      34.0320      55.3655     147.9275     405.9281     381.3186     216.0000     100.4163     307.0474       0.1963       0.1304       0.0988     103.5089       0.2109       0.2406       0.2909       5.3232    2486.9331      35.0000    4220.0000
 2587.7520      37.4065      54.5515     151.4633     761.0115     718.2939     216.0000      98.1086     316.3507       0.1813       0.1142       0.0820     119.9455       0.2488       0.2809       0.3322       5.0727    2514.6389      29.3125    4121.0000
 2587.9044      39.3443      74.3590      91.7507     561.0803     549.5363     216.0000      95.0323     296.5346       0.1902       0.1239       0.0921     152.8788       0.2052       0.2326       0.2840       5.5900    2498.1113      29.3125    4157.0000
 2588.0568      38.5443      67.3340     147.7061     195.5365     194.0117     216.0000      96.3331     305.7449       0.2113       0.1467       0.1157     180.5339       0.1782       0.2020       0.2534       6.0384    2459.0811      29.3125    4152.0000
 2588.2092      41.2589      81.2231     183.5341     123.6973     122.9561     216.0000      96.7980     259.2281       0.2853       0.2267       0.1986     218.0405       0.1850       0.2091       0.2610       6.4911    2322.2859      18.7500    4133.0000
 2588.3616      29.9250      40.9794      65.6878      39.4268      39.2497     216.0000      90.5269     258.2978       0.2659       0.2058       0.1770     259.6683       0.1958       0.2202       0.2727       7.7718    2358.0295      19.5000    4172.0000
 2588.5140      17.8203      22.2836      30.6541      17.6322      17.5543     216.0000      69.7010     263.3217       0.2569       0.1961       0.1669     328.2404       0.1931       0.2165       0.2690       7.8898    2374.6719      12.7500    4244.0000
 2588.6664      42.6494      60.4552     103.9397      59.5305      59.1652     216.0000      47.6965     256.6232       0.2282       0.1650       0.1347     374.8293       0.0440       0.0531       0.0919       7.6847    2427.8088       9.7500    4348.0000
 2588.8188      46.8509     106.9631     111.9662      75.7733      75.3303     216.0000      31.3129     279.8816       0.1833       0.1165       0.0843     412.5476      -0.0192      -0.0198       0.0075       7.4676    2510.8315       5.6250    4281.0000
 2588.9712      50.4240     104.9572     111.5554      81.1047      80.5505     216.0000      24.4976     261.3680       0.1524       0.0830       0.0497     403.4116      -0.0116      -0.0068       0.0193       7.3600    2568.0151       9.7500    4145.0000
 2589.1236      60.0733     111.3447     123.4654      90.5705      89.6207     216.0000      20.7037     256.6232       0.1076       0.0346      -0.0005     360.3589      -0.0065       0.0003       0.0266       7.3813    2650.8940       8.2500    4139.0000
 2589.2760     112.1098     241.2510     184.8671      94.4781      93.2795     216.0000      17.0183     253.2740       0.0597      -0.0173      -0.0543     270.0903      -0.0147      -0.0111       0.0148       7.1686    2739.6162       7.9375    4139.0000
 2589.4284     126.1902     926.4451     205.1721      74.9392      74.0792     216.0000      15.2787     236.3419       0.0021      -0.0795      -0.1188     161.1905      -0.0094      -0.0045       0.0223       5.8273    2846.0286       6.6250    4101.0000
 2589.5808      69.3552     637.4942     139.7505      59.8872      59.3596     216.0000      13.2192     224.8058       0.0385      -0.0402      -0.0781      80.3452      -0.0096      -0.0046       0.0220       5.1310    2778.7964       8.1250    4144.0000
 2589.7332      47.9562     724.5043     118.0335      56.7346      56.3293     216.0000      12.9678     225.3640       0.0613      -0.0155      -0.0525      51.2896      -0.0068       0.0002       0.0263       5.3978    2736.5498       1.1875    4133.0000
 2589.8856      92.3605     532.3129     149.2049      77.0923      76.4987     216.0000      12.6478     224.4336       0.0913       0.0170      -0.0188      57.0016      -0.0094      -0.0027       0.0228       5.8498    2681.0068       0.0000    4135.0000
 2590.0380     110.2360     736.9479     236.4570     120.8513     119.6862     216.0000      12.3226     223.1312       0.0801       0.0048      -0.0314      56.3424      -0.0134      -0.0080       0.0171       5.8185    2701.7505       0.0000    4121.0000
 2590.1904      83.4257     300.8651     317.3951     168.1832     164.5078     216.0000      13.2197     222.7590       0.0655      -0.0111      -0.0478      35.0184      -0.0143      -0.0091       0.0158       5.3604    2728.9094       0.0000    4147.0000
 2590.3428      53.4863     120.2387     365.1470     223.3590     222.0375     216.0000      12.8945     222.9451       0.0612      -0.0157      -0.0526      40.6609      -0.0140      -0.0089       0.0162       5.4950    2736.8062       0.0000    4166.0000
 2590.4952      74.2100      58.3108     326.8892     253.9072     253.4609     216.0000      13.5406     222.8521       0.0753      -0.0004      -0.0368      95.5694      -0.0094      -0.0029       0.0228       5.8132    2710.6423      -1.1875    4165.0000
 2590.6476      87.5805      35.8716     539.2908     350.1767     356.1197     216.0000      13.9788     234.2952       0.0994       0.0256      -0.0098     184.0146      -0.0137      -0.0085       0.0166       7.0646    2666.1987      -0.5625    4212.0000
 2590.8000      74.7156      25.9090     728.5537     367.7352     371.1059     216.0000      13.4369     243.2264       0.0856       0.0107      -0.0253     260.5617      -0.0129      -0.0072       0.0179       7.2856    2691.7012      -3.0625    4206.0000
 2590.9524      59.0039      26.4329    1007.0787     416.5743     421.2108     216.0000      13.7664     240.6215       0.1179       0.0457       0.0110     312.2056      -0.0030       0.0055       0.0318       7.3932    2631.9224      -2.4375    4190.0000
 2591.1048      55.4020      38.9396    1950.0000     682.4373     690.1426     216.0000      12.1230     246.7617       0.1255       0.0539       0.0195     362.1562      -0.0086      -0.0025       0.0237       7.8258    2617.8867      -1.5625    4152.0000
 2591.2572      63.6071      80.3622     929.7054     224.2072     227.2666     216.0000      12.9902     246.9477       0.1338       0.0629       0.0288     402.8249      -0.0037       0.0033       0.0304       7.7932    2602.4209       0.0000    4239.0000
 2591.4096      81.5287     220.7683    1166.8157     301.9898     305.7065     216.0000      14.8329     253.0879       0.1601       0.0914       0.0583     414.7017      -0.0074      -0.0018       0.0252       7.8434    2553.7246      -7.7500    4129.0000
 2591.5620      86.9152     505.3582     970.3810     211.3206     213.8590     216.0000      15.3923     263.6007       0.1640       0.0956       0.0627     405.7321      -0.0135      -0.0095       0.0165       7.8640    2546.5430      -7.5625    4125.0000
 2591.7144      97.1008     769.8593    1017.9047     217.6170     219.6708     216.0000      14.4167     270.8573       0.1597       0.0909       0.0578     376.5790      -0.0105      -0.0042       0.0212       7.5742    2554.6331      -9.6875    4215.0000
 2591.8668     110.1769     546.8328     811.6572     272.2327     273.6585     216.0000      13.4959     268.3454       0.1439       0.0738       0.0401     352.4973      -0.0125      -0.0063       0.0186       7.8526    2583.8201      -9.7500    4197.0000
 2592.0192     123.8652     624.6358     608.6998     268.2612     268.6280     216.0000      13.1707     283.6029       0.1542       0.0850       0.0517     355.6535      -0.0154      -0.0101       0.0144       7.2203    2564.6880     -13.8125    4132.0000
 2592.1716     106.1912     312.9491     236.8565     157.6320     157.6377     216.0000      14.7966     275.6021       0.1375       0.0669       0.0330     368.9523      -0.0090      -0.0023       0.0233       7.5328    2595.6140     -10.9375    4100.0000
 2592.3240      67.3162     183.5717     129.3824     103.5270     103.4905     216.0000      14.6335     271.1364       0.1370       0.0664       0.0324     374.5954      -0.0129      -0.0075       0.0177       7.5564    2596.4968     -16.7500    4235.0000
 2592.4764      90.2091     218.1205     202.9034     134.9254     134.8127     216.0000      14.8503     276.7184       0.1273       0.0558       0.0215     363.3411      -0.0221      -0.0187       0.0048       7.5892    2614.5657     -17.2500    4362.0000
 2592.6288     142.7097     610.0213     393.5992     202.7946     201.1769     216.0000      13.5854     261.9261       0.1190       0.0469       0.0122     363.1132      -0.0142      -0.0084       0.0162       7.5613    2629.7954     -19.5625    4367.0000
 2592.7812     134.6329    1950.0000    1021.1991     164.4002     163.9508     216.0000      12.5015     272.5320       0.1185       0.0464       0.0117     386.3831      -0.0153      -0.0097       0.0146       7.5582    2630.7300     -14.1875    4277.0000
 2592.9336     113.3275    1652.9972    1048.8182     134.3574     134.0750     216.0000      14.4526     251.7855       0.1440       0.0739       0.0402     403.0667      -0.0105      -0.0049       0.0211       7.5310    2583.6594     -21.4375    4187.0000
 2593.0860     109.4915     825.9344     932.7378     131.0219     130.7081     216.0000      14.2000     241.7379       0.1345       0.0636       0.0296     402.2417      -0.0085      -0.0030       0.0237       7.8780    2601.1760     -21.7500    4174.0000
 2593.2384      94.8741     457.6481     847.9821     169.2223     168.6693     216.0000      13.3328     257.4605       0.1175       0.0453       0.0106     390.1279      -0.0132      -0.0088       0.0171       7.6136    2632.5625     -19.5625    4247.0000
 2593.3908     104.7936     292.8485     690.4788     183.7414     182.7478     216.0000      13.2653     248.4363       0.1032       0.0298      -0.0055     376.7989      -0.0041       0.0028       0.0298       7.2158    2659.0088     -19.5625    4207.0000
 2593.5432     106.0452     283.2686    1085.4432     415.7068     412.3014     216.0000      13.9157     263.5077       0.1147       0.0422       0.0074     361.4912      -0.0083      -0.0027       0.0239       7.3566    2637.8643     -19.5625    4170.0000
 2593.6956     122.4851     262.6654    1334.4924     779.2011     776.1488     216.0000      14.8913     264.2520       0.1291       0.0578       0.0236     359.3073      -0.0061      -0.0001       0.0269       7.2680    2611.1309     -19.5625    4216.0000
 2593.8480     136.1967     285.1421    1950.0000    1950.0000    1950.0000     216.0000      13.1160     273.3693       0.1177       0.0454       0.0107     365.1147      -0.0074      -0.0019       0.0251       7.4512    2632.2996     -19.5625    4233.0000
 2594.0004     144.5530     304.5311    1570.2188     788.7183     811.4765     216.0000      12.4656     271.1364       0.0828       0.0077      -0.0284     354.5670      -0.0045       0.0023       0.0293       7.3435    2696.8020     -22.6250    4303.0000
 2594.1528     136.8869     330.4383    1044.0594     246.8138     252.3164     216.0000      12.4612     268.3454       0.1094       0.0365       0.0014     329.2391      -0.0042       0.0029       0.0298       7.1283    2647.6184     -21.3750    4271.0000
 2594.3052     110.5877     332.3452     737.8561     230.8808     239.9442     216.0000      12.0066     275.9742       0.1265       0.0550       0.0206     298.4574      -0.0047       0.0025       0.0291       6.8637    2615.9988     -22.1250    4191.0000
 2594.4576      87.9679     262.9757     346.3221      97.7531     102.6547     216.0000      11.8982     279.3234       0.1223       0.0504       0.0159     309.0103      -0.0116      -0.0075       0.0191       6.9843    2623.8110     -19.1875    4159.0000
 2594.6100      97.0187     430.1584     512.2316     135.1884     139.1027     216.0000      12.0110     279.5095       0.1367       0.0660       0.0320     328.0914      -0.0087      -0.0045       0.0230       7.1224    2597.1741     -19.5625    4168.0000
 2594.7624     112.8918     745.4233     967.9330     244.6217     255.6557     216.0000      14.5251     273.0901       0.1631       0.0946       0.0617     329.2802      -0.0031       0.0026       0.0308       7.7200    2548.2002     -19.1875    4244.0000
 2594.9148     123.8384    1031.9110    1895.4535     429.3724     455.7987     216.0000      15.8207     273.1832       0.1723       0.1045       0.0719     325.5782       0.0014       0.0083       0.0371       7.4508    2531.3098     -19.5625    4337.0000
 2595.0672     142.2827     792.6277    1261.9301     411.3622     441.3911     216.0000      15.8207     275.0439       0.1717       0.1039       0.0713     294.2664       0.0004       0.0065       0.0355       7.1566    2532.3733     -19.8750    4317.0000
 2595.2196     162.5235     747.6397    1063.9419     651.2561     689.9902     216.0000      16.0312     277.2766       0.2322       0.1693       0.1391     304.4167       0.0066       0.0135       0.0438       6.9396    2420.4900     -19.5625    4279.0000
 2595.3720     149.8468     414.5307     728.5415     570.0110     601.7643     216.0000      17.2404     271.9737       0.2192       0.1552       0.1245     327.6315       0.0055       0.0114       0.0421       7.4458    2444.5364     -23.8125    4214.0000
 2595.5244     247.6006     853.9459     475.4889     371.9169     384.9467     216.0000      18.9684     271.6946       0.1829       0.1160       0.0839     383.3005       0.0169       0.0256       0.0575       7.3315    2511.5955     -17.1250    4233.0000
 2595.6768     225.6740    1487.9532     665.2555     392.7668     406.9026     216.0000      17.7823     273.0901       0.1852       0.1184       0.0864     392.0772       0.0071       0.0145       0.0446       7.1643    2507.4678     -19.5625    4271.0000
 2595.8292     286.6058    1950.0000     686.9637     277.6099     283.6983     216.0000      17.9810     273.9275       0.1899       0.1235       0.0917     345.0434      -0.0033       0.0017       0.0303       7.3647    2498.7659     -18.1250    4235.0000
 2595.9816     202.7606    1950.0000     481.0541     179.7401     182.3861     216.0000      18.8544     247.6920       0.1690       0.1010       0.0683     281.5070       0.0068       0.0140       0.0441       7.0288    2537.3027     -19.5625    4168.0000
 2596.1340     133.1637    1425.7639     329.4494     139.9007     141.5253     216.0000      21.6727     230.7599       0.0762       0.0005      -0.0358     205.4765       0.0046       0.0102       0.0409       6.5365    2709.0886     -19.0625    4223.0000
 2596.2864     147.1959    1143.9120     317.5100     148.1002     149.5070     216.0000      22.9801     223.8754       0.0257      -0.0541      -0.0924     135.6337       0.0005       0.0051       0.0353       5.5660    2802.4783     -21.3750    4180.0000
 2596.4388     182.9578    1582.2322     436.3947     220.1847     221.6193     216.0000      21.3541     220.5262       0.0472      -0.0308      -0.0683      59.2515       0.0004       0.0056       0.0352       5.1484    2762.7017     -18.6250    4206.0000
 2596.5912     156.2158     987.1488     702.0107     427.2239     422.4398     216.0000      18.1105     220.7123       0.0704      -0.0057      -0.0423      14.0629       0.0013       0.0071       0.0365       5.0827    2719.7971     -16.2500    4261.0000
 2596.7436     148.0066     642.1761     683.0045     413.2365     409.1111     216.0000      15.6174     220.3402       0.0874       0.0127      -0.0232      -1.0240       0.0072       0.0150       0.0449       5.1000    2688.2288     -15.8750    4155.0000
 2596.8960     151.8290     245.6986     386.8564     304.1095     301.4768     216.0000      15.7812     219.9680       0.0893       0.0148      -0.0211      -0.0601       0.0028       0.0088       0.0386       5.0740    2684.7380     -16.1875    4217.0000
 2597.0484     199.0755     546.6722     903.2161     584.9365     576.4427     216.0000      16.3952     220.3402       0.0853       0.0104      -0.0256       1.3697       0.0050       0.0112       0.0415       5.1027    2692.2314     -13.6875    4193.0000
 2597.2008     207.0860     522.7666    1186.3704     957.0104     946.5012     216.0000      15.3112     220.5262       0.0793       0.0040      -0.0322       2.4197       0.0075       0.0140       0.0449       5.1447    2703.2124     -13.8750    4250.0000
 2597.3532     185.3603     524.8957     987.5770    1136.2067    1127.9641     216.0000      16.0146     219.7820       0.0789       0.0034      -0.0328       1.4803       0.0034       0.0093       0.0394       5.1762    2704.1162     -12.8125    4244.0000
 2597.5056     185.8893     773.7561    1721.8151    1478.9368    1492.5598     216.0000      16.7954     219.7820       0.0789       0.0034      -0.0328      -1.4927       0.0065       0.0138       0.0437       5.0732    2704.1091     -11.9375    4183.0000
 2597.6580     205.8312    1192.8160    1950.0000     931.7616     940.3879     216.0000      18.3130     220.0611       0.0881       0.0135      -0.0224      -4.2872       0.0026       0.0095       0.0386       5.1393    2686.9993     -10.5625    4196.0000
 2597.8104     202.1820    1209.2991    1464.8251     542.0050     550.2916     216.0000      16.3574     219.4098       0.0941       0.0200      -0.0157       3.0918      -0.0019       0.0040       0.0324       5.1502    2675.8252      -9.7500    4232.0000
 2597.9628     178.7442     464.2551     579.2652     344.9006     354.5964     216.0000      13.9787     219.5029       0.0908       0.0163      -0.0195      13.0103      -0.0026       0.0030       0.0314       5.1757    2682.1121      -9.7500    4237.0000
 2598.1152      97.7822     220.4737     278.7012     209.2251     213.6833     216.0000      12.3926     219.5959       0.0850       0.0101      -0.0259      30.2901      -0.0000       0.0067       0.0351       5.1175    2692.8145     -14.9375    4247.0000
 2598.2676      99.8111     220.7042     555.0064     283.7838     293.8647     216.0000      12.3971     219.9680       0.0812       0.0060      -0.0301      88.4094      -0.0085      -0.0039       0.0234       5.4834    2699.7202      -9.7500    4200.0000
 2598.4200     115.0115     380.1214     962.5064     292.1888     307.2813     216.0000      12.5017     223.6894       0.1031       0.0297      -0.0056     171.0377      -0.0020       0.0052       0.0327       6.6226    2659.1921     -10.8750    4158.0000
 2598.5724     122.6662     369.3316     940.5148     507.3324     525.5499     216.0000      13.1159     228.1550       0.1050       0.0317      -0.0035     269.1145      -0.0045       0.0019       0.0291       6.6438    2655.8225      -8.2500    4181.0000
 2598.7248     142.2223     321.9875     876.4199     949.8234    1008.9592     216.0000      12.4655     229.8296       0.0696      -0.0066      -0.0432     311.2953      -0.0058      -0.0002       0.0272       6.7895    2721.3164      -8.8750    4224.0000
 2598.8772     132.0064     213.8907     511.8582     981.3277    1014.8976     216.0000      12.7903     234.6673       0.0556      -0.0217      -0.0589     313.0496      -0.0088      -0.0042       0.0230       6.6779    2747.1907      -8.8125    4192.0000
 2599.0296     170.1486     310.6257     880.5298     785.1130     827.0841     216.0000      13.0035     234.4812       0.0725      -0.0034      -0.0399     275.3079      -0.0039       0.0026       0.0300       6.4397    2715.7991      -9.1875    4174.0000
 2599.1820     227.5896     549.1397    1618.0178     519.0561     560.4996     216.0000      13.7577     246.2965       0.0878       0.0131      -0.0228     232.7144      -0.0056       0.0012       0.0278       6.3209    2687.5857      -8.2500    4144.0000
 2599.3344     243.2441    1010.7351    1362.5372     334.6775     358.2133     216.0000      13.3039     245.2731       0.1078       0.0347      -0.0004     189.5378      -0.0085      -0.0026       0.0237       6.7120    2650.6431      -9.7500    4177.0000
 2599.4868     186.4589    1126.6141    1343.9890     235.8714     254.4132     216.0000      13.5207     238.2026       0.0429      -0.0354      -0.0731     152.1924      -0.0111      -0.0066       0.0199       5.7512    2770.5657      -6.8750    4175.0000
 2599.6392     180.0332    1271.1575    1526.0712     207.2895     222.3879     216.0000      13.5207     240.6215       0.0572      -0.0200      -0.0571     129.8468      -0.0085      -0.0033       0.0236       5.7522    2744.2500      -9.7500    4235.0000
 2599.7916     156.1463     776.0432    1792.1329     182.4278     193.2535     216.0000      15.7525     229.6435       0.0590      -0.0180      -0.0550     130.2919      -0.0082      -0.0030       0.0239       5.8927    2740.7935     -11.0000    4283.0000
 2599.9440     149.3290     495.2232    1620.9421     203.2712     215.0809     216.0000      15.2105     245.1801       0.0926       0.0183      -0.0174     142.0498      -0.0039       0.0033       0.0301       6.1620    2678.6780      -7.8750    4156.0000
 2600.0964     152.7016     336.7523    1950.0000     384.9246     373.0516     216.0000      15.4319     239.5981       0.0644      -0.0122      -0.0490     140.2907      -0.0057       0.0002       0.0274       6.3941    2730.9216      -9.7500    4236.0000
 2600.2488     149.0391     226.1472    1634.0839     453.5347     480.6989     216.0000      15.4263     249.6457       0.0748      -0.0010      -0.0374     130.7793      -0.0100      -0.0060       0.0212       5.7560    2711.6790      -9.5000    4221.0000
 2600.4012     141.7705     185.2702    1457.7626     707.2445     737.6802     216.0000      16.1851     251.9715       0.1527       0.0833       0.0500     139.7522      -0.0024       0.0040       0.0319       5.9463    2567.5613      -9.3750    4175.0000
 2600.5536     146.6410     201.2618    1333.0909     577.2666     591.4957     216.0000      16.7271     246.9477       0.1060       0.0328      -0.0024     168.6015       0.0016       0.0090       0.0374       6.7205    2653.9626      -8.6250    4166.0000
 2600.7060     153.4191     292.1360    1590.0012     312.3867     319.7891     216.0000      15.9198     248.4363       0.0676      -0.0087      -0.0454     189.0230      -0.0059      -0.0006       0.0270       6.6008    2724.9438      -9.7500    4197.0000
 2600.8584     129.6051     502.8899     749.0305     192.3545     197.0115     216.0000      14.8314     261.3680       0.0820       0.0068      -0.0293     196.6093      -0.0077      -0.0029       0.0245       5.9747    2698.3811      -9.7500    4250.0000
 2601.0108      94.6599     890.6124     635.4740     144.1488     148.0421     216.0000      13.0971     252.4367       0.1291       0.0578       0.0235     196.9085       0.0010       0.0083       0.0366       6.2684    2611.2031     -11.2500    4260.0000
 2601.1632     124.5742    1950.0000     492.8179     145.7789     149.7656     216.0000      12.3528     257.4605       0.2591       0.1985       0.1693     187.9928      -0.0044       0.0017       0.0292       7.3322    2370.5886     -10.0625    4202.0000
 2601.3156     160.7268     991.8275     361.5311     175.7160     180.4793     216.0000      14.6187     255.5068       0.2666       0.2066       0.1777     199.7118       0.0116       0.0219       0.0511       7.1660    2356.7813     -14.2500    4198.0000
 2601.4680      80.2914     627.7044     292.9202     238.7441     244.3767     216.0000      15.2649     222.9451       0.1425       0.0723       0.0386     181.7765       0.0173       0.0265       0.0582       7.0152    2586.3250      -9.7500    4225.0000
 2601.6204     197.3550     543.1581     377.4377     389.3069     399.3783     216.0000      16.6740     222.2008       0.0373      -0.0415      -0.0794     147.9948       0.0050       0.0104       0.0414       5.6621    2780.9397     -12.9375    4190.0000
 2601.7728     231.3925     764.3572     582.7625     476.9888     494.6718     216.0000      14.9545     221.2705       0.0509      -0.0268      -0.0642      67.8935      -0.0028       0.0014       0.0308       5.5222    2755.9104      -9.7500    4268.0000
 2601.9252     204.4247     471.6484     506.3905     254.2722     260.5483     216.0000      16.5226     220.8984       0.0739      -0.0020      -0.0384      17.4036      -0.0037       0.0016       0.0299       5.0813    2713.3499      -9.7500    4326.0000
 2602.0776     132.9609     284.6603     322.7414     162.1182     168.3495     216.0000      16.1974     220.8984       0.0987       0.0249      -0.0105      -1.7228      -0.0049       0.0012       0.0285       5.2086    2667.3752      -9.7500    4382.0000
 2602.2300     114.1937     227.1080     266.7336     132.1185     134.8718     216.0000      18.0334     221.8287       0.0678      -0.0086      -0.0452      26.7057      -0.0098      -0.0056       0.0216       5.2687    2724.6453     -10.5625    4289.0000
 2602.3824     161.5837     362.0234     521.2661     188.6037     193.1925     216.0000      17.3366     239.5981       0.1010       0.0274      -0.0080      99.9243      -0.0102      -0.0059       0.0210       5.5381    2663.1284      -9.7500    4196.0000
 2602.5348     143.9500     303.4045     664.4287     404.3426     417.2600     216.0000      18.2038     249.3666       0.1551       0.0859       0.0527     197.4618       0.0098       0.0203       0.0489       6.8879    2563.0659      -9.7500    4128.0000
 2602.6872     116.9145     181.4439     345.0958     480.6633     504.6166     216.0000      17.5794     262.7634       0.1474       0.0775       0.0440     295.3625       0.0015       0.0105       0.0378       7.0239    2577.3999      -9.7500    4239.0000
 2602.8396     119.5144     166.2098     302.2904    1035.1169    1059.5286     216.0000      18.0130     258.2978       0.1330       0.0620       0.0279     354.5003      -0.0007       0.0067       0.0344       7.2867    2603.9021      -7.7500    4196.0000
 2602.9920     158.8669     207.9874     366.5761    1046.5211    1066.3116     216.0000      17.1404     259.1351       0.0753      -0.0004      -0.0368     358.3050       0.0030       0.0108       0.0394       7.2975    2710.7083     -11.8125    4207.0000
 2603.1444     252.8398     450.1841     827.0178    1308.5721    1341.0981     216.0000      16.0373     248.5293       0.0702      -0.0059      -0.0425     313.5059       0.0004       0.0067       0.0355       6.4641    2720.0498      -2.0625    4226.0000
 2603.2968     259.4496    1455.3458    1722.8276     435.9521     444.6850     216.0000      15.4953     228.7132       0.0728      -0.0031      -0.0396     243.6907      -0.0023       0.0029       0.0317       6.5265    2715.3435      -9.7500    4220.0000
 2603.4492     185.4908    1556.0969     869.6609     262.9409     266.8220     216.0000      16.6851     225.5500       0.0639      -0.0127      -0.0496     181.3579       0.0048       0.0124       0.0417       6.3489    2731.7974      -6.5625    4249.0000
 2603.6016     148.8293    1319.1440     594.4268     215.8521     218.3514     216.0000      15.5971     223.5033       0.0603      -0.0167      -0.0536     111.1388       0.0030       0.0104       0.0393       5.6636    2738.4785      -7.3125    4264.0000
 2603.7540     161.7935    1513.9918     731.7205     211.0317     212.2031     216.0000      14.9467     222.3869       0.0678      -0.0085      -0.0452      46.4478      -0.0055      -0.0001       0.0275       5.2993    2724.5190      -7.0625    4231.0000
 2603.9064     166.9291    1747.9402     944.1898     255.2177     254.5207     216.0000      13.7325     222.2939       0.0814       0.0062      -0.0300       7.9725      -0.0072      -0.0018       0.0253       5.2627    2699.4397      -0.3125    4219.0000
 2604.0588     147.0560     795.1128    1138.2360     260.5226     260.0614     216.0000      14.0574     222.0148       0.0764       0.0008      -0.0355      -4.3645      -0.0068      -0.0008       0.0260       5.2761    2708.6069      -4.3750    4225.0000
 2604.2112     136.8718     475.1152     915.9050     324.7209     324.1999     216.0000      14.9246     222.2939       0.0766       0.0010      -0.0354      -5.1956      -0.0111      -0.0065       0.0199       5.2722    2708.3425      -5.5000    4248.0000
 2604.3636     139.9623     391.8056    1306.1694     581.0950     572.6655     216.0000      14.5158     222.5730       0.0914       0.0170      -0.0188      -6.4445      -0.0049       0.0018       0.0287       5.3290    2680.9595      -4.7500    4286.0000
 2604.5160     136.7972     322.1639    1321.5665     813.4366     792.8853     216.0000      15.4726     222.3869       0.0801       0.0048      -0.0314      -5.7180      -0.0057       0.0008       0.0276       5.3011    2701.8667      -0.7500    4207.0000
 2604.6684     127.5481     270.4636    1060.2938     708.3669     687.3186     216.0000      15.2558     222.7590       0.0915       0.0171      -0.0186      -4.7925      -0.0058       0.0007       0.0275       5.3070    2680.7488      -0.0625    4269.0000
 2604.8208     141.1071     378.7940     468.2103     394.8506     388.9266     216.0000      16.1221     223.1312       0.1030       0.0296      -0.0057      -2.0306      -0.0102      -0.0054       0.0212       5.4192    2659.4163       0.0000    4329.0000
 2604.9732     130.2808     395.7359    1346.2623     684.6565     654.1735     216.0000      15.6033     223.1312       0.0932       0.0190      -0.0167      30.0620      -0.0070      -0.0013       0.0256       5.4326    2677.5747      -1.5625    4277.0000
 2605.1256     132.7430     508.1631     907.8901     553.9833     542.9140     216.0000      15.2734     224.8058       0.0847       0.0098      -0.0263      97.9993      -0.0073      -0.0019       0.0251       5.7788    2693.3203       0.0000    4284.0000
 2605.2780     116.8019     434.5764     752.8995     534.2949     510.4069     216.0000      14.4121     224.6197       0.0524      -0.0252      -0.0625     179.9781      -0.0002       0.0072       0.0351       6.5450    2753.0620       0.0000    4233.0000
 2605.4304      92.9473     273.2334     308.3813     245.1417     239.6046     216.0000      14.6289     227.3177       0.0683      -0.0080      -0.0446     241.0519      -0.0073      -0.0024       0.0250       6.9646    2723.5952       0.0000    4269.0000
 2605.5828      88.5112     124.6761     123.7662      99.1612      97.9802     216.0000      13.9832     237.6444       0.1161       0.0438       0.0090     263.6519      -0.0007       0.0070       0.0345       6.5959    2635.1602      -0.5000    4252.0000
 2605.7352     120.9078     299.1654     360.0371     285.4598     289.6873     216.0000      14.7829     250.1109       0.1701       0.1022       0.0695     270.1299      -0.0023       0.0054       0.0324       7.4823    2535.3098       0.6875    4261.0000
 2605.8876     180.4645     672.9449     509.6862     322.1398     321.6531     216.0000      15.4332     254.5765       0.1727       0.1050       0.0725     310.0359      -0.0059      -0.0002       0.0272       7.4498    2530.4138      -1.6250    4255.0000
 2606.0400     176.0792     407.5811     353.4577     196.6082     198.9365     216.0000      17.0592     236.8071       0.0893       0.0148      -0.0211     330.4422      -0.0039       0.0008       0.0295       7.4069    2684.7542       0.3750    4235.0000
 2606.1924      74.1754     133.5758     133.6802     114.0957     115.1664     216.0000      16.1511     225.3640       0.0502      -0.0275      -0.0649     328.5015       0.0022       0.0087       0.0380       6.8129    2757.0425       5.1250    4270.0000
 2606.3448     114.7348     233.3921     320.8437     175.9584     180.2174     216.0000      16.2042     237.0862       0.0555      -0.0218      -0.0590     281.3704      -0.0054      -0.0004       0.0275       6.5265    2747.2883       0.0000    4235.0000
 2606.4972     111.4898     547.9297     722.0010     392.9697     406.9235     216.0000      14.5743     256.3441       0.0850       0.0101      -0.0259     266.4502      -0.0146      -0.0115       0.0148       6.7817    2692.6614       0.0000    4277.0000
 2606.6496      99.2509     674.3371    1950.0000    1310.1013    1444.0360     216.0000      14.0323     261.8331       0.1351       0.0643       0.0303     276.9330      -0.0116      -0.0082       0.0189       7.1121    2599.9971      -7.0625    4207.0000
 2606.8020      98.5078     402.2747    1623.3218     908.7345     948.4622     216.0000      12.6784     271.5086       0.2418       0.1797       0.1499     284.8611      -0.0009       0.0060       0.0340       7.5703    2402.6987      -3.0625    4276.0000
 2606.9544     102.1274     225.7817     831.0572     585.6823     607.6271     216.0000      13.5496     283.9751       0.2719       0.2123       0.1836     297.4696       0.0075       0.0164       0.0455       7.9505    2347.0024      -0.3125    4197.0000
 2607.1068     150.3658     190.8660     468.1117     268.9422     275.3185     216.0000      12.8992     284.5333       0.2161       0.1519       0.1210     331.3525       0.0175       0.0282       0.0588       7.6416    2450.2808       0.0000    4235.0000
 2607.2592     156.3908     345.2519     957.5952     719.6617     741.6464     216.0000      15.0671     297.6509       0.1582       0.0893       0.0562     355.8657       0.0099       0.0182       0.0485       7.3443    2557.3359       0.0625    4304.0000
 2607.4116     155.4812     611.2814    1344.5425     827.3732     845.3489     216.0000      14.9601     282.8586       0.1425       0.0723       0.0386     358.3827       0.0023       0.0078       0.0378       7.3693    2586.3486      -2.0625    4289.0000
 2607.5640     142.6714    1017.0223    1950.0000     700.0394     714.3445     216.0000      15.7189     285.8357       0.1690       0.1009       0.0682     340.2443       0.0058       0.0133       0.0429       6.9253    2537.4260      -1.3750    4286.0000
 2607.7164     135.7525    1617.0103    1950.0000     323.8110     328.1074     216.0000      13.8762     275.0439       0.1412       0.0709       0.0371     316.8566       0.0002       0.0070       0.0354       7.1996    2588.7517      -1.0000    4250.0000
 2607.8688     141.5036    1768.7247    1450.2087     200.8324     203.2148     216.0000      14.8503     272.8111       0.1504       0.0809       0.0474     282.1279      -0.0025       0.0042       0.0318       7.1176    2571.7344      -1.9375    4215.0000
 2608.0212     159.4199    1814.7527    1252.6256     157.8084     159.3980     216.0000      15.7122     246.9477       0.0850       0.0101      -0.0259     222.2314      -0.0052      -0.0001       0.0279       6.9998    2692.7527       0.0000    4266.0000
 2608.1736     165.5591    1867.3513    1053.6853     143.8732     144.9467     216.0000      15.9290     229.0853       0.0363      -0.0426      -0.0805     149.1632      -0.0073      -0.0039       0.0246       6.0262    2782.8918       2.1875    4207.0000
 2608.3260     137.3005     600.2191     665.3317     147.5601     148.1929     216.0000      13.5527     225.3640       0.0422      -0.0362      -0.0739      77.3275      -0.0050      -0.0006       0.0280       5.3260    2771.9167      -5.5000    4219.0000
 2608.4784     151.4708     598.6155     834.4619     202.7701     201.0602     216.0000      12.7993     225.3640       0.0725      -0.0034      -0.0399      28.9645      -0.0031       0.0024       0.0307       5.1502    2715.8894       0.0000    4285.0000
 2608.6308     145.6464     395.9398     943.5319     299.8126     296.8400     216.0000      13.8773     228.1550       0.0966       0.0227      -0.0129      18.5096      -0.0062      -0.0011       0.0266       5.3379    2671.2029       0.0000    4280.0000
 2608.7832     120.6972     209.5584     493.6675     377.7275     364.1688     216.0000      15.0612     227.2247       0.0909       0.0164      -0.0193      18.3582       0.0033       0.0111       0.0397       5.6666    2681.8828       2.5625    4305.0000
 2608.9356     133.5320     212.9418     230.4555     707.2240     664.4768     216.0000      15.5887     227.7828       0.0744      -0.0014      -0.0378      13.3672       0.0006       0.0077       0.0360       5.3620    2712.3662       3.8750    4310.0000
 2609.0880     138.3748     172.9154     280.8010     950.8373     896.7311     216.0000      14.1854     228.1550       0.0960       0.0220      -0.0135       2.6548      -0.0020       0.0040       0.0324       5.3094    2672.3457       5.1875    4301.0000
 2609.2404     197.2736     340.9503     621.7170    1230.5135    1146.7494     216.0000      15.8989     228.1550       0.0892       0.0146      -0.0212      -2.6352       0.0001       0.0067       0.0353       5.2678    2685.0610       5.1875    4334.0000
 2609.3928     219.2082     812.0941    1806.2263     619.9670     599.6169     216.0000      16.8890     231.1321       0.0809       0.0056      -0.0306      -2.0306       0.0013       0.0084       0.0370       5.2328    2700.4106       5.6875    4389.0000
 2609.5452     163.6933     706.1619     893.6541     344.1772     339.1715     216.0000      17.5133     237.2723       0.0782       0.0027      -0.0336       5.6205      -0.0063      -0.0014       0.0264       5.2411    2705.3677       5.3125    4256.0000
 2609.6976     137.3858     582.5174     451.5248     302.4106     294.9339     216.0000      15.5830     228.1550       0.0910       0.0166      -0.0192      28.0545      -0.0011       0.0047       0.0334       5.2680    2681.6770       9.5000    4187.0000
 2609.8500     110.1523     357.5355     319.9162     296.9639     290.1718     216.0000      14.7401     227.3177       0.0883       0.0136      -0.0222      51.3635       0.0006       0.0071       0.0359       5.4915    2686.7007       9.7500    4225.0000
 2610.0024      97.7955     230.7005     277.3652     301.7859     295.8625     216.0000      14.3327     227.2247       0.0909       0.0164      -0.0193      65.6579      -0.0034       0.0016       0.0302       5.5772    2681.8806       5.3125    4245.0000
 2610.1548     115.4734     316.2556     494.2801     391.9666     387.1182     216.0000      15.3818     227.5968       0.0933       0.0191      -0.0166      59.9358       0.0038       0.0112       0.0403       5.8072    2677.3540       9.7500    4181.0000
 2610.3072     148.2010     557.3555     885.6440     489.7473     490.1225     216.0000      16.1885     224.2476       0.0832       0.0081      -0.0280      37.4882      -0.0002       0.0048       0.0344       5.5182    2696.1250       9.7500    4230.0000
 2610.4596     148.2553     381.0451     563.3344     431.5228     439.1837     216.0000      18.0232     222.2939       0.0762       0.0006      -0.0357      15.7273       0.0059       0.0119       0.0427       5.1331    2708.9604      12.8750    4277.0000
 2610.6120      90.2445     180.8600     227.7469     151.4246     151.6556     216.0000      19.7924     222.2939       0.0654      -0.0111      -0.0479      28.4436       0.0183       0.0266       0.0592       5.3145    2728.9727      14.1250    4225.0000
 2610.7644     115.2346     311.4221     601.1972     294.4407     298.9951     216.0000      20.4722     227.9689       0.0673      -0.0090      -0.0457      87.5514       0.0098       0.0161       0.0478       5.4617    2725.4565      19.5000    4221.0000
 2610.9168     105.6302     227.2124     557.3254     439.2937     452.3628     216.0000      22.3230     230.9460       0.0647      -0.0118      -0.0486     181.0689       0.0117       0.0190       0.0505       6.4569    2730.2161      17.9375    4280.0000
 2611.0692      79.5365     128.6511     269.1603     249.8578     259.3148     216.0000      22.5398     235.4116       0.0785       0.0030      -0.0332     259.3770       0.0058       0.0118       0.0425       7.1442    2704.8455      14.8750    4240.0000
 2611.2216      72.1462     113.4590     217.5903     230.2103     238.6295     216.0000      22.7633     243.7846       0.0843       0.0093      -0.0267     303.6878       0.0048       0.0111       0.0413       7.3816    2694.0796      19.5000    4246.0000
 2611.3740     109.1312     229.2962     550.8433     436.9816     449.2612     216.0000      21.5709     253.2740       0.1094       0.0365       0.0014     334.4808       0.0028       0.0085       0.0386       7.4667    2647.6387      16.0625    4240.0000
 2611.5264     125.3630     483.4719    1724.1555     518.3237     529.0170     216.0000      19.5799     260.3445       0.1046       0.0312      -0.0040     370.2717       0.0070       0.0142       0.0444       7.4958    2656.5815      21.6250    4211.0000
 2611.6788     113.3817     682.0298    1822.4932     457.2731     469.9333     216.0000      18.1707     261.6470       0.0986       0.0248      -0.0107     404.5951       0.0077       0.0149       0.0453       7.6903    2667.6682      19.5000    4252.0000
 2611.8312      97.3327     668.9119    1238.1639     344.4046     350.6703     216.0000      16.4364     260.1585       0.0742      -0.0016      -0.0381     409.5333       0.0068       0.0135       0.0440       7.6463    2712.7952      19.5000    4250.0000
 2611.9836      92.4568     600.2484    1711.0499     430.4383     435.9943     216.0000      18.9694     265.2753       0.0585      -0.0186      -0.0556     385.8102       0.0083       0.0157       0.0462       7.3408    2741.7405      19.0000    4256.0000
 2612.1360      95.8338     578.5653    1950.0000     512.9366     513.5285     216.0000      22.5465     270.0200       0.0695      -0.0067      -0.0433     364.1276       0.0068       0.0135       0.0440       7.0245    2721.3896      19.5000    4359.0000
 2612.2884     105.6017     608.2459    1160.9757     243.9309     241.9264     216.0000      23.6163     261.6470       0.0781       0.0026      -0.0337     349.0591       0.0153       0.0240       0.0555       7.2866    2705.5251      19.4375    4268.0000
 2612.4408     117.6931     575.4367     716.9431     370.8510     368.1541     216.0000      23.3995     259.9724       0.0884       0.0137      -0.0222     340.5397       0.0102       0.0175       0.0486       7.3260    2686.5488      19.5000    4145.0000
 2612.5932     115.3398     544.3543     587.5606     361.6757     358.5797     216.0000      21.7735     253.0879       0.0685      -0.0077      -0.0444     334.2595       0.0078       0.0150       0.0455       7.2718    2723.1868      14.6875    4191.0000
 2612.7456      87.4663     300.7968     231.6933     172.4568     171.6149     216.0000      21.5709     253.6461       0.0720      -0.0040      -0.0405     332.7434       0.0016       0.0076       0.0370       7.1673    2716.8821      17.8125    4230.0000
 2612.8980     117.9295     768.5193     601.8170     286.7023     284.8076     216.0000      19.5114     253.8322       0.0746      -0.0012      -0.0376     334.6636      -0.0033       0.0017       0.0304       7.6078    2711.9851      19.1875    4252.0000
 2613.0504     116.7428     920.9976    1275.5157     226.8529     226.2653     216.0000      17.1216     256.3441       0.0493      -0.0285      -0.0659     332.8839      -0.0021       0.0033       0.0320       7.1565    2758.8037      19.5000    4416.0000
 2613.2028      90.1722     379.7632     481.8303     162.3443     162.2610     216.0000      17.5336     255.5068       0.0694      -0.0068      -0.0434     322.2632      -0.0040       0.0007       0.0294       7.0611    2721.6113      18.2500    4355.0000
 2613.3552      62.2034     173.1429     277.1226     130.6404     130.8145     216.0000      17.7504     256.3441       0.1020       0.0284      -0.0069     325.5622       0.0053       0.0124       0.0422       7.3296    2661.3750      17.6875    4338.0000
 2613.5076      41.9283      62.3844      82.5982      59.4915      59.7031     216.0000      17.2134     256.0650       0.1118       0.0391       0.0041     323.7398       0.0117       0.0208       0.0510       7.5877    2643.1763      19.5000    4232.0000
 2613.6600      62.2956     130.2302     224.2862     176.0642     176.7749     216.0000      16.5980     262.5774       0.1154       0.0429       0.0081     330.4453       0.0017       0.0084       0.0374       7.3716    2636.5635      19.5000    4231.0000
 2613.8124      84.9834     210.3613     661.1847     558.5087     560.4235     216.0000      16.3812     262.5774       0.1024       0.0289      -0.0064     341.4645      -0.0020       0.0036       0.0322       7.5294    2660.6038      19.5000    4281.0000
 2613.9648      93.9868     213.4034     670.2437     665.6608     667.7441     216.0000      17.3568     261.8331       0.0925       0.0182      -0.0175     368.8071       0.0023       0.0085       0.0381       7.3266    2678.8489      19.5000    4222.0000
 2614.1172      87.0834     189.7714     555.3658    1036.3551    1040.8047     216.0000      16.8015     266.6708       0.0949       0.0208      -0.0148     396.0893       0.0063       0.0131       0.0434       7.3079    2674.4861      19.5000    4310.0000
 2614.2696      82.6578     187.1788     963.7112     978.1038     988.3630     216.0000      15.9343     276.1603       0.1135       0.0409       0.0060     411.3798       0.0001       0.0051       0.0348       7.5521    2640.0842      14.8750    4277.0000
 2614.4220      92.2300     269.8549    1333.3667     572.4235     584.7180     216.0000      17.0183     273.9275       0.1044       0.0310      -0.0042     402.1466       0.0119       0.0202       0.0510       7.6261    2656.9180      17.7500    4265.0000
 2614.5744     106.6062     482.2232    1950.0000     375.1331     383.1357     216.0000      15.8215     270.8573       0.1006       0.0270      -0.0084     383.5073       0.0042       0.0103       0.0405       7.2811    2663.8684      18.6250    4250.0000
 2614.7268     116.6493     943.5301    1950.0000     225.4020     230.4526     216.0000      17.2498     272.5320       0.0853       0.0104      -0.0256     360.0705       0.0116       0.0197       0.0506       7.0884    2692.2366      16.8750    4213.0000
 2614.8792     113.1925    1487.4995    1950.0000     189.3688     193.2331     216.0000      16.2742     261.3680       0.0766       0.0010      -0.0353     356.0164       0.0084       0.0152       0.0461       7.1456    2708.2222      14.8750    4182.0000
 2615.0316     101.2552    1548.5457    1950.0000     232.6274     237.2050     216.0000      17.9046     262.4843       0.0880       0.0133      -0.0226     359.4747       0.0101       0.0176       0.0485       7.0552    2687.2378      19.5625    4256.0000
 2615.1840      93.0105    1236.6321    1950.0000     383.6117     391.3617     216.0000      17.2898     266.9500       0.1151       0.0426       0.0078     359.6878       0.0033       0.0094       0.0393       7.2428    2637.1086      22.2500    4263.0000
 2615.3364      92.7111     899.5037    1562.0393     607.8295     619.2001     216.0000      18.2653     265.8335       0.1249       0.0532       0.0188     359.5476       0.0073       0.0144       0.0448       7.4715    2618.9709      20.0000    4236.0000
 2615.4888      93.8792     595.8216    1525.9802     616.8443     631.2853     216.0000      16.7478     264.1589       0.0709      -0.0051      -0.0417     349.3233       0.0058       0.0116       0.0425       7.0847    2718.7632      25.3125    4256.0000
 2615.6412      87.8238     317.8120     838.1481     444.2726     456.2667     216.0000      17.0183     259.1351       0.0743      -0.0014      -0.0379     337.2645       0.0063       0.0118       0.0431       6.9768    2712.4702      24.5000    4268.0000
 2615.7936      84.6712     284.4992     441.8048     237.0550     239.2142     216.0000      15.7175     259.4142       0.0535      -0.0240      -0.0612     319.5083       0.0138       0.0212       0.0532       6.7664    2751.0200      24.5625    4292.0000
 2615.9460      93.0034     586.0300     941.4712     521.8455     534.2632     216.0000      17.2290     260.5306       0.0604      -0.0166      -0.0535     313.2379       0.0123       0.0197       0.0513       6.8237    2738.3362      28.5000    4292.0000
 2616.0984      93.4368     909.0878    1314.1125     753.4576     768.6150     216.0000      17.8782     250.4830       0.0770       0.0014      -0.0349     306.1726       0.0125       0.0200       0.0516       7.0661    2707.5332      28.1875    4286.0000
 2616.2508      83.9549     555.5981     714.1459     390.1573     392.9897     216.0000      17.7698     247.4129       0.0733      -0.0026      -0.0391     296.9251       0.0091       0.0159       0.0470       7.0086    2714.4451      28.0625    4289.0000
 2616.4032      82.4125     359.1276     479.7184     222.1179     222.0352     216.0000      15.7163     255.7859       0.0746      -0.0012      -0.0376     284.9453       0.0025       0.0079       0.0380       6.8937    2711.9719      29.3125    4247.0000
 2616.5556      67.5697     246.8348     232.6498      77.5302      77.3045     216.0000      15.7175     256.0650       0.0738      -0.0021      -0.0385     286.7672       0.0109       0.0187       0.0496       6.8478    2713.5161      30.0000    4280.0000
 2616.7080      48.4353     136.3807     109.3645      55.0652      55.2863     216.0000      17.3366     256.9954       0.0894       0.0149      -0.0209     297.9674       0.0117       0.0198       0.0508       6.9096    2684.5405      30.3750    4288.0000
 2616.8604      48.3093     126.8972      60.6882      36.9742      37.0836     216.0000      18.1013     259.6003       0.1007       0.0271      -0.0083     320.6837       0.0002       0.0057       0.0351       7.1767    2663.6592      30.5000    4284.0000
 2617.0128      40.8815      88.0021      76.9463      43.3723      43.5666     216.0000      16.6921     258.6700       0.1132       0.0405       0.0057     340.4384       0.0031       0.0094       0.0391       7.2565    2640.6709      31.4375    4269.0000
 2617.1652      70.5072     208.8288     109.3218      65.0767      65.5539     216.0000      14.3142     256.3441       0.1125       0.0399       0.0050     352.3059       0.0033       0.0097       0.0394       7.4570    2641.8315      35.5625    4296.0000
 2617.3176     124.1967     460.2133     272.7324     110.7417     112.3183     216.0000      15.6030     245.4592       0.1113       0.0385       0.0035     348.4204       0.0010       0.0059       0.0360       7.2276    2644.1807      35.1875    4294.0000
 2617.4700      97.2188     759.4086     340.3810     149.8452     152.9763     216.0000      15.1695     243.5055       0.1133       0.0407       0.0058     322.1765       0.0121       0.0200       0.0512       7.0212    2640.4304      37.8125    4354.0000
 2617.6224     142.9628    1950.0000     529.0314     205.7835     211.3871     216.0000      17.0059     250.8551       0.1118       0.0391       0.0041     294.7440       0.0095       0.0162       0.0475       7.0641    2643.1816      35.8750    4286.0000
 2617.7748     138.0748    1950.0000     629.4884     272.5996     282.3214     216.0000      15.7216     248.6223       0.0716      -0.0044      -0.0409     270.4310       0.0098       0.0164       0.0479       6.7852    2717.4558      39.0625    4276.0000
 2617.9272     199.6715    1189.0889     586.4941     305.8213     318.9277     216.0000      14.8544     245.4592       0.0799       0.0045      -0.0317     272.3389       0.0159       0.0241       0.0561       6.7907    2702.2627      37.8750    4268.0000
 2618.0796     154.5243    1950.0000     772.3861     351.3329     370.1205     216.0000      13.8798     251.8785       0.0793       0.0039      -0.0324     273.0944       0.0074       0.0137       0.0447       6.9436    2703.3821      39.1875    4257.0000
 2618.2320     177.7168    1950.0000    1132.6283     404.7916     429.6404     216.0000      16.0374     246.9477       0.0757       0.0001      -0.0363     257.8011       0.0025       0.0075       0.0379       6.8350    2709.9082      39.0625    4304.0000
 2618.3844     167.3446    1950.0000    1950.0000     431.1503     461.8851     216.0000      19.1740     240.4354       0.0716      -0.0044      -0.0410     207.4318       0.0106       0.0175       0.0490       6.5889    2717.6016      45.1250    4263.0000
 2618.5368     150.6152    1118.2058    1950.0000     471.0413     504.7817     216.0000      20.1548     233.7370       0.0400      -0.0386      -0.0763     140.7213       0.0089       0.0150       0.0465       6.1153    2775.9773      42.6250    4318.0000
 2618.6892     138.9329     613.2557    1147.2880     425.2026     450.4190     216.0000      18.7040     229.6435       0.0478      -0.0302      -0.0677      91.0895       0.0115       0.0181       0.0500       5.4531    2761.6484      44.9375    4256.0000
 2618.8416     142.1403     421.2098     681.2997     410.2286     442.5358     216.0000      18.6025     230.7599       0.0857       0.0109      -0.0251      66.4730       0.0091       0.0154       0.0469       5.5193    2691.4316      48.0625    4195.0000
 2618.9940     127.6500     275.0572     426.9399     398.5792     419.9422     216.0000      18.3797     235.4116       0.0772       0.0017      -0.0346      64.4043       0.0016       0.0063       0.0367       5.4635    2707.1228      48.7500    4268.0000
 2619.1464     216.4555     402.7406     239.5331     228.8913     235.6838     216.0000      17.2290     239.6911       0.0940       0.0198      -0.0159      65.2506       0.0004       0.0049       0.0351       5.6065    2676.1631      48.8125    4263.0000
 2619.2988     182.8278     553.1841     614.5890     420.1134     441.6245     216.0000      16.7954     240.0633       0.1075       0.0344      -0.0007      59.4440       0.0117       0.0198       0.0507       6.0735    2651.1719      48.8125    4377.0000
 2619.4512     260.4879     708.5501    1270.9911     903.2449     928.4573     216.0000      16.9099     235.2255       0.0783       0.0028      -0.0334      42.9959       0.0075       0.0142       0.0449       5.5800    2705.1558      48.8125    4322.0000
 2619.6036     175.2980     301.4485     590.9291     629.4390     648.7006     216.0000      18.0605     232.4345       0.0664      -0.0100      -0.0467      21.2677       0.0090       0.0164       0.0471       5.1711    2727.1187      48.8125    4304.0000
 2619.7560     105.4631     149.0056     241.2999     294.6334     299.2760     216.0000      16.8630     226.4804       0.0727      -0.0032      -0.0397       5.1563       0.0022       0.0074       0.0376       5.0800    2715.4905      53.7500    4289.0000
 2619.9084      96.9410     172.8986     169.7127     148.0917     150.0816     216.0000      14.9119     226.4804       0.0810       0.0058      -0.0304      -0.7195       0.0039       0.0098       0.0400       5.0600    2700.1060      52.6875    4294.0000
 2620.0608      81.4949     162.6074     166.0888     131.0466     131.7007     216.0000      15.3871     227.8759       0.0951       0.0210      -0.0146       3.5288       0.0146       0.0240       0.0548       5.2923    2674.0449      54.4375    4247.0000
 2620.2132      57.0832      82.7262      88.7693      81.6498      81.7226     216.0000      15.5007     227.5968       0.0976       0.0237      -0.0118       5.2671       0.0016       0.0075       0.0370       5.3760    2669.4614      53.3125    4256.0000
 2620.3656      90.0624     125.7618     118.0687      86.8865      86.9214     216.0000      15.7438     227.5968       0.0721      -0.0039      -0.0404       4.0650      -0.0025       0.0028       0.0314       5.2078    2716.6172      58.5625    4236.0000
 2620.5180     143.0206     283.7206     227.2132     164.9457     161.7281     216.0000      14.1135     226.7595       0.0769       0.0013      -0.0350      -2.3346      -0.0050       0.0005       0.0282       5.1696    2707.8145      54.2500    4244.0000
 2620.6704     155.6744     534.5425     633.8328     408.2458     405.6084     216.0000      13.4631     226.6664       0.0932       0.0190      -0.0167      -4.7910      -0.0047       0.0017       0.0289       5.1387    2677.5508      55.3750    4264.0000
 2620.8228     135.9120     415.3043     765.9250     652.3774     644.8281     216.0000      13.4368     227.2247       0.1064       0.0333      -0.0019      -5.1048      -0.0075      -0.0014       0.0251       5.1599    2653.0842      54.6875    4281.0000
 2620.9752     130.6881     353.6479     928.3467    1094.7958    1045.2700     216.0000      13.3726     228.5271       0.0960       0.0220      -0.0135      -3.2413      -0.0044       0.0029       0.0296       5.0912    2672.3440      51.6875    4206.0000
 2621.1276     127.7388     304.5304     739.4876    1147.1967    1053.4575     216.0000      12.1768     228.7132       0.0978       0.0239      -0.0116      -2.2972      -0.0105      -0.0051       0.0209       5.0072    2669.1108      51.9375    4231.0000
 2621.2800     125.6755     285.1036     639.4354     701.3090     619.0665     216.0000      13.1524     228.7132       0.0780       0.0026      -0.0337      -1.9484      -0.0125      -0.0079       0.0180       5.0423    2705.6382      47.5000    4240.0000
 2621.4324     122.0399     294.8464     413.4776     411.1280     363.4915     216.0000      14.7835     228.3410       0.0859       0.0111      -0.0249      -2.7542      -0.0051       0.0016       0.0284       5.1815    2691.0776      48.8125    4269.0000
 2621.5848     107.1143     279.3024     435.8607     294.2700     270.2373     216.0000      17.7073     228.3410       0.0772       0.0017      -0.0346      12.0101      -0.0068      -0.0011       0.0259       5.4355    2707.1096      48.8125    4238.0000
 2621.7372      88.7921     213.3969     291.2249     209.0533     196.9139     216.0000      19.6585     228.7132       0.0712      -0.0049      -0.0414      58.6617      -0.0077      -0.0028       0.0245       5.7897    2718.3364      46.3750    4222.0000
 2621.8896      99.9131     304.6848     438.8517     244.6721     229.4105     216.0000      20.3656     230.6669       0.0662      -0.0103      -0.0470     117.2094      -0.0047       0.0007       0.0286       6.3685    2727.5613      45.4375    4229.0000
 2622.0420      94.4297     294.9100     656.0091     397.3286     373.1552     216.0000      20.9937     232.2484       0.0671      -0.0093      -0.0460     176.3017      -0.0007       0.0057       0.0341       6.8835    2725.9519      42.8750    4279.0000
 2622.1944      99.8237     226.7822     826.9229     663.4235     621.6260     216.0000      19.2594     239.6911       0.0935       0.0192      -0.0164     216.5442      -0.0086      -0.0047       0.0230       7.0242    2677.0881      39.8125    4198.0000
 2622.3468      87.9883     131.3429     613.7180     656.3507     616.6208     216.0000      18.1765     243.7846       0.1504       0.0808       0.0474     264.2171       0.0004       0.0072       0.0357       7.4770    2571.8284      39.0625    4255.0000
 2622.4992     100.4056     103.8819     374.9862     446.8492     421.2260     216.0000      16.9507     255.3208       0.1542       0.0850       0.0517     288.7108       0.0000       0.0069       0.0352       8.0544    2564.7124      33.5625    4268.0000
 2622.6516      91.7484     164.0448     721.6072     839.9087     795.7628     216.0000      17.0591     272.8111       0.2010       0.1356       0.1041     302.8450      -0.0061      -0.0006       0.0267       7.8118    2478.1646      29.3125    4245.0000
 2622.8040      83.1317     192.1714    1138.0426    1197.7797    1159.5190     216.0000      17.6066     277.8349       0.2211       0.1573       0.1267     325.1488      -0.0012       0.0059       0.0337       8.3054    2441.0249      29.3125    4281.0000
 2622.9564      81.5267     236.4718    1388.3918    1159.0842    1125.9320     216.0000      16.9048     277.4627       0.1731       0.1054       0.0729     339.5388      -0.0010       0.0064       0.0341       8.3676    2529.7666      26.6250    4250.0000
 2623.1088      90.7571     313.3686    1344.2246     885.8640     854.4298     216.0000      16.7964     286.9521       0.1523       0.0829       0.0495     339.7257      -0.0080      -0.0022       0.0244       8.1308    2568.3223      23.3125    4256.0000
 2623.2612      99.8888     464.0328    1214.1718     527.3608     504.3700     216.0000      16.5738     285.6496       0.1155       0.0431       0.0083     320.4753      -0.0051       0.0016       0.0284       7.9282    2636.3416      19.5000    4240.0000
 2623.4136      84.2128     392.8889     547.2103     303.8261     289.5997     216.0000      15.8572     278.0209       0.1076       0.0345      -0.0006     323.9119      -0.0038       0.0029       0.0302       7.8019    2650.9478      14.3750    4248.0000
 2623.5660      88.7170     901.3025    1300.6554     376.6975     342.9690     216.0000      14.6648     280.6259       0.1256       0.0540       0.0196     354.4443      -0.0102      -0.0053       0.0212       7.9805    2617.6602      10.3750    4257.0000
 2623.7184      84.2085    1064.2527    1950.0000     433.8522     379.5313     216.0000      13.9068     276.7184       0.1469       0.0771       0.0435     390.8277      -0.0065      -0.0005       0.0264       8.3782    2578.2380       9.7500    4231.0000
 2623.8708      83.3722     563.7714    1950.0000     291.6527     271.9981     216.0000      13.2193     271.8807       0.1440       0.0740       0.0403     409.8928      -0.0043       0.0022       0.0294       8.4452    2583.5417       8.9375    4231.0000
 2624.0232      83.4762     351.7985    1867.0090     293.0154     267.1253     216.0000      13.2456     270.0200       0.1530       0.0837       0.0504     412.5385      -0.0085      -0.0034       0.0236       8.3019    2566.8831       6.8750    4308.0000
 2624.1756      79.9182     261.7484    1922.5500     540.6852     460.0695     216.0000      12.2751     278.0209       0.1711       0.1032       0.0706     408.7513      -0.0097      -0.0046       0.0220       8.4279    2533.5522       1.3125    4230.0000
 2624.3280      71.5077     214.4903    1869.8273     846.6099     744.6578     216.0000      14.3755     285.2775       0.1798       0.1127       0.0804     415.9505      -0.0106      -0.0057       0.0207       8.5628    2517.2976       0.0000    4233.0000
 2624.4804      63.8593     186.0498    1733.2828     971.1689     852.6019     216.0000      14.5661     288.1616       0.1979       0.1322       0.1007     418.4589      -0.0015       0.0063       0.0335       8.4486    2483.8706      -1.6250    4278.0000
 2624.6328      61.5622     179.9798    1456.6881     654.1711     544.4262     216.0000      13.9157     283.4169       0.2194       0.1555       0.1248     404.0818      -0.0084      -0.0033       0.0236       8.5588    2444.0459      -1.4375    4246.0000
 2624.7852      64.8810     226.1624    1751.6317    1223.8743    1088.2590     216.0000      12.3971     292.6272       0.2165       0.1524       0.1216     388.1521      -0.0110      -0.0057       0.0203       8.4985    2449.4136      -1.4375    4235.0000
 2624.9376      67.4168     329.8481    1901.3361    1407.7861    1280.7573     216.0000      12.1758     291.0456       0.2345       0.1719       0.1418     373.2324      -0.0092      -0.0038       0.0226       8.4438    2416.1028      -1.8750    4215.0000
 2625.0900      65.8402     485.7640    1950.0000    1116.0289     950.8279     216.0000      14.1988     289.5571       0.2479       0.1864       0.1568     369.0515      -0.0128      -0.0089       0.0175       8.6319    2391.3293      -6.7500    4228.0000
 2625.2424      63.8329     671.9575    1950.0000     653.9465     504.6393     216.0000      15.1345     295.1391       0.2224       0.1588       0.1282     369.1912       0.0088       0.0184       0.0474       8.4840    2438.5264      -7.4375    4250.0000
 2625.3948      64.7485     944.7795    1950.0000     742.5067     636.9973     216.0000      15.3641     298.4883       0.2018       0.1365       0.1051     388.8502       0.0040       0.0121       0.0408       8.3152    2476.6482      -6.4375    4309.0000
 2625.5472      68.0979    1329.9127    1950.0000     631.5223     547.0818     216.0000      15.7258     295.6973       0.1660       0.0977       0.0649     408.1740      -0.0055      -0.0008       0.0273       8.4162    2542.9365      -9.7500    4246.0000
 2625.6996      71.4900    1615.2489    1950.0000     595.3031     518.4424     216.0000      15.2981     290.9526       0.1549       0.0857       0.0525     413.8422      -0.0037       0.0015       0.0299       8.1100    2563.4568      -9.7500    4262.0000
 2625.8520      72.8910    1487.2700    1950.0000     626.0137     552.5764     216.0000      19.5698     286.9521       0.1663       0.0980       0.0652     411.6096      -0.0015       0.0045       0.0330       8.1953    2542.3621      -9.7500    4272.0000
 2626.0044      72.3801    1021.7270    1657.0852     463.2383     425.3167     216.0000      23.0638     285.0915       0.1551       0.0859       0.0527     412.6794       0.0021       0.0095       0.0380       8.1700    2563.0496      -9.3125    4301.0000
 2626.1568      67.3994     497.4098     733.1351     294.1517     275.6773     216.0000      27.4930     276.1603       0.1261       0.0546       0.0202     425.4587      -0.0002       0.0060       0.0347       7.8924    2616.6331      -6.5625    4266.0000
 2626.3092      71.3269     257.7787     334.6235     213.4802     201.8705     216.0000      26.2810     278.0209       0.1005       0.0269      -0.0085     424.4232       0.0005       0.0061       0.0355       7.8330    2664.0728      -9.0625    4247.0000
 2626.4616      79.0027     435.6336     774.7802     274.1582     254.0803     216.0000      25.8132     283.6029       0.0745      -0.0012      -0.0376     405.3555       0.0064       0.0132       0.0435       7.5661    2712.1130      -6.5000    4303.0000
 2626.6140      73.7656     290.9303     646.3927     299.2716     267.1335     216.0000      25.2449     278.1140       0.0502      -0.0275      -0.0649     384.1586       0.0140       0.0222       0.0537       7.2302    2757.0947      -7.7500    4249.0000
 2626.7664      55.7473     149.8333     290.3426     194.2672     171.2937     216.0000      26.4569     272.5320       0.0615      -0.0153      -0.0523     379.2207       0.0097       0.0168       0.0478       7.2902    2736.2310      -9.3750    4223.0000
 2626.9188      59.8774     181.4318     406.6624     167.3958     154.2017     216.0000      26.0322     271.3225       0.1020       0.0285      -0.0069     383.4660       0.0098       0.0172       0.0480       7.7365    2661.3479      -4.3125    4289.0000
 2627.0712      63.8209     233.9475     526.4060     216.7940     194.5961     216.0000      28.1658     274.2066       0.1335       0.0626       0.0285     381.5443       0.0017       0.0074       0.0370       8.0255    2602.9680      -8.6250    4259.0000
 2627.2236      54.7250     136.9885     327.6873     170.2190     148.7721     216.0000      25.8370     269.1827       0.1193       0.0472       0.0126     377.6176       0.0034       0.0094       0.0394       7.9034    2629.2815     -10.0000    4309.0000
 2627.3760      72.3748     182.7537     222.2382     136.7217     125.9160     216.0000      23.5740     271.6946       0.1187       0.0466       0.0119     380.0874       0.0067       0.0137       0.0439       7.8654    2630.3428      -5.8750    4283.0000
 2627.5284      58.3940     173.6221     368.2202     209.6020     185.9775     216.0000      17.1772     281.1841       0.1539       0.0847       0.0514     394.6583      -0.0012       0.0041       0.0332       8.2371    2565.2007      -6.2500    4263.0000
 2627.6808      63.2008     320.6219     744.5914     282.0085     241.6592     216.0000      15.5463     285.4636       0.1906       0.1244       0.0925     408.5665      -0.0005       0.0061       0.0345       8.2908    2497.3438      -5.5000    4290.0000
 2627.8332      57.9409     353.0404     879.2985     251.5790     229.0724     216.0000      13.6216     270.8573       0.2263       0.1630       0.1326     409.5254       0.0106       0.0209       0.0499       8.6625    2431.2915      -6.9375    4253.0000
 2627.9856      54.8648     267.0050     965.5916     239.3577     210.3179     216.0000      14.1264     279.3234       0.2295       0.1664       0.1361     400.1770      -0.0063      -0.0005       0.0266       8.6709    2425.4316      -6.5000    4246.0000
 2628.1380      56.5256     260.1709    1405.2245     353.9492     307.3328     216.0000      12.9009     280.4398       0.2169       0.1527       0.1219     396.4586      -0.0065      -0.0004       0.0265       8.5901    2448.8159      -7.8125    4268.0000
 2628.2904      58.6586     207.8015    1727.0596     723.2693     635.1281     216.0000      12.9049     292.3481       0.2120       0.1475       0.1164     406.4276      -0.0037       0.0034       0.0304       8.2644    2457.8577      -6.3750    4256.0000
 2628.4428      58.0025     175.9638    1871.7201    1113.7970    1014.7490     216.0000      11.3874     285.6496       0.2072       0.1423       0.1111     422.8217      -0.0022       0.0053       0.0325       8.7213    2466.6953      -2.4375    4241.0000
 2628.5952      56.4553     172.6696    1950.0000    1523.1678    1399.3073     216.0000      11.4889     287.6964       0.1823       0.1154       0.0832     423.9364      -0.0074      -0.0013       0.0252       8.3883    2512.6790      -6.5625    4233.0000
 2628.7476      56.5810     200.6021    1950.0000    1410.7385    1208.1157     216.0000      12.5009     295.3252       0.1853       0.1186       0.0866     419.9293      -0.0125      -0.0074       0.0182       8.2256    2507.1184      -9.3750    4252.0000
 2628.9000      56.7492     257.2422    1771.0844     729.7711     593.3933     216.0000      14.3437     300.5350       0.2005       0.1351       0.1036     405.2415      -0.0085      -0.0026       0.0238       8.2163    2479.0256      -7.1250    4268.0000
 2629.0524      55.4566     326.4376    1950.0000     443.1458     371.5178     216.0000      16.9890     299.8838       0.2236       0.1601       0.1295     387.0933      -0.0059      -0.0001       0.0272       8.2846    2436.2695      -4.1250    4295.0000
 2629.2048      53.9785     335.2434    1188.8849     217.0894     182.3194     216.0000      18.0050     298.2092       0.2288       0.1656       0.1353     377.9502       0.0043       0.0121       0.0410       8.3812    2426.8103      -9.7500    4340.0000
 2629.3572      55.4652     361.2755     552.4451     231.3536     191.2027     216.0000      16.7003     302.0236       0.2229       0.1592       0.1287     360.3589       0.0143       0.0251       0.0547       8.2192    2437.7253      -7.2500    4331.0000
 2629.5096      58.5154     319.3100    1064.9014     397.6880     300.7014     216.0000      14.0623     305.5588       0.2113       0.1467       0.1157     352.9322       0.0038       0.0117       0.0404       8.1569    2459.1462      -2.2500    4325.0000
 2629.6620      64.7646     366.4084    1950.0000     633.2390     492.7165     216.0000      11.5530     302.6748       0.1977       0.1320       0.1004     345.4163      -0.0080      -0.0032       0.0241       8.0736    2484.2837      -4.0000    4345.0000
 2629.8144      67.5504     323.9790    1499.5040    1170.9172     854.4196     216.0000      12.3283     290.3944       0.1802       0.1130       0.0808     343.8363      -0.0028       0.0037       0.0314       8.2910    2516.6868      -8.5000    4313.0000
 2629.9668      63.6440     253.5593     826.6132     685.6702     421.4656     216.0000      13.6456     296.8137       0.1427       0.0725       0.0387     336.1356      -0.0081      -0.0027       0.0241       8.0721    2586.0955      -3.8750    4304.0000
 2630.1192      60.7913     251.3132    1115.8549     837.4226     617.8063     216.0000      15.0585     303.5121       0.1470       0.0771       0.0436     329.6094      -0.0103      -0.0051       0.0211       7.8550    2578.1223     -12.1250    4301.0000
 2630.2716      59.0252     321.8660    1950.0000     804.4612     536.2000     216.0000      14.5505     301.0002       0.1643       0.0959       0.0631     329.8278      -0.0067      -0.0012       0.0260       8.0753    2545.9563      -9.7500    4292.0000
 2630.4240      57.1645     361.8181    1678.5577     493.4530     406.9678     216.0000      14.0298     295.3252       0.1958       0.1299       0.0983     339.4966      -0.0096      -0.0055       0.0217       8.2492    2487.8423      -9.5625    4293.0000
 2630.5764      56.1988     362.2128    1950.0000     226.5945     193.5714     216.0000      12.1765     293.7436       0.1722       0.1044       0.0718     329.3920      -0.0013       0.0058       0.0336       7.9988    2531.4788      -9.7500    4269.0000
 2630.7288      56.1903     342.2928    1950.0000     278.9596     206.9414     216.0000      13.9726     301.4653       0.1632       0.0947       0.0618     313.6325      -0.0057       0.0003       0.0275       7.8833    2548.0771      -8.8750    4281.0000
 2630.8812      56.7024     316.1147    1950.0000     576.3904     444.8596     216.0000      15.0013     295.1391       0.1804       0.1133       0.0811     306.0970      -0.0061      -0.0005       0.0268       7.6822    2516.1731      -9.1875    4279.0000
 2631.0336      57.3210     287.8944    1886.1362     840.1204     695.7026     216.0000      16.6378     292.3481       0.2069       0.1420       0.1108     324.1277       0.0009       0.0083       0.0365       8.3885    2467.2551      -6.0625    4332.0000
 2631.1860      58.1553     258.2159    1678.0304    1180.2189    1026.1348     216.0000      15.9593     292.3481       0.2118       0.1473       0.1163     342.1738      -0.0074      -0.0023       0.0249       8.5439    2458.1497      -9.7500    4294.0000
 2631.3384      58.7299     217.7941    1950.0000    1950.0000    1867.2992     216.0000      15.1420     295.5112       0.2165       0.1523       0.1215     345.3732      -0.0072      -0.0017       0.0253       8.5351    2449.5266      -9.7500    4312.0000
 2631.4908      58.1241     159.9506     949.0919     581.3114     486.2987     216.0000      14.9252     299.2325       0.2086       0.1438       0.1126     339.5784      -0.0091      -0.0040       0.0227       8.4888    2464.1460      -9.7500    4283.0000
 2631.6432      48.2722     114.2378     467.2202     260.6205     218.7409     216.0000      15.6036     302.3957       0.1867       0.1201       0.0881     338.0511      -0.0068      -0.0015       0.0258       8.3568    2504.5725      -8.1250    4217.0000
 2631.7956      56.8799     159.2074     943.9796     334.6295     261.0218     216.0000      16.3194     311.8851       0.1862       0.1196       0.0876     335.8624      -0.0041       0.0025       0.0297       8.2163    2505.5098      -7.2500    4253.0000
 2631.9480      58.1979     222.8022    1565.4474     330.1031     274.5205     216.0000      16.8614     312.4433       0.1892       0.1228       0.0909     330.6322      -0.0083      -0.0028       0.0239       8.3004    2499.9509      -8.3750    4310.0000
 2632.1004      58.8401     247.0892    1950.0000     179.0027     159.4894     216.0000      16.6909     312.7224       0.1952       0.1293       0.0977     330.2841       0.0047       0.0142       0.0421       8.4660    2488.8730      -8.3750    4281.0000
 2632.2528      57.6674     174.3266     257.4259     109.1369     101.0694     216.0000      15.8722     314.1179       0.2122       0.1477       0.1167     330.3924      -0.0040       0.0019       0.0297       8.5733    2457.4807      -6.8125    4316.0000
 2632.4052      56.9116     106.2803     118.3177      84.2176      78.2984     216.0000      15.7377     314.3970       0.2252       0.1618       0.1313     322.9139      -0.0039       0.0013       0.0296       8.6915    2433.2976      -9.7500    4229.0000
 2632.5576      57.7533      53.0624      75.7194      49.3583      47.0410     216.0000      15.6914     314.1179       0.2379       0.1755       0.1455     298.6562       0.0100       0.0195       0.0489       8.7377    2409.9575      -5.0625    4279.0000
 2632.7100      50.9178      26.3169      30.2636      19.4087      18.7041     216.0000      15.1494     316.7228       0.2476       0.1860       0.1564     282.2802       0.0028       0.0112       0.0393       8.7007    2391.8640      -6.6250    4295.0000
 2632.8624      40.6782      47.1277      62.8366      39.7292      38.2531     216.0000      15.1542     304.6285       0.2404       0.1783       0.1484     272.8469      -0.0117      -0.0081       0.0188       8.8541    2405.1785      -4.5625    4265.0000
 2633.0148      26.2617      52.3341      62.5017      33.6531      32.6353     216.0000      14.3877     310.0244       0.2501       0.1887       0.1592     302.3376      -0.0048       0.0008       0.0286       8.8935    2387.3816      -9.7500    4305.0000
 2633.1672      32.0232      60.9967      60.1059      31.1361      30.2125     216.0000      16.6641     310.4896       0.2156       0.1513       0.1205     349.9608      -0.0063      -0.0013       0.0264       8.6804    2451.1992      -9.3750    4287.0000
 2633.3196      36.8757      82.5931      94.8040      43.2451      41.4050     216.0000      15.4411     307.9777       0.2002       0.1348       0.1033     399.1578      -0.0050       0.0004       0.0282       8.4971    2479.5732      -9.7500    4279.0000
 2633.4720      58.9837     135.2894     160.9636      74.3084      71.0915     216.0000      15.1236     305.9310       0.1889       0.1225       0.0906     419.9784      -0.0030       0.0030       0.0310       8.4523    2500.5654       0.0000    4307.0000
 2633.6244      59.2047     124.3652     284.2013     121.8700     110.3180     216.0000      13.4968     306.3031       0.1749       0.1073       0.0749     394.9578       0.0022       0.0096       0.0382       8.3625    2526.4563      -7.9375    4302.0000
 2633.7768      57.8444     120.5121     567.8864     224.7104     193.3301     216.0000      13.1151     304.8145       0.1683       0.1002       0.0675     369.3600      -0.0018       0.0041       0.0325       8.5243    2538.6882      -3.8125    4324.0000
 2633.9292      57.4179     121.3708     723.2291     280.4654     239.6964     216.0000      14.1438     310.2105       0.1326       0.0616       0.0275     340.9741      -0.0009       0.0053       0.0338       8.7045    2604.6609      -5.8750    4308.0000
 2634.0816      62.5947     149.2441     908.8871     410.4040     336.7232     216.0000      13.6358     316.3507       0.1035       0.0300      -0.0052     344.7721      -0.0012       0.0050       0.0334       7.6564    2658.6172      -9.7500    4290.0000
 2634.2340      69.5735     205.1876     753.5382     316.1340     258.6979     216.0000      14.6068     316.9089       0.1448       0.0748       0.0412     391.0849      -0.0018       0.0046       0.0327       7.9584    2582.0298      -3.8125    4293.0000
 2634.3864      80.8715     226.7480     463.6848     199.4811     173.9530     216.0000      12.6025     323.0491       0.1630       0.0945       0.0615     446.5914      -0.0001       0.0074       0.0353       8.6949    2548.4478      -8.3125    4289.0000
 2634.5388      69.6579     124.0094     189.0305     117.5292     108.4390     216.0000      13.2121     323.0491       0.1675       0.0993       0.0666     466.5842       0.0015       0.0089       0.0373       8.6505    2540.1382      -1.6875    4302.0000
 2634.6912      98.7607     284.6144     535.1797     226.5155     190.3353     216.0000      13.1083     319.5138       0.1911       0.1249       0.0930     445.2536      -0.0063      -0.0008       0.0265       8.6534    2496.4824      -5.0625    4297.0000
 2634.8436      84.1109     377.1868    1591.9384     358.9622     266.7647     216.0000      13.5885     315.4204       0.1965       0.1307       0.0991     404.1100      -0.0153      -0.0123       0.0139       8.6903    2486.4521      -9.7500    4289.0000
 2634.9960      70.6390     288.0088    1503.0120     245.7529     234.4201     216.0000      12.9458     304.0703       0.2506       0.1893       0.1598     393.2972      -0.0061       0.0002       0.0270       8.5356    2386.3481      -2.6250    4303.0000
 2635.1484      71.2648     215.4833    1521.2739     257.9244     207.3096     216.0000      12.9679     309.2802       0.2624       0.2020       0.1730     394.6875      -0.0001       0.0074       0.0352       8.9625    2364.5122      -9.5625    4362.0000
 2635.3008      89.0085     195.9245     924.4133     177.6322     172.0269     216.0000      12.8129     316.7228       0.2330       0.1702       0.1400     424.0753       0.0073       0.0166       0.0454       8.9121    2419.0417      -8.6875    4333.0000
 2635.4532     103.8612     179.7507     462.9619     204.2579     174.5898     216.0000      12.5411     316.3507       0.2139       0.1495       0.1186     446.1010      -0.0011       0.0051       0.0336       8.8030    2454.2874      -5.2500    4328.0000
 2635.6056      67.2893     198.8089     281.9343     170.4901     152.6696     216.0000      11.5435     315.7925       0.2077       0.1428       0.1117     445.7107       0.0003       0.0070       0.0355       9.0324    2465.7327      -8.6250    4263.0000
 2635.7580      38.7130     147.7368     128.1776      94.3902      88.0061     216.0000      12.8389     312.7224       0.2139       0.1495       0.1186     445.2245      -0.0058      -0.0006       0.0272       8.7929    2454.3728      -7.3125    4217.0000
 2635.9104      33.7153     118.7742     155.0266      58.0541      55.3730     216.0000      13.0461     318.2114       0.1928       0.1267       0.0950     436.8732      -0.0070      -0.0025       0.0253       8.4358    2493.3013      -4.3750    4319.0000
 2636.0628      41.8076     270.4046     170.4812      58.5948      55.4413     216.0000      15.9728     323.8864       0.1914       0.1252       0.0934     444.6912      -0.0011       0.0055       0.0336       8.6944    2495.9351      -9.7500    4384.0000
 2636.2152      48.4422     212.7434     217.4301      47.9800      43.8339     216.0000      14.6255     320.0721       0.1779       0.1106       0.0783     442.5096      -0.0039       0.0018       0.0298       8.5342    2520.8762      -1.6875    4281.0000
 2636.3676      65.9153      89.9364      76.4867      35.5145      34.9994     216.0000      15.0153     317.0950       0.1614       0.0928       0.0598     463.4535      -0.0012       0.0052       0.0335       8.5278    2551.3811      -2.4375    4289.0000
 2636.5200      64.9547     176.5545     163.7934      56.9698      53.8774     216.0000      12.4808     304.6285       0.1466       0.0767       0.0431     483.2397       0.0032       0.0106       0.0395       8.5972    2578.8484       0.0000    4236.0000
 2636.6724      84.3681     187.0183     197.4059      72.7185      67.8620     216.0000      14.2612     306.1170       0.1433       0.0732       0.0394     507.9207       0.0017       0.0096       0.0377       8.3174    2584.9114      -2.4375    4308.0000
 2636.8248      60.2231     102.4259     134.2188      75.6275      70.8187     216.0000      13.1596     306.3031       0.1476       0.0779       0.0443     520.2408      -0.0061       0.0003       0.0270       8.3871    2576.8752      -2.0000    4268.0000
 2636.9772      91.5495     220.2860     222.5458     118.7564     111.3137     216.0000      13.7430     306.3031       0.1692       0.1012       0.0685     508.8468      -0.0080      -0.0018       0.0245       8.4241    2536.9978       0.0000    4279.0000
 2637.1296      72.6613     191.7924     223.6669     208.8222     186.1752     216.0000      11.7938     304.0703       0.1858       0.1192       0.0871     484.0658      -0.0138      -0.0097       0.0162       8.4064    2506.2317       0.0000    4285.0000
 2637.2820      78.8997      67.5584     120.9484     144.4952     133.9725     216.0000      13.2206     294.5809       0.1695       0.1016       0.0689     469.2898      -0.0064      -0.0004       0.0266       8.4095    2536.3445       2.8125    4246.0000
 2637.4344      67.4222      83.4133      70.7121     101.8796      94.6511     216.0000      13.6533     294.5809       0.1406       0.0703       0.0365     475.0085      -0.0066      -0.0007       0.0263       8.4020    2589.8354       4.8750    4344.0000
 2637.5868      42.0693      85.5022     119.9932     133.7438     125.1187     216.0000      14.7410     294.9530       0.1505       0.0810       0.0476     487.5710      -0.0084      -0.0036       0.0236       8.0853    2571.5229       6.3125    4442.0000
 2637.7392      65.2761     298.5610     266.3328     144.4273     135.2178     216.0000      14.5256     286.2079       0.1545       0.0853       0.0520     475.9145      -0.0010       0.0061       0.0339       8.0725    2564.2180       9.1250    4367.0000
 2637.8916      70.3357     693.9487     382.0801     115.0315     108.7721     216.0000      15.3407     282.3004       0.1564       0.0874       0.0542     465.8878      -0.0016       0.0053       0.0331       8.0797    2560.6257       7.5625    4311.0000
 2638.0440      65.4730     944.7289     511.1885     104.8197      99.3718     216.0000      15.3398     285.6496       0.1157       0.0433       0.0086     470.8839      -0.0035       0.0031       0.0305       8.0292    2635.8904       9.7500    4179.0000
 2638.1964      89.4415    1485.7272     610.3195     132.2754     124.7549     216.0000      15.8804     271.9737       0.0670      -0.0094      -0.0461     492.3994      -0.0031       0.0023       0.0307       7.7973    2726.0068      11.5625    4194.0000
 2638.3488      86.9490    1806.7351    1829.8177     196.5125     184.1881     216.0000      14.1990     273.7414       0.0531      -0.0245      -0.0617     503.4402      -0.0050      -0.0002       0.0280       7.7001    2751.8169      18.3125    4744.0000
 2638.5012      75.4931     541.2661    1950.0000     218.7430     207.2450     216.0000      13.5454     269.2758       0.0571      -0.0201      -0.0571     490.4494      -0.0043       0.0013       0.0292       7.4695    2744.2886      15.9375    4782.0000
 2638.6536      66.8818     315.4045    1101.4633     153.0214     148.6177     216.0000      12.5698     256.0650       0.0556      -0.0218      -0.0589     473.7446      -0.0044       0.0017       0.0292       7.6584    2747.1975      15.8750    4669.0000
 2638.8060      65.9767     243.9756     947.8613     200.9189     194.1012     216.0000      13.1072     259.9724       0.0568      -0.0205      -0.0576     464.5457      -0.0102      -0.0052       0.0212       7.4538    2744.9973      16.3125    4629.0000
 2638.9584      71.1011     198.2689     738.2891     230.6264     223.5598     216.0000      13.0536     265.3683       0.0684      -0.0079      -0.0445     462.5811      -0.0077      -0.0020       0.0247       7.4399    2723.4624      17.2500    4532.0000
 2639.1108      70.6308     137.0655     334.8613     130.7914     128.6508     216.0000      14.8963     274.2066       0.0884       0.0137      -0.0221     458.1249       0.0001       0.0088       0.0359       7.5816    2686.5149      16.5625    4415.0000
 2639.2632      77.0870     227.6097     668.5316     368.7248     361.3517     216.0000      15.7626     284.7194       0.1050       0.0317      -0.0035     450.9497      -0.0077      -0.0018       0.0248       7.7428    2655.7813      18.4375    4388.0000
 2639.4156      81.2945     381.6210    1442.2928     891.4616     882.8783     216.0000      16.0373     285.3705       0.1381       0.0675       0.0336     447.8202      -0.0058       0.0008       0.0275       7.6635    2594.5603      19.5000    4236.0000
 2639.5680      84.2222     741.2660    1950.0000    1950.0000    1950.0000     216.0000      16.3613     283.7890       0.1596       0.0907       0.0577     444.0520      -0.0090      -0.0043       0.0227       7.8186    2554.8223      21.3750    4259.0000
 2639.7204      90.1047     875.1921     982.2037     684.5948     666.4948     216.0000      15.3911     285.4636       0.1551       0.0860       0.0527     443.2194      -0.0051       0.0011       0.0284       7.9684    2562.9756      19.6875    4298.0000
 2639.8728      84.7515     411.5610     578.9874     311.4017     308.3853     216.0000      15.4995     277.6488       0.1370       0.0664       0.0324     444.1640      -0.0041       0.0018       0.0296       7.9161    2596.4902      21.8750    4356.0000
 2640.0252      75.2092     514.3610     334.1070     256.5833     250.3850     216.0000      15.1694     284.5333       0.1208       0.0489       0.0143     419.9481      -0.0035       0.0027       0.0304       7.8057    2626.4309      22.0625    4454.0000
 2640.1776      74.7718     586.6404     371.7672     203.8520     200.1202     216.0000      19.3968     287.0452       0.1221       0.0502       0.0157     368.0093      -0.0031       0.0028       0.0309       7.5798    2624.1724      21.4375    4377.0000
 2640.3300     101.0443     915.2655     584.4891     208.1780     201.4361     216.0000      24.2932     281.4631       0.1069       0.0337      -0.0014     310.2553       0.0032       0.0109       0.0396       7.5282    2652.3005      21.4375    4259.0000
 2640.4824     114.7457     751.2825     631.9631     177.8466     174.9909     216.0000      26.2505     258.0187       0.0760       0.0003      -0.0361     263.4249      -0.0004       0.0067       0.0347       6.7552    2709.4841      23.5000    4319.0000
 2640.6348     100.5874     308.1209     266.4066     157.0044     156.2223     216.0000      23.8595     255.5068       0.0707      -0.0054      -0.0419     245.6241      -0.0116      -0.0064       0.0195       6.4950    2719.1741      24.6875    4240.0000
 2640.7872      51.3846     102.5422      97.2564      71.3650      70.9035     216.0000      20.0471     244.9010       0.0991       0.0253      -0.0101     250.7791      -0.0109      -0.0052       0.0205       7.0828    2666.6670      24.5000    4354.0000
 2640.9396      68.7215     249.6908     317.0087     124.9841     123.7712     216.0000      16.6927     247.4129       0.0844       0.0095      -0.0265     279.8548      -0.0111      -0.0058       0.0201       7.6935    2693.8074      25.3750    4449.0000
 2641.0920      95.5775     311.6573     361.9400     206.6082     203.4977     216.0000      15.3982     250.2969       0.0670      -0.0094      -0.0461     310.7200      -0.0105      -0.0055       0.0208       7.2328    2726.0381      22.6250    4446.0000
 2641.2444      90.3900     457.3958     606.8755     398.4577     379.7672     216.0000      14.3142     255.2277       0.0848       0.0099      -0.0261     330.2548      -0.0088      -0.0031       0.0233       7.2767    2693.1025      24.3750    4372.0000
 2641.3968      83.3373     272.4051     813.9369     362.3183     349.8518     216.0000      14.1067     254.1113       0.1033       0.0298      -0.0054     357.8279      -0.0082      -0.0023       0.0242       7.7022    2658.9580      23.0000    4336.0000
 2641.5492      80.8541     218.2130     510.6417     592.8204     572.0028     216.0000      14.5403     258.2978       0.0914       0.0170      -0.0188     383.1336      -0.0109      -0.0059       0.0203       7.8193    2680.9717      26.2500    4318.0000
 2641.7016      89.0363     263.9690     596.5411     518.1696     507.0610     216.0000      14.8655     261.9261       0.0968       0.0229      -0.0127     402.6735      -0.0048       0.0021       0.0289       7.6422    2670.8752      22.1250    4342.0000
 2641.8540     106.0715     378.0537     573.9547     400.2667     397.6764     216.0000      14.8503     268.1594       0.0945       0.0203      -0.0153     418.6902      -0.0011       0.0073       0.0342       7.6004    2675.2290      24.6875    4272.0000
 2642.0064      92.3782     205.5174     299.5387     196.4236     196.2597     216.0000      14.9119     263.0425       0.0916       0.0172      -0.0185     424.3765      -0.0059       0.0006       0.0274       7.5903    2680.5967      22.4375    4372.0000
 2642.1588      74.9962     430.4733     211.3067     134.0698     134.0069     216.0000      13.9363     266.8569       0.0962       0.0223      -0.0133     424.2561      -0.0089      -0.0033       0.0232       7.6754    2671.9453      22.1875    4349.0000
 2642.3112      83.6303     530.1801     278.5358     140.8991     140.7472     216.0000      14.6951     270.5782       0.0914       0.0170      -0.0187     408.9460      -0.0085      -0.0030       0.0236       7.7795    2680.8511      22.3125    4270.0000
 2642.4636     125.8251     992.8870     444.3848     156.7608     156.5052     216.0000      14.0906     272.9971       0.0858       0.0110      -0.0250     401.2861      -0.0048       0.0019       0.0289       7.4551    2691.2339      21.5625    4338.0000
 2642.6160     110.5733     720.4665     452.0530     137.4315     137.2447     216.0000      13.8702     261.3680       0.0918       0.0174      -0.0183     386.6303      -0.0082      -0.0029       0.0240       7.4661    2680.1926      19.5000    4256.0000
 2642.7684      67.3767     297.0287     268.9348     120.2678     120.2540     216.0000      11.9190     257.1814       0.1040       0.0307      -0.0046     396.7183      -0.0085      -0.0031       0.0236       7.6612    2657.5369      22.1250    4285.0000
 2642.9208      60.2876     172.9386     196.1350     142.8840     142.7161     216.0000      12.4619     262.9495       0.0942       0.0201      -0.0156     411.3927      -0.0052       0.0016       0.0284       7.7718    2675.6648      24.0000    4248.0000
 2643.0732     101.2527     197.7386     420.5946     245.0195     245.3689     216.0000      13.0474     260.7167       0.0775       0.0019      -0.0344     437.5071      -0.0090      -0.0041       0.0228       7.6427    2706.7078      22.6250    4328.0000
 2643.2256     102.9383     368.5109    1680.7927     890.1641     900.0920     216.0000      14.8902     259.1351       0.0806       0.0053      -0.0308     429.3499      -0.0027       0.0036       0.0315       7.8098    2700.8621      19.5000    4571.0000
 2643.3780      99.6860     322.2522    1950.0000     969.2479     985.8749     216.0000      14.1267     260.1585       0.0592      -0.0179      -0.0549     415.1113      -0.0022       0.0042       0.0322       7.2150    2740.5317      19.5000    4529.0000
 2643.5304      87.3905     247.6468    1330.6187     359.6983     371.8759     216.0000      14.9541     258.5769       0.0885       0.0139      -0.0220     410.6891       0.0027       0.0103       0.0389       7.3253    2686.2278      19.5000    4438.0000
 2643.6828      73.7312     210.3826    1432.4857     453.5528     469.5123     216.0000      15.7128     259.6933       0.0929       0.0187      -0.0170     429.8093       0.0056       0.0137       0.0428       7.6477    2678.0522      19.5000    4355.0000
 2643.8352      62.3110     162.7588     640.0716     294.2159     304.9034     216.0000      15.3238     259.4142       0.0808       0.0056      -0.0306     452.0073      -0.0053      -0.0004       0.0277       7.6374    2700.4539      19.7500    4253.0000
 2643.9876      63.9192     227.8818     209.1308     140.8376     142.9296     216.0000      14.5607     261.9261       0.1193       0.0472       0.0126     445.7521      -0.0084      -0.0040       0.0234       7.5589    2629.2529      19.5000    4253.0000
 2644.1400      61.3460     268.0067     662.0565     254.4455     264.7201     216.0000      13.1753     261.4610       0.1419       0.0716       0.0378     434.1870      -0.0038       0.0026       0.0301       7.8052    2587.5510      20.1250    4314.0000
 2644.2924      77.5833     551.3093    1090.3342     325.0893     342.3422     216.0000      12.5934     265.5544       0.1501       0.0805       0.0470     404.1729      -0.0012       0.0063       0.0338       7.8562    2572.3738      19.5000    4253.0000
 2644.4448      85.0008     668.2892    1478.7549     256.2990     268.1198     216.0000      12.2686     259.7863       0.1300       0.0588       0.0245     371.5191      -0.0057      -0.0003       0.0273       7.6788    2609.4934      19.8125    4404.0000
 2644.5972      97.8167     390.0820     576.6001     202.8282     209.2896     216.0000      13.3288     252.9949       0.0963       0.0223      -0.0133     344.2516      -0.0003       0.0061       0.0347       7.0894    2671.8625      19.5000    4383.0000
 2644.7496      98.7377     594.3766    1699.0939     298.4215     311.4545     216.0000      14.7328     259.1351       0.0774       0.0019      -0.0344     341.7277      -0.0007       0.0054       0.0341       7.1114    2706.7310      19.5000    4351.0000
 2644.9020      94.2425     574.1497    1588.5383     476.5829     497.8774     216.0000      16.2179     266.9500       0.0871       0.0123      -0.0236     363.5717       0.0018       0.0090       0.0376       7.2764    2688.9192      19.5000    4343.0000
 2645.0544      88.4987     489.4756    1950.0000     560.2703     622.3544     216.0000      15.5675     261.4610       0.0904       0.0159      -0.0199     379.3569      -0.0005       0.0058       0.0343       7.4883    2682.7661      19.7500    4320.0000
 2645.2068      89.7921     435.3871    1827.0184     692.1722     746.3618     216.0000      15.3509     267.7872       0.0828       0.0077      -0.0283     390.2318      -0.0003       0.0066       0.0348       7.1440    2696.7637      20.1875    4304.0000
 2645.3592      98.5953     474.0522    1664.0511     475.7075     516.4343     216.0000      14.5156     251.8785       0.0639      -0.0127      -0.0495     387.4335       0.0014       0.0090       0.0372       7.3197    2731.6997      21.5625    4353.0000
 2645.5116     104.9521     653.0059    1950.0000     309.5149     329.7645     216.0000      14.9194     253.2740       0.0748      -0.0009      -0.0373     369.7011      -0.0099      -0.0047       0.0217       7.0888    2711.5420      19.5000    4305.0000
 2645.6640      98.6699     944.3206    1354.8297     218.8599     231.4100     216.0000      15.6830     247.1338       0.0902       0.0157      -0.0201     337.0440      -0.0086      -0.0025       0.0236       7.0725    2683.1687      21.8750    4376.0000
 2645.8164      91.2092    1373.3286    1214.3232     169.0270     177.4012     216.0000      16.4410     246.3895       0.1266       0.0551       0.0207     327.6021      -0.0078      -0.0009       0.0249       7.0198    2615.8047      20.0625    4415.0000
 2645.9688      91.6763    1789.3076    1164.4966     157.3445     164.6218     216.0000      15.7248     240.9936       0.1259       0.0543       0.0200     345.2251      -0.0130      -0.0079       0.0176       7.2947    2617.0796      21.1875    4319.0000
 2646.1212     106.4212    1671.7396    1277.7279     176.0667     184.1560     216.0000      14.5324     241.8309       0.1077       0.0346      -0.0005     370.4886      -0.0118      -0.0061       0.0193       7.5694    2650.7749      23.6250    4281.0000
 2646.2736     131.3663    1339.3464    1776.4287     230.2941     240.3013     216.0000      14.5378     237.2723       0.0762       0.0005      -0.0358     374.2080      -0.0093      -0.0036       0.0226       7.1020    2709.0696      25.6875    4297.0000
 2646.4260     143.0373     701.5266    1950.0000     403.5132     427.2076     216.0000      14.7365     239.3190       0.0532      -0.0243      -0.0615     355.5891      -0.0118      -0.0068       0.0191       6.9882    2751.4973      24.2500    4311.0000
 2646.5784     123.9792     383.0296     765.2134     346.6573     361.5389     216.0000      15.3868     232.0624       0.0364      -0.0425      -0.0804     342.4854      -0.0116      -0.0072       0.0192       6.6596    2782.6682      26.6875    4364.0000
 2646.7308      99.0495     264.8664     596.7463     330.2727     345.9807     216.0000      13.1105     237.3653       0.0517      -0.0259      -0.0632     334.6162      -0.0059       0.0005       0.0273       6.6625    2754.2820      29.3125    4341.0000
 2646.8832     115.0635     345.8581     318.1732     227.1086     235.9709     216.0000      14.1311     232.8066       0.0972       0.0233      -0.0123     342.3495      -0.0071      -0.0016       0.0254       6.9583    2670.2217      27.2500    4356.0000
 2647.0356     102.5755     489.8391     560.0933     297.7511     314.0509     216.0000      12.3934     248.2502       0.0918       0.0175      -0.0183     344.7876      -0.0092      -0.0036       0.0228       7.3079    2680.1274      29.3125    4327.0000
 2647.1880     136.5864    1185.6931     765.9199     382.3320     410.1479     216.0000      14.7781     246.5756       0.0948       0.0206      -0.0150     323.6873      -0.0033       0.0036       0.0308       6.9225    2674.7029      26.2500    4305.0000
 2647.3404     120.4199     437.1046     345.4298     235.7361     240.8094     216.0000      13.0548     236.1559       0.1109       0.0381       0.0031     273.0830      -0.0008       0.0063       0.0342       6.9509    2644.8926      29.3125    4308.0000
 2647.4928      78.4421     160.4281     136.6834     113.2686     115.1131     216.0000      14.8957     243.2264       0.0941       0.0200      -0.0157     212.8136      -0.0035       0.0028       0.0305       6.4889    2675.8376      27.8125    4326.0000
 2647.6452     112.9266     383.8675     388.4182     198.3596     209.1328     216.0000      14.2444     247.4129       0.1017       0.0282      -0.0072     188.0097      -0.0025       0.0040       0.0318       6.1190    2661.8601      30.0625    4373.0000
 2647.7976     168.5717     579.8228     653.6637     488.3303     506.6339     216.0000      14.5190     252.9949       0.1037       0.0303      -0.0049     183.6777      -0.0009       0.0060       0.0341       6.7441    2658.1614      29.3125    4354.0000
 2647.9500     150.3980     374.8875     551.3859     685.1009     746.1876     216.0000      13.8738     231.5042       0.0794       0.0040      -0.0322     177.8181       0.0023       0.0094       0.0383       6.3858    2703.1875      30.5000    4328.0000
 2648.1024      96.2723     160.4775     242.0821     318.1470     330.5957     216.0000      14.4783     225.5500       0.0545      -0.0229      -0.0601     165.8344       0.0013       0.0079       0.0368       5.9974    2749.0979      29.3125    4268.0000
 2648.2548      61.5691      90.0908     102.2555     170.2148     179.6727     216.0000      15.3455     229.2714       0.0646      -0.0119      -0.0487     168.1480      -0.0044       0.0012       0.0291       6.0916    2730.4111      30.5000    4302.0000
 2648.4072     107.9392     204.0418     270.6018     155.5527     162.0915     216.0000      15.6698     240.9936       0.0688      -0.0074      -0.0440     192.1124      -0.0116      -0.0077       0.0190       6.3654    2722.6497      29.3125    4356.0000
 2648.5596     151.8268     452.2445     497.3353     337.7870     355.3922     216.0000      14.5242     240.9936       0.0702      -0.0060      -0.0426     225.3890      -0.0058       0.0003       0.0274       6.5855    2720.2122      31.8125    4324.0000
 2648.7120     128.4810     389.6200     420.9895     285.4237     298.4737     216.0000      14.8438     234.4812       0.0663      -0.0101      -0.0468     238.6398      -0.0074      -0.0025       0.0249       6.6611    2727.2727      31.8750    4378.0000
 2648.8644      82.1291     174.1655     177.9251     156.0607     162.1242     216.0000      14.5195     236.8071       0.0667      -0.0097      -0.0464     245.4467      -0.0032       0.0030       0.0309       6.6209    2726.5854      32.1875    4285.0000
 2649.0168      64.2884     120.5583     122.6249     119.8966     122.2829     216.0000      15.8787     237.0862       0.1021       0.0285      -0.0068     229.4760       0.0014       0.0085       0.0371       6.6203    2661.2070      33.6250    4317.0000
 2649.1692     114.0906     255.3469     263.1581     244.7388     253.1869     216.0000      14.0378     244.9010       0.1304       0.0592       0.0250     207.7320       0.0007       0.0077       0.0361       6.8321    2608.7151      31.8750    4295.0000
 2649.3216     194.7272     688.5580     643.8226     464.4554     492.1486     216.0000      15.7845     239.8772       0.1416       0.0713       0.0375     179.2843       0.0057       0.0143       0.0431       6.6822    2588.1265      31.8750    4316.0000
 2649.4740     210.9278    1026.1128    1155.8887     464.8746     490.2741     216.0000      14.7505     239.8772       0.0650      -0.0116      -0.0484     142.4236       0.0015       0.0089       0.0373       6.4223    2729.7839      32.6875    4401.0000
 2649.6264     165.7357     596.1804     937.3448     510.3199     540.9954     216.0000      16.0358     228.1550       0.0607      -0.0162      -0.0532      96.8981      -0.0001       0.0068       0.0350       5.8804    2737.7837      33.9375    4369.0000
 2649.7788     140.1640     478.3565    1121.8888     650.7721     688.8383     216.0000      14.9395     227.5968       0.0621      -0.0147      -0.0516      45.7573      -0.0028       0.0037       0.0314       5.4553    2735.1936      31.8750    4405.0000
 2649.9312     149.4508     703.9652    1346.3444     734.4634     796.5428     216.0000      15.3633     227.0386       0.0705      -0.0056      -0.0421       7.2103      -0.0070      -0.0011       0.0257       5.2844    2719.5291      32.0000    4322.0000
 2650.0836     152.7730     788.7575    1950.0000     586.4598     640.3610     216.0000      14.9443     227.5968       0.0791       0.0037      -0.0325      -7.0951      -0.0049       0.0017       0.0287       5.3019    2703.6780      34.6875    4348.0000
 2650.2360     139.1909     758.6255    1891.5668     593.3763     639.9996     216.0000      15.2695     227.7828       0.0764       0.0007      -0.0356      -9.1279      -0.0065      -0.0000       0.0266       5.3228    2708.7253      29.3125    4305.0000
 2650.3884     121.3080     610.8401    1438.6379     629.9363     691.1469     216.0000      15.8744     228.3410       0.0714      -0.0046      -0.0411      -1.8623      -0.0121      -0.0078       0.0185       5.1118    2717.8396      35.3125    4285.0000
 2650.5408     108.3933     344.3769    1202.5817     563.6950     619.7961     216.0000      16.7462     228.9923       0.0780       0.0025      -0.0338      -0.6905      -0.0074      -0.0014       0.0253       5.3466    2705.7302      31.8125    4273.0000
 2650.6932      95.7774     232.3776     651.5240     392.0774     438.3537     216.0000      15.9888     231.5042       0.0708      -0.0053      -0.0418      -2.3036      -0.0035       0.0038       0.0307       5.1907    2718.9902      33.6250    4341.0000
 2650.8456     103.8639     243.2973    1128.6246     893.1198     963.7979     216.0000      17.1281     231.5042       0.0721      -0.0039      -0.0404      -5.3513      -0.0052       0.0017       0.0285       5.2345    2716.6584      33.1875    4303.0000
 2650.9980     114.9352     221.7171    1182.2458    1026.2272    1118.5946     216.0000      17.9952     233.9230       0.0826       0.0075      -0.0286      -7.5529      -0.0044       0.0028       0.0296       5.1597    2697.2031      33.2500    4284.0000
 2651.1504     126.3632     217.9356    1071.5961     958.6642    1021.1431     216.0000      19.7269     237.3653       0.0852       0.0103      -0.0257      -7.1595      -0.0064       0.0003       0.0267       5.3433    2692.4011      34.8750    4413.0000
 2651.3028     150.2304     280.3052    1274.1021     594.0972     628.9629     216.0000      20.1533     233.7370       0.0785       0.0030      -0.0332      -5.4338      -0.0128      -0.0083       0.0176       5.2452    2704.8586      32.6875    4404.0000
 2651.4552     164.3517     477.3907    1219.9922     430.1024     459.7173     216.0000      18.8428     235.7837       0.0683      -0.0079      -0.0446      -3.5646      -0.0098      -0.0040       0.0220       5.1761    2723.5623      37.3125    4329.0000
 2651.6076     147.1736    1022.8586    1304.6484     278.0565     297.4075     216.0000      19.7038     236.5280       0.0757      -0.0000      -0.0364      -4.0724      -0.0074      -0.0002       0.0255       5.2133    2710.0227      31.3125    4295.0000
 2651.7600     127.9553    1060.7675     921.4097     187.2828     196.8492     216.0000      18.6271     233.1788       0.0767       0.0011      -0.0352      -5.4238      -0.0126      -0.0070       0.0182       5.2464    2708.1411      38.1250    4301.0000
 2651.9124     106.1377    1100.5901     811.6157     173.9267     182.0527     216.0000      19.4352     230.7599       0.0854       0.0105      -0.0255      -5.8811      -0.0138      -0.0085       0.0165       5.2793    2692.0847      33.1875    4298.0000
 2652.0648     111.0915     889.7151     783.9893     202.5360     211.9855     216.0000      18.6837     228.9923       0.0891       0.0145      -0.0214      -3.5803      -0.0123      -0.0064       0.0187       5.1755    2685.2473      35.4375    4273.0000
 2652.2172     124.8062     479.6539     662.0099     247.7372     258.3849     216.0000      18.5753     228.9923       0.1174       0.0451       0.0104       1.1790      -0.0116      -0.0059       0.0196       5.2223    2632.8257      33.8125    4285.0000
 2652.3696     149.7119     539.6776     994.2828     423.0612     455.4633     216.0000      19.2804     228.4341       0.0793       0.0039      -0.0323       2.9957      -0.0072      -0.0011       0.0255       5.3458    2703.3774      37.3125    4346.0000
 2652.5220     168.4994     638.4817    1160.0669     705.3078     744.1896     216.0000      20.0392     225.1779       0.0634      -0.0133      -0.0501       1.3998      -0.0049       0.0005       0.0283       4.9657    2732.7451      31.0625    4311.0000
 2652.6744     165.9823     854.4844    1712.4116    1069.1355    1113.9309     216.0000      18.0880     224.2476       0.0634      -0.0133      -0.0502      -2.2738       0.0018       0.0090       0.0376       4.9196    2732.7778      34.9375    4336.0000
 2652.8268     157.1365    1059.8552    1868.5343    1021.1893    1066.1487     216.0000      16.5654     225.3640       0.0598      -0.0172      -0.0541      -1.9457      -0.0025       0.0038       0.0318       5.0505    2739.3445      34.1875    4325.0000
 2652.9792     152.4832    1278.3528    1950.0000     673.0306     711.8078     216.0000      16.6738     225.9222       0.0704      -0.0057      -0.0423       2.7337      -0.0037       0.0029       0.0303       5.1539    2719.8062      34.5625    4305.0000
 2653.1316     149.7913    1265.8196    1950.0000     605.6250     648.6373     216.0000      17.3242     224.5267       0.0731      -0.0028      -0.0393      11.5080      -0.0027       0.0038       0.0315       5.2917    2714.7869      36.2500    4378.0000
 2653.2840     149.2431    1025.8314    1950.0000     733.5915     825.9669     216.0000      18.8610     225.7361       0.0910       0.0166      -0.0192      19.0673       0.0014       0.0090       0.0372       5.5925    2681.6133      32.6250    4284.0000
 2653.4364     151.2692     775.9753    1714.5652     820.1461     869.7559     216.0000      17.4518     226.1082       0.0763       0.0007      -0.0356      20.7553      -0.0001       0.0064       0.0350       5.6488    2708.7988      36.0000    4259.0000
 2653.5888     157.0563     674.0975    1281.5830    1093.4353    1110.0613     216.0000      18.9694     227.0386       0.0782       0.0027      -0.0335      13.6065      -0.0023       0.0031       0.0318       5.2978    2705.3389      31.3125    4283.0000
 2653.7412     159.1217     683.0120    1386.9132     966.6406    1045.1061     216.0000      19.1582     227.0386       0.0650      -0.0116      -0.0483       4.6022       0.0037       0.0099       0.0398       5.1073    2729.7561      32.8125    4301.0000
 2653.8936     150.7864     788.7847    1950.0000    1084.9067    1198.6282     216.0000      18.8330     227.5968       0.0586      -0.0185      -0.0555      -0.0963       0.0084       0.0149       0.0460       4.9169    2741.6121      33.6875    4293.0000
 2654.0460     132.4657     703.6749    1197.3779     839.7280     894.3178     216.0000      20.1338     228.1550       0.0553      -0.0221      -0.0593      -1.6012       0.0067       0.0122       0.0435       5.0161    2747.7727      33.6875    4378.0000
 2654.1984     113.8410     434.9265     604.5811     494.7205     509.8795     216.0000      19.5114     228.1550       0.0589      -0.0182      -0.0552      -1.3232       0.0134       0.0208       0.0528       4.7834    2741.0969      30.0625    4328.0000
 2654.3508     117.9053     562.2332     988.4028     569.4557     581.5907     216.0000      21.6793     228.1550       0.0651      -0.0114      -0.0482      -2.6338       0.0086       0.0151       0.0463       4.9176    2729.5352      34.6875    4292.0000
 2654.5032     119.0596     623.3469    1580.5687     698.7145     712.4146     216.0000      23.0795     228.1550       0.0695      -0.0067      -0.0433      -2.3072       0.0061       0.0121       0.0429       4.9422    2721.3875      32.9375    4308.0000
 2654.6556     108.8673     408.8400    1158.6831     656.4792     664.7864     216.0000      25.3339     228.1550       0.0629      -0.0138      -0.0507      -4.1425       0.0120       0.0195       0.0510       4.9053    2733.6194      36.5000    4319.0000
 2654.8080     105.5585     402.6025     941.6245     570.1919     575.4902     216.0000      23.7080     228.7132       0.0550      -0.0224      -0.0595      -1.0037       0.0081       0.0150       0.0458       4.7948    2748.2231      31.1250    4355.0000
 2654.9604     100.6515     392.5673    1158.3711     670.2225     675.5522     216.0000      21.8742     228.7132       0.0678      -0.0085      -0.0452      -0.6077       0.0021       0.0083       0.0377       4.6598    2724.5950      35.6250    4359.0000
 2655.1128      93.5310     390.2920    1307.6094     702.2136     706.2108     216.0000      20.7037     229.5505       0.0777       0.0022      -0.0341       2.8636      -0.0028       0.0029       0.0312       4.8537    2706.2908      35.0000    4305.0000
 2655.2652      88.9628     363.8092    1290.7255     593.2625     596.2919     216.0000      20.2643     230.5739       0.0606      -0.0163      -0.0533      32.2294      -0.0030       0.0036       0.0312       5.1316    2737.9434      33.5000    4327.0000
 2655.4176      95.7614     393.7481    1036.0822     497.6176     499.7971     216.0000      19.5055     232.2484       0.0795       0.0041      -0.0321      71.4262      -0.0078      -0.0023       0.0245       5.6963    2703.0049      29.4375    4333.0000
 2655.5700      91.0732     325.3245    1390.1992     614.3362     617.2605     216.0000      17.3231     237.8305       0.0404      -0.0381      -0.0759     120.6489      -0.0102      -0.0048       0.0214       6.1870    2775.2209      29.0000    4335.0000
 2655.7224      94.3260     355.3544    1661.4479    1086.7997    1089.5887     216.0000      17.4373     239.3190       0.0740      -0.0018      -0.0382     161.8392      -0.0096      -0.0040       0.0222       5.9238    2713.0369      26.6875    4250.0000
 2655.8748      91.6997     316.7283    1736.5004    1086.3293    1089.9001     216.0000      14.8320     243.0403       0.0740      -0.0018      -0.0382     214.4928      -0.0076      -0.0013       0.0250       6.9262    2713.0618      29.3125    4309.0000
 2656.0272      90.1948     303.1270    1918.9194    1038.3713    1046.7526     216.0000      15.0352     246.3895       0.0769       0.0013      -0.0350     260.1922      -0.0077      -0.0014       0.0249       6.7856    2707.7690      27.1250    4302.0000
 2656.1796      93.4396     348.1483    1950.0000     797.2874     810.0903     216.0000      15.4688     250.2039       0.0812       0.0060      -0.0302     290.4289      -0.0068      -0.0004       0.0261       7.0144    2699.8167      19.5000    4350.0000
 2656.3320      99.3962     492.6934    1950.0000     530.2096     538.5758     216.0000      18.3993     256.2511       0.0730      -0.0029      -0.0394     304.8585      -0.0074      -0.0008       0.0254       6.9686    2714.9871      33.5000    4331.0000
 2656.4844     101.6592     812.9152    1950.0000     471.9803     479.7069     216.0000      18.1914     254.1113       0.0701      -0.0061      -0.0426     319.8896      -0.0124      -0.0074       0.0183       6.9950    2720.3677      26.1250    4365.0000
 2656.6368      98.7308    1307.8120    1950.0000     413.6233     421.8378     216.0000      16.6738     263.3217       0.0714      -0.0047      -0.0412     331.6862      -0.0116      -0.0057       0.0196       7.2037    2717.9551      27.6875    4364.0000
 2656.7892      96.3302    1559.6189    1950.0000     439.8020     448.8383     216.0000      14.0723     254.3904       0.0541      -0.0234      -0.0606     342.9570      -0.0136      -0.0085       0.0168       7.0437    2749.9355      19.8125    4368.0000
 2656.9416      97.0726    1258.8903    1950.0000     558.8173     570.7679     216.0000      13.5496     257.5536       0.0462      -0.0319      -0.0694     349.2766      -0.0132      -0.0076       0.0174       6.9658    2764.5347      29.3125    4359.0000
 2657.0940      97.7417     854.3213    1950.0000     812.8372     829.4531     216.0000      13.3411     259.2281       0.0584      -0.0187      -0.0557     358.1395      -0.0107      -0.0039       0.0212       6.9601    2741.9219      29.0625    4338.0000
 2657.2464      95.9228     629.5729    1950.0000    1022.6339    1051.6461     216.0000      13.3411     258.5769       0.0547      -0.0227      -0.0599     368.2931      -0.0132      -0.0073       0.0175       7.1566    2748.8511      23.6250    4325.0000
 2657.3988      93.7988     561.8478    1950.0000    1495.4255    1510.0468     216.0000      14.7502     266.1126       0.0470      -0.0310      -0.0685     377.2960      -0.0158      -0.0105       0.0139       7.2017    2762.9983      25.0625    4304.0000
 2657.5512      93.2668     608.0269    1950.0000    1358.5579    1368.0619     216.0000      14.9587     263.3217       0.0581      -0.0190      -0.0560     378.6480      -0.0155      -0.0107       0.0142       7.0079    2742.4797      21.9375    4318.0000
 2657.7036      93.2879     768.0450    1950.0000     972.8165     982.4763     216.0000      16.1230     262.0192       0.0654      -0.0111      -0.0479     377.8362      -0.0087      -0.0020       0.0237       6.9912    2728.9900      13.2500    4328.0000
 2657.8560      92.6079    1087.2721    1950.0000     617.5778     627.0809     216.0000      15.2507     257.5536       0.0647      -0.0119      -0.0487     373.9517      -0.0108      -0.0055       0.0205       7.0277    2730.3955      19.5000    4308.0000
 2658.0084      91.8038    1643.2876    1950.0000     391.8905     397.8802     216.0000      17.5271     253.2740       0.0460      -0.0321      -0.0697     358.7825      -0.0013       0.0063       0.0338       6.8778    2764.9233      19.5000    4318.0000
 2658.1608      90.9913    1950.0000    1558.5293     297.7072     301.9989     216.0000      19.4643     259.2281       0.0394      -0.0392      -0.0770     332.1073      -0.0075      -0.0023       0.0249       6.5134    2777.0435      19.5000    4324.0000
 2658.3132      86.3961    1721.1575    1268.7435     269.5299     273.0697     216.0000      21.2211     254.2043       0.0514      -0.0263      -0.0636     294.0443      -0.0027       0.0032       0.0314       6.4796    2754.9243      18.9375    4302.0000
 2658.4656      82.9026    1551.1704    1296.0580     293.2672     296.7598     216.0000      19.5534     250.2039       0.0446      -0.0337      -0.0712     261.7297       0.0060       0.0139       0.0432       6.0352    2767.5481      19.5000    4298.0000
 2658.6180      89.7393    1535.9553    1541.9835     386.5356     390.6932     216.0000      21.5374     251.8785       0.0446      -0.0336      -0.0712     230.6826       0.0020       0.0083       0.0376       6.1320    2767.4314      14.8750    4305.0000
 2658.7704      90.1554     880.6426    1605.5012     574.6179     580.4553     216.0000      23.7964     249.1805       0.0624      -0.0144      -0.0513     206.0549       0.0006       0.0059       0.0356       6.0029    2734.5745      16.5625    4307.0000
 2658.9228      91.4176     557.0267    1501.2388     636.1997     639.3481     216.0000      25.6808     249.3666       0.0734      -0.0025      -0.0389     186.4984       0.0069       0.0141       0.0442       6.0077    2714.2434      19.7500    4305.0000
 2659.0752      90.2670     457.3098    1249.8304     693.3717     695.4038     216.0000      22.7756     247.6920       0.0774       0.0019      -0.0344     180.7115      -0.0019       0.0034       0.0323       5.7138    2706.7180      23.1875    4289.0000
 2659.2276      90.5978     448.4343    1125.1011     431.9991     431.5500     216.0000      20.7091     245.4592       0.0648      -0.0117      -0.0485     185.9615      -0.0039       0.0011       0.0296       6.1847    2730.0632      21.6250    4300.0000
 2659.3800      92.0268     548.8707    1390.3599     472.3974     473.8251     216.0000      22.4434     251.3203       0.0700      -0.0061      -0.0427     182.5237       0.0004       0.0065       0.0355       6.0042    2720.4846      17.4375    4334.0000
 2659.5324      82.9263     466.4373     637.9678     280.4210     281.5745     216.0000      24.9242     250.2039       0.0749      -0.0008      -0.0372     174.0618       0.0063       0.0134       0.0434       5.6732    2711.3525      26.3125    4295.0000
 2659.6848      78.4953     233.0739     243.1362     155.6283     155.7665     216.0000      26.5571     251.3203       0.0652      -0.0114      -0.0482     168.8764       0.0065       0.0133       0.0436       5.9119    2729.4619      18.6875    4318.0000
 2659.8372     106.1104     629.0635     636.0668     267.9626     267.9688     216.0000      27.0991     253.2740       0.0539      -0.0236      -0.0608     183.1076       0.0077       0.0151       0.0454       5.7916    2750.3616      23.6250    4311.0000
 2659.9896     107.1090    1421.7540    1428.5997     368.8960     371.1036     216.0000      28.6728     254.2043       0.0397      -0.0390      -0.0767     207.1185       0.0072       0.0148       0.0448       6.1640    2776.6208      19.1250    4304.0000
 2660.1420      99.5767    1063.0776    1950.0000     461.3202     463.3881     216.0000      29.1064     249.3666       0.0230      -0.0570      -0.0954     237.8810       0.0015       0.0076       0.0370       6.3854    2807.4092      19.5000    4356.0000
 2660.2944      90.7850     630.6935    1950.0000     348.3580     349.3062     216.0000      28.0224     251.5994       0.0249      -0.0549      -0.0933     268.1348      -0.0002       0.0057       0.0346       6.0631    2803.9453      19.3125    4329.0000
 2660.4468      86.3231     375.2587    1345.9387     451.3994     454.3877     216.0000      26.7739     249.6457       0.0425      -0.0359      -0.0736     293.2713       0.0007       0.0070       0.0360       6.3860    2771.3721      22.8125    4358.0000
 2660.5992      81.5126     325.8288     942.6182     357.8997     360.0107     216.0000      26.6655     252.9949       0.0586      -0.0185      -0.0556     299.8376       0.0042       0.0115       0.0408       6.9074    2741.6702      21.0625    4354.0000
 2660.7516      86.9530     426.6067    1524.9872     831.3785     835.4079     216.0000      27.4243     250.7621       0.0534      -0.0241      -0.0614     296.3610       0.0015       0.0077       0.0369       6.9063    2751.2554      27.0000    4318.0000
 2660.9040      91.2022     527.9725    1724.0198    1128.7994    1127.4392     216.0000      28.2815     256.6232       0.0563      -0.0210      -0.0581     273.1724      -0.0017       0.0036       0.0325       6.6098    2745.8787      19.5625    4326.0000
 2661.0564      94.5972     607.0015    1927.8362    1554.7386    1539.8188     216.0000      28.2257     254.5765       0.0568      -0.0204      -0.0575     249.2259       0.0011       0.0071       0.0364       6.2607    2744.8699      24.3125    4318.0000
 2661.2088      94.8433     588.2399    1950.0000    1950.0000    1950.0000     216.0000      27.0333     258.0187       0.0648      -0.0117      -0.0485     235.5604       0.0035       0.0101       0.0397       6.2978    2730.0725      24.5625    4310.0000
 2661.3612      92.3421     521.2676    1583.5118    1370.8201    1349.1777     216.0000      26.1761     254.6695       0.0596      -0.0174      -0.0544     243.5021       0.0043       0.0112       0.0408       6.4468    2739.7024      19.8125    4324.0000
 2661.5136      87.0786     448.9531    1183.2860    1056.9332    1031.0343     216.0000      24.0572     261.6470       0.0666      -0.0099      -0.0466     264.0357      -0.0031       0.0024       0.0308       6.8102    2726.8684      24.8750    4279.0000
 2661.6660      84.1033     401.9795     888.2567     723.6951     697.5185     216.0000      23.5152     259.0421       0.0597      -0.0173      -0.0543     278.7850      -0.0032       0.0034       0.0309       6.9960    2739.6101      19.5000    4274.0000
 2661.8184      68.4118     216.4654     332.1526     269.1111     257.6053     216.0000      20.9072     262.4843       0.0479      -0.0301      -0.0675     285.3188      -0.0080      -0.0020       0.0245       6.8021    2761.3923      22.0625    4331.0000
 2661.9708      78.5334     508.4948     971.5516     531.9254     496.4820     216.0000      19.9835     263.3217       0.0427      -0.0357      -0.0734     282.5906      -0.0054       0.0017       0.0282       6.7788    2771.0667      19.5625    4297.0000
 2662.1232      76.1135     654.1402    1442.1302     762.1592     730.4935     216.0000      17.3820     263.8798       0.0376      -0.0412      -0.0791     280.9072      -0.0094      -0.0040       0.0225       6.6284    2780.4436      21.9375    4331.0000
 2662.2756      71.8101     757.6464    1950.0000    1248.6040    1174.3143     216.0000      16.4074     258.8560       0.0477      -0.0302      -0.0677     287.0698      -0.0084      -0.0027       0.0238       6.8780    2761.6992      19.5000    4355.0000
 2662.4280      67.1619     615.5763    1804.3572     491.2642     490.4264     216.0000      16.1456     252.3437       0.0474      -0.0306      -0.0680     300.0481      -0.0132      -0.0088       0.0171       7.0959    2762.2739      20.5000    4293.0000
 2662.5804      65.3230     469.5176    1716.3768     234.1542     236.1938     216.0000      16.2489     260.9027       0.0505      -0.0272      -0.0646     305.6614      -0.0139      -0.0087       0.0164       6.9534    2756.5728      19.0625    4336.0000
 2662.7328      65.7422     284.7520    1950.0000     159.1018     160.7860     216.0000      16.1460     263.5077       0.0704      -0.0057      -0.0423     303.9246      -0.0122      -0.0063       0.0189       6.9159    2719.7651      19.5000    4369.0000
 2662.8852      59.5745     168.6108     521.1806     126.0384     127.6115     216.0000      17.7299     264.9962       0.1002       0.0266      -0.0088     299.7272      -0.0145      -0.0105       0.0152       7.2804    2664.5413      16.6875    4336.0000
 2663.0376      43.5198      82.3649     160.5195      97.4656      98.3088     216.0000      19.5708     262.4843       0.1176       0.0454       0.0107     301.2807      -0.0139      -0.0121       0.0154       7.1141    2632.4219      19.5000    4366.0000
 2663.1900      24.4005      57.0544      80.6170      98.9899      99.3694     216.0000      22.9311     268.6245       0.1873       0.1208       0.0888     275.4641       0.0110       0.0184       0.0496       7.2284    2503.4917      14.5000    4308.0000
 2663.3424      15.7176      24.7303      34.7788      57.4914      57.6072     216.0000      26.2145     271.6946       0.3444       0.2908       0.2650     243.9220       0.0381       0.0521       0.0856       7.7481    2212.7820      19.5000    4304.0000
 2663.4948       6.7955       9.9003      11.7067      17.4704      17.4820     216.0000      31.0810     276.9976       0.2445       0.1826       0.1529     242.3615       0.0645       0.0817       0.1188       8.2503    2397.7583      17.1250    4334.0000
 2663.6472      16.8905      26.2604      33.5089      49.3444      49.4194     216.0000      27.1739     257.7396       0.0803       0.0050      -0.0312     277.8263       0.0758       0.0971       0.1334       7.0274    2701.5259      16.6875    4320.0000
 2663.7996      37.8124      83.3955     126.0052      54.5281      54.5760     216.0000      20.6806     254.0183       0.0380      -0.0408      -0.0786     315.4256      -0.0242      -0.0248       0.0007       6.9690    2779.7595      14.6250    4334.0000
 2663.9520      67.1438     378.7471     862.7610     135.4632     135.9041     216.0000      13.4558     256.8093       0.0413      -0.0372      -0.0749     319.6423      -0.0308      -0.0302      -0.0080       6.9764    2773.5430      12.3750    4372.0000
 2664.1044      67.8818    1796.3732     916.7664      79.0534      78.9900     216.0000      13.2438     254.9486       0.0310      -0.0483      -0.0864     319.6912      -0.0211      -0.0161       0.0067       6.8831    2792.5681      13.9375    4365.0000
 2664.2568      64.4312     862.4921     360.0322      55.5343      55.3866     216.0000      14.1110     263.8798       0.0415      -0.0370      -0.0747     321.8279      -0.0188      -0.0128       0.0101       6.7439    2773.1934       9.8125    4382.0000
 2664.4092      92.7600     691.7070     285.7382      52.0257      51.8041     216.0000      14.9533     270.7643       0.0413      -0.0372      -0.0749     320.5032      -0.0188      -0.0127       0.0101       6.8412    2773.6331       9.7500    4358.0000
 2664.5616      75.3044     417.6187     274.0421      78.4482      77.6586     216.0000      15.0676     270.3922       0.0273      -0.0523      -0.0906     319.0555      -0.0221      -0.0176       0.0052       6.9464    2799.4778       9.7500    4360.0000
 2664.7140      84.2560     354.0966     453.8186     114.6071     113.5108     216.0000      15.5012     271.3225       0.0255      -0.0543      -0.0926     321.4460      -0.0193      -0.0144       0.0091       6.8800    2802.8162       9.7500    4423.0000
 2664.8664      85.4774     307.2231     715.6072     220.6415     217.3858     216.0000      15.9402     268.0663       0.0441      -0.0341      -0.0717     328.1121      -0.0145      -0.0086       0.0158       6.6656    2768.3357       4.8125    4359.0000
 2665.0188      85.6851     326.0449     904.5060     242.5291     236.7349     216.0000      17.7628     266.6708       0.0480      -0.0300      -0.0674     336.2603      -0.0084      -0.0014       0.0242       7.0290    2761.2500       9.7500    4417.0000
 2665.1712      95.3831     467.1848    1948.2617     398.9325     392.6794     216.0000      20.5812     264.4380       0.0320      -0.0473      -0.0853     333.2133      -0.0055       0.0014       0.0280       7.0636    2790.8003       0.6875    4421.0000
 2665.3236      96.6445     704.9199    1950.0000     328.7373     325.9390     216.0000      24.7864     262.7634       0.0171      -0.0633      -0.1020     321.2118      -0.0025       0.0039       0.0317       6.8326    2818.3083       4.3125    4405.0000
 2665.4760      93.4359     601.2876    1092.3156     220.7557     220.0080     216.0000      27.2937     256.2511       0.0247      -0.0551      -0.0935     302.7349      -0.0018       0.0042       0.0326       6.4915    2804.2246       2.5000    4392.0000
 2665.6284      93.0047     352.5953    1056.4807     216.0054     215.2805     216.0000      27.3939     254.3904       0.0384      -0.0403      -0.0781     294.2927       0.0086       0.0179       0.0470       6.7160    2778.8901       2.2500    4351.0000
 2665.7808      91.1513     225.5427     821.6207     222.6175     221.7756     216.0000      23.9474     263.8798       0.0366      -0.0423      -0.0802     307.9174      -0.0054       0.0009       0.0279       6.9854    2782.3823       0.8125    4393.0000
 2665.9332      76.4611     138.0934     475.4224     117.0262     116.6765     216.0000      19.1134     264.9962       0.0446      -0.0336      -0.0712     332.4745      -0.0122      -0.0068       0.0187       7.2693    2767.4307       0.0000    4354.0000
 2666.0856      88.7138     167.5449     642.3777     159.9017     159.3785     216.0000      16.2979     266.1126       0.0584      -0.0187      -0.0558     360.7218      -0.0121      -0.0059       0.0191       7.3493    2741.9878       0.0000    4361.0000
 2666.2380      82.8575     261.9449     626.7382     168.4692     169.0315     216.0000      13.6964     270.2061       0.0717      -0.0043      -0.0408     384.5179      -0.0172      -0.0120       0.0120       7.3780    2717.2678      -2.1250    4402.0000
 2666.3904      87.1550     450.8732     514.0353     160.2241     160.9959     216.0000      13.3235     268.7176       0.0927       0.0184      -0.0173     402.7924      -0.0161      -0.0108       0.0135       7.6034    2678.5681      -3.0625    4409.0000
 2666.5428      86.6318     817.1729     624.7374     170.0062     170.8053     216.0000      12.5701     273.1832       0.0827       0.0076      -0.0285     416.6491      -0.0105      -0.0031       0.0215       7.6679    2697.0525      -5.7500    4314.0000
 2666.6952      97.2794    1950.0000     793.0482     262.6597     263.5026     216.0000      12.8267     271.9737       0.0620      -0.0148      -0.0517     416.9228      -0.0115      -0.0050       0.0200       7.3528    2735.2739      -1.9375    4398.0000
 2666.8476     101.5901    1557.5341    1568.3665     544.2906     542.5995     216.0000      14.4566     272.8111       0.0564      -0.0209      -0.0580     412.6139      -0.0142      -0.0088       0.0160       7.3085    2745.6833      -9.7500    4375.0000
 2667.0000      93.1152     941.9772    1427.3694     720.5428     712.2285     216.0000      15.2100     268.6245       0.0754      -0.0003      -0.0367     408.5522      -0.0107      -0.0044       0.0210       7.3994    2710.5469      -7.1875    4349.0000
 2667.1524      88.7233     766.3156    1917.3799     485.2284     463.1927     216.0000      15.4173     270.9504       0.0710      -0.0050      -0.0416     411.5179      -0.0126      -0.0066       0.0184       7.4671    2718.6018      -9.7500    4367.0000
 2667.3048      90.8722     787.1877    1950.0000    1180.4138    1139.2764     216.0000      15.7425     270.3922       0.0737      -0.0021      -0.0386     409.8513      -0.0111      -0.0047       0.0204       7.4425    2713.6453      -9.5625    4374.0000
 2667.4572      97.4069     894.4343    1950.0000    1291.4702    1265.2148     216.0000      14.8762     273.7414       0.0814       0.0062      -0.0299     399.6203      -0.0124      -0.0063       0.0187       7.3613    2699.3682      -8.8125    4406.0000
 2667.6096      99.8539     928.7507    1950.0000    1306.6563    1338.6597     216.0000      14.8458     270.2991       0.0809       0.0057      -0.0305     393.9004      -0.0081      -0.0012       0.0246       7.3178    2700.2563      -9.6250    4440.0000
 2667.7620      96.0331     876.0236    1950.0000     566.5680     555.8542     216.0000      14.1902     268.9037       0.0669      -0.0095      -0.0462     393.5318      -0.0104      -0.0047       0.0212       7.2745    2726.1602      -9.7500    4398.0000
 2667.9144      93.1362     897.8943    1950.0000     439.6893     427.2428     216.0000      15.0619     275.8812       0.0746      -0.0012      -0.0376     399.8830      -0.0064       0.0005       0.0268       7.3456    2712.0012      -9.7500    4381.0000
 2668.0668      95.3249    1071.3492    1950.0000     316.4169     311.3968     216.0000      14.9907     269.4618       0.0566      -0.0207      -0.0578     395.6487      -0.0060       0.0010       0.0273       7.4119    2745.3572      -9.7500    4402.0000
 2668.2192     100.3605    1327.1406    1950.0000     296.9080     291.6032     216.0000      13.4746     265.2753       0.0422      -0.0362      -0.0739     391.8476      -0.0131      -0.0082       0.0173       7.1913    2771.9233     -12.6250    4385.0000
 2668.3716     101.4626    1306.6899    1950.0000     301.3372     295.3353     216.0000      14.0166     272.9971       0.0479      -0.0301      -0.0675     386.1196      -0.0106      -0.0043       0.0211       7.1177    2761.4497      -9.7500    4407.0000
 2668.5240      96.4027     984.2653    1950.0000     349.4006     340.1371     216.0000      14.8254     270.5782       0.0514      -0.0263      -0.0636     386.5192      -0.0155      -0.0110       0.0140       7.3162    2754.9993     -11.8125    4390.0000
 2668.6764      90.6242     777.7732    1696.3781     560.4417     547.6396     216.0000      16.4550     267.2290       0.0458      -0.0324      -0.0699     384.9380      -0.0092      -0.0028       0.0230       7.2208    2765.3459      -9.7500    4348.0000
 2668.8288      90.7422     865.4175    1850.7247     648.2508     617.9424     216.0000      15.1625     267.2290       0.0339      -0.0452      -0.0832     376.8387      -0.0129      -0.0075       0.0178       7.0693    2787.2976     -11.6250    4429.0000
 2668.9812      94.1962    1064.0265    1950.0000    1009.5552     954.3414     216.0000      16.3762     266.2987       0.0408      -0.0377      -0.0754     363.6956      -0.0134      -0.0078       0.0171       7.1272    2774.4902     -11.9375    4343.0000
 2669.1336      96.7285    1296.3385    1950.0000     690.2280     662.5759     216.0000      16.5930     265.7405       0.0476      -0.0304      -0.0679     349.2467      -0.0146      -0.0093       0.0155       6.9048    2762.0000      -9.7500    4399.0000
 2669.2860      94.5330    1371.2921    1950.0000     631.8484     604.4633     216.0000      17.7770     267.5081       0.0619      -0.0149      -0.0518     350.9743      -0.0119      -0.0058       0.0193       7.0133    2735.5073      -9.7500    4394.0000
 2669.4384      89.0526    1134.9481    1950.0000     684.0811     651.8156     216.0000      18.4872     268.1594       0.0532      -0.0243      -0.0616     361.8653      -0.0124      -0.0069       0.0185       7.3408    2751.6035     -10.0000    4356.0000
 2669.5908      83.9293     731.9714    1950.0000    1401.6827    1290.4518     216.0000      18.9208     265.5544       0.0482      -0.0298      -0.0672     368.1212      -0.0040       0.0041       0.0303       7.1900    2760.9050      -9.7500    4380.0000
 2669.7432      81.2673     472.1183    1944.7543     786.6173     735.8072     216.0000      18.8124     265.2753       0.0504      -0.0274      -0.0647     364.9070      -0.0053       0.0022       0.0284       6.8640    2756.7810      -9.7500    4396.0000
 2669.8956      80.5317     355.5693    1135.4574     477.5073     434.5117     216.0000      19.5302     264.0659       0.0545      -0.0229      -0.0601     354.3856      -0.0133      -0.0085       0.0171       7.0316    2749.2109      -9.7500    4351.0000
 2670.0480      87.7578     433.8013    1950.0000     611.2863     576.0645     216.0000      19.9574     262.0192       0.0517      -0.0259      -0.0632     344.5184      -0.0091      -0.0028       0.0231       7.0089    2754.2959      -9.7500    4376.0000
 2670.2004      91.9834     537.2513    1950.0000     612.0978     588.0912     216.0000      20.1109     263.1356       0.0504      -0.0273      -0.0647     327.7068      -0.0191      -0.0162       0.0087       7.0883    2756.7625      -9.7500    4380.0000
 2670.3528      90.7604     549.5565    1603.5637     349.0560     325.7606     216.0000      18.4661     258.5769       0.0516      -0.0261      -0.0634     309.5624      -0.0074      -0.0008       0.0254       6.8423    2754.5676      -9.7500    4373.0000
 2670.5052      84.7751     499.0809    1950.0000     359.0278     333.1466     216.0000      18.6827     258.2978       0.0711      -0.0050      -0.0415     297.8704      -0.0057       0.0008       0.0276       6.8334    2718.5356      -9.7500    4380.0000
 2670.6576      76.8256     410.2236    1950.0000     454.8376     429.0474     216.0000      19.3964     264.2520       0.0803       0.0050      -0.0312     290.8697      -0.0101      -0.0051       0.0213       6.7904    2701.4561      -9.7500    4370.0000
 2670.8100      72.3026     324.2010    1095.5363     461.1489     424.6214     216.0000      20.3300     266.6708       0.0786       0.0032      -0.0331     295.5766      -0.0066      -0.0008       0.0262       6.8326    2704.5818      -9.7500    4421.0000
 2670.9624      77.9217     402.0917    1633.0686     590.9800     537.7473     216.0000      19.9030     267.9733       0.0769       0.0013      -0.0350     306.3755      -0.0045       0.0020       0.0292       7.0299    2707.7666      -9.1875    4357.0000
 2671.1148      88.0901     569.7338    1950.0000     604.1420     547.9547     216.0000      21.2037     263.3217       0.0481      -0.0298      -0.0673     326.7670      -0.0069      -0.0010       0.0258       7.1630    2761.0220      -9.6875    4382.0000
 2671.2672      94.3218     860.3002    1950.0000     587.1677     560.0046     216.0000      19.0654     264.4380       0.0519      -0.0257      -0.0630     336.1840      -0.0093      -0.0035       0.0227       7.1722    2753.9365      -9.3125    4325.0000
 2671.4196      94.8489    1135.7220    1950.0000     459.8170     445.4813     216.0000      17.6563     263.1356       0.0489      -0.0289      -0.0664     336.5116      -0.0061       0.0015       0.0275       7.0580    2759.4961      -9.0000    4377.0000
 2671.5720      92.7464    1099.6165    1950.0000     438.4833     430.7656     216.0000      15.9219     264.2520       0.0540      -0.0235      -0.0607     334.3334      -0.0139      -0.0089       0.0163       7.2615    2750.1243      -9.0000    4362.0000
 2671.7244      88.4322     833.1655    1950.0000     451.4914     445.7881     216.0000      17.1400     268.9037       0.0363      -0.0426      -0.0805     339.5617      -0.0129      -0.0075       0.0177       7.1347    2782.8196      -9.7500    4361.0000
 2671.8768      83.7602     612.2003    1619.1760     296.2807     295.2533     216.0000      17.2484     264.4380       0.0396      -0.0391      -0.0769     358.8531      -0.0097      -0.0035       0.0223       7.1690    2776.8093      -9.5000    4358.0000
 2672.0292      82.8887     619.7268    1531.9218     437.0865     435.4654     216.0000      15.1889     266.1126       0.0623      -0.0145      -0.0513     387.4822      -0.0138      -0.0085       0.0165       7.3064    2734.7148      -9.6875    4349.0000
 2672.1816      87.5050     676.0224    1950.0000     562.7827     561.7158     216.0000      14.6867     268.7176       0.0820       0.0069      -0.0292     416.8489      -0.0121      -0.0056       0.0191       7.6598    2698.2419      -9.3750    4326.0000
 2672.3340      92.2924     765.1948    1840.4148     606.7742     603.2953     216.0000      15.1202     268.1594       0.0677      -0.0086      -0.0453     428.8351      -0.0130      -0.0067       0.0179       7.6896    2724.6802      -8.3750    4393.0000
 2672.4864      97.5308     913.1564    1916.8044     424.0339     425.1114     216.0000      16.0813     270.2991       0.0540      -0.0235      -0.0607     418.6015      -0.0187      -0.0142       0.0098       7.3998    2750.1055      -9.7500    4367.0000
 2672.6388     101.7202    1205.9017    1950.0000     878.7905     878.9410     216.0000      15.2694     271.1364       0.0571      -0.0201      -0.0572     398.2191      -0.0132      -0.0063       0.0179       7.2798    2744.4480      -7.5000    4380.0000
 2672.7912     102.1785    1664.5614    1950.0000     859.7650     860.8248     216.0000      14.5061     269.8340       0.0579      -0.0192      -0.0563     379.5168      -0.0181      -0.0128       0.0109       7.3468    2742.9055      -9.7500    4341.0000
 2672.9436      99.9687    1950.0000    1838.2814     618.7197     620.3874     216.0000      13.8965     271.9737       0.0589      -0.0182      -0.0552     372.6177      -0.0210      -0.0168       0.0065       7.3712    2741.1094      -9.7500    4343.0000
 2673.0960      97.9989    1950.0000    1439.4142     394.1602     395.7934     216.0000      13.5713     271.1364       0.0383      -0.0404      -0.0783     369.0124      -0.0140      -0.0073       0.0167       7.4122    2779.1467      -9.7500    4325.0000
 2673.2484      97.3756     870.9633     740.2458     239.9084     241.0659     216.0000      14.7129     270.0200       0.0273      -0.0524      -0.0906     373.4436      -0.0193      -0.0154       0.0088       7.0368    2799.5293      -9.7500    4349.0000
 2673.4008     104.6177     429.1147     369.5904     177.6888     178.3403     216.0000      15.7651     263.3217       0.0653      -0.0112      -0.0480     380.9972      -0.0175      -0.0143       0.0110       7.3656    2729.2341      -9.7500    4375.0000
 2673.5532      73.1217     252.8691     332.9866     180.0770     181.5835     216.0000      18.4750     270.3922       0.0735      -0.0023      -0.0388     392.1881      -0.0078      -0.0027       0.0244       7.6329    2713.9490      -9.7500    4367.0000
 2673.7056      69.7422     176.7302     284.7835     158.2372     158.8984     216.0000      23.0568     271.5086       0.0783       0.0028      -0.0335     391.8359       0.0182       0.0298       0.0600       7.5124    2705.2161     -12.3750    4416.0000
 2673.8580      51.6908     114.9691     144.7167     104.6349     105.1310     216.0000      29.1209     265.5544       0.0755      -0.0002      -0.0365     394.1395       0.0238       0.0361       0.0673       7.4869    2710.2583     -10.8750    4390.0000
 2674.0104      36.9268      44.7828      54.6544      50.1391      50.1852     216.0000      29.9866     269.2758       0.0286      -0.0510      -0.0892     399.7820       0.0009       0.0081       0.0364       7.3214    2797.1687      -9.7500    4322.0000
 2674.1628      72.6695     141.7643     172.3810     130.8052     131.2805     216.0000      27.3028     268.7176       0.0279      -0.0516      -0.0899     411.1130      -0.0150      -0.0116       0.0143       7.1470    2798.3101      -9.7500    4364.0000
 2674.3152     111.8012     537.4230     653.0174     416.0849     419.2300     216.0000      21.9079     270.5782       0.0528      -0.0248      -0.0620     423.2261      -0.0131      -0.0080       0.0174       7.5291    2752.3259     -10.0625    4378.0000
 2674.4676      96.4835    1658.0831    1893.4485     606.7277     610.2039     216.0000      20.6087     273.9275       0.0718      -0.0041      -0.0407     426.4138      -0.0043       0.0044       0.0301       7.7150    2717.0950     -11.3125    4392.0000
 2674.6200      92.7801    1617.0068    1950.0000     514.6805     516.7778     216.0000      17.7904     268.6245       0.0709      -0.0052      -0.0417     421.2690      -0.0132      -0.0075       0.0175       7.4963    2718.8359     -12.3750    4433.0000
 2674.7724      88.6137    1372.6350    1926.7421     527.6973     528.4672     216.0000      17.4914     269.8340       0.0789       0.0035      -0.0327     412.6377      -0.0145      -0.0088       0.0157       7.5406    2703.9785     -14.5000    4400.0000
 2674.9248      87.8862    1232.3715    1950.0000     488.9820     492.9084     216.0000      14.7815     271.3225       0.0640      -0.0127      -0.0495     400.6834      -0.0151      -0.0098       0.0148       7.4937    2731.6921     -16.1250    4461.0000
 2675.0772      89.7527    1227.4058    1950.0000     578.7751     583.2793     216.0000      15.7018     271.4155       0.0664      -0.0100      -0.0468     398.8624      -0.0127      -0.0068       0.0182       7.4412    2727.1504     -16.7500    4337.0000
 2675.2296      93.7893    1324.1338    1950.0000     539.7785     544.4343     216.0000      15.3370     265.5544       0.0612      -0.0156      -0.0526     386.7946      -0.0099      -0.0037       0.0219       7.0937    2736.7454     -16.3125    4367.0000
 2675.3820      97.0088    1462.4968    1950.0000     543.5067     549.5719     216.0000      16.3949     272.4389       0.0543      -0.0231      -0.0603     372.8261      -0.0186      -0.0150       0.0095       7.1866    2749.4758     -18.6875    4402.0000
 2675.5344      96.5883    1552.7000    1950.0000     497.3055     503.8326     216.0000      17.2089     270.5782       0.0665      -0.0100      -0.0467     354.3675      -0.0101      -0.0031       0.0220       7.2869    2727.0659     -17.5625    4302.0000
 2675.6868      93.9499    1520.0582    1950.0000     465.5452     471.5147     216.0000      17.3704     268.3454       0.0599      -0.0171      -0.0541     344.7695      -0.0108      -0.0041       0.0209       7.1583    2739.2109     -17.6875    4349.0000
 2675.8392      91.7438    1356.1543    1950.0000     571.2103     581.8777     216.0000      17.3753     265.9265       0.0436      -0.0347      -0.0723     340.3618      -0.0113      -0.0048       0.0202       7.0541    2769.3525     -19.5625    4398.0000
 2675.9916      89.6250    1075.1725    1950.0000     673.2208     690.5084     216.0000      15.5325     261.3680       0.0446      -0.0336      -0.0712     343.6055      -0.0133      -0.0071       0.0175       7.0498    2767.4749     -18.3125    4389.0000
 2676.1440      87.6163     828.2256    1950.0000     527.3715     536.4904     216.0000      14.0703     262.2052       0.0449      -0.0333      -0.0709     357.4715      -0.0172      -0.0125       0.0118       6.9442    2767.0042     -19.5625    4423.0000
 2676.2964      88.4263     729.4329    1950.0000     748.1367     765.2486     216.0000      13.9639     266.2987       0.0517      -0.0259      -0.0632     381.6903      -0.0158      -0.0105       0.0139       7.2275    2754.2778     -19.5625    4470.0000
 2676.4488      93.6659     797.8095    1950.0000     491.7661     502.8031     216.0000      14.3975     263.8798       0.0653      -0.0113      -0.0480     400.9790      -0.0153      -0.0104       0.0144       7.5007    2729.2688     -19.5625    4439.0000
 2676.6012      99.3019    1021.7574    1950.0000    1227.4430    1256.0524     216.0000      13.1165     263.6007       0.0745      -0.0013      -0.0377     396.5094      -0.0093      -0.0019       0.0232       7.3439    2712.2075     -19.9375    4418.0000
 2676.7536      99.3288    1257.2838    1950.0000    1168.1456    1185.7026     216.0000      13.4609     265.5544       0.0776       0.0021      -0.0342     380.4386      -0.0139      -0.0079       0.0166       7.2651    2706.4690     -19.5625    4353.0000
 2676.9060      95.6013    1300.3285    1950.0000    1564.1281    1597.0179     216.0000      13.2432     271.8807       0.0744      -0.0014      -0.0378     369.5331      -0.0162      -0.0110       0.0133       7.3109    2712.3933     -20.9375    4351.0000
 2677.0584      94.3134    1259.9126    1950.0000    1359.9889    1367.7566     216.0000      14.9578     264.9962       0.0820       0.0069      -0.0292     363.1432      -0.0121      -0.0054       0.0192       7.2902    2698.2244     -23.7500    4455.0000
 2677.2108      97.0296    1260.2064    1922.4912    1072.8337    1086.9960     216.0000      13.8013     264.1589       0.0766       0.0010      -0.0353     368.7799      -0.0150      -0.0091       0.0151       7.2573    2708.2124     -23.1250    4391.0000
 2677.3632     100.3006    1296.6321    1950.0000     698.1616     704.8244     216.0000      13.2602     263.1356       0.0560      -0.0212      -0.0584     366.8308      -0.0150      -0.0087       0.0152       7.2332    2746.3298     -24.3750    4455.0000
 2677.5156      98.1561    1228.4501    1950.0000     536.1382     541.9102     216.0000      13.7809     261.6470       0.0536      -0.0239      -0.0611     374.8116      -0.0168      -0.0111       0.0127       7.0798    2750.8584     -26.6875    4420.0000
 2677.6680      90.5139    1042.1206    1592.1672     387.7201     391.1792     216.0000      14.3954     262.3913       0.0611      -0.0158      -0.0527     380.9469      -0.0194      -0.0147       0.0089       7.2698    2737.0369     -24.2500    4378.0000
 2677.8204      86.4449     831.9584    1400.7590     330.1758     332.1675     216.0000      14.6317     262.3913       0.0641      -0.0125      -0.0493     384.9795      -0.0152      -0.0093       0.0148       7.3216    2731.4194     -24.7500    4360.0000
 2677.9728      89.7772     952.7607    1772.4636     510.7293     514.9113     216.0000      15.0866     260.2515       0.0810       0.0058      -0.0304     381.5536      -0.0127      -0.0057       0.0185       7.2512    2700.1389     -25.0625    4380.0000
 2678.1252      97.6470     998.2358    1950.0000    1056.9355    1056.3698     216.0000      14.2194     259.2281       0.0774       0.0018      -0.0345     371.7372      -0.0153      -0.0095       0.0147       7.3869    2706.8557     -25.5000    4380.0000
 2678.2776     101.9877     935.4157    1950.0000    1454.8755    1461.4733     216.0000      14.8242     257.7396       0.0710      -0.0051      -0.0417     358.2511      -0.0149      -0.0096       0.0151       7.0708    2718.7368     -25.9375    4470.0000
 2678.4300      99.7462     859.6911    1950.0000     946.5316     932.2714     216.0000      15.5830     261.0888       0.0492      -0.0286      -0.0660     346.8664      -0.0080      -0.0009       0.0248       7.0628    2758.9080     -28.2500    4425.0000
 2678.5824      96.4036     892.6012    1950.0000     755.0079     746.0804     216.0000      16.6669     264.2520       0.0348      -0.0442      -0.0822     339.0811      -0.0135      -0.0081       0.0169       7.1843    2785.6384     -29.3125    4424.0000
 2678.7348      96.7363    1055.6376    1950.0000     620.1206     619.6000     216.0000      15.6518     258.2978       0.0210      -0.0592      -0.0977     332.1202      -0.0132      -0.0073       0.0175       6.7391    2811.1641     -28.0625    4393.0000
 2678.8872      99.9469    1275.7336    1950.0000     504.3651     504.5032     216.0000      13.2671     254.7625       0.0503      -0.0275      -0.0648     332.6335      -0.0157      -0.0107       0.0139       7.0363    2756.9666     -27.5625    4426.0000
 2679.0396     101.8179    1317.1132    1950.0000     472.2572     471.9243     216.0000      12.6167     260.2515       0.0480      -0.0299      -0.0674     332.3274      -0.0129      -0.0065       0.0180       7.1589    2761.2000     -29.1875    4399.0000
 2679.1920      99.1195    1081.6693    1950.0000     403.2109     403.8153     216.0000      14.1447     258.4839       0.0359      -0.0430      -0.0809     345.5393      -0.0113      -0.0047       0.0203       7.0106    2783.5562     -29.1875    4405.0000
 2679.3444      94.1849     763.8151    1322.2527     223.5879     223.5602     216.0000      16.4210     256.3441       0.0493      -0.0285      -0.0659     353.1649      -0.0122      -0.0062       0.0189       7.1761    2758.7229     -28.5000    4305.0000
 2679.4968      94.9551     783.2803    1231.2792     356.8875     356.7204     216.0000      17.9326     261.6470       0.0594      -0.0176      -0.0546     358.0100      -0.0091      -0.0016       0.0234       7.2435    2740.0378     -28.7500    4429.0000
 2679.6492     100.2300    1102.1887    1950.0000     617.7793     617.7354     216.0000      17.4294     262.0192       0.0601      -0.0169      -0.0538     358.0799      -0.0150      -0.0093       0.0150       7.1447    2738.8430     -29.1875    4340.0000
 2679.8016     101.4057    1232.1747    1950.0000    1304.5481    1302.3993     216.0000      16.0154     264.1589       0.0649      -0.0117      -0.0485     361.8476      -0.0164      -0.0108       0.0132       7.1674    2729.9792     -28.6875    4361.0000
 2679.9540      97.5112    1128.1962    1945.2352    1381.9382    1371.7942     216.0000      14.7061     265.1823       0.0620      -0.0148      -0.0517     365.8960      -0.0185      -0.0136       0.0101       7.1699    2735.2527     -29.3125    4434.0000
 2680.1064      93.9032     958.2773    1950.0000    1558.8722    1538.6765     216.0000      14.8994     263.0425       0.0530      -0.0246      -0.0618     360.5709      -0.0164      -0.0108       0.0131       7.2858    2751.9946     -26.5625    4457.0000
 2680.2588      94.1975     875.7342    1950.0000    1052.4539    1014.5115     216.0000      14.2539     264.2520       0.0412      -0.0373      -0.0750     345.3624      -0.0193      -0.0143       0.0091       7.0918    2773.7822     -29.3125    4415.0000
 2680.4112      97.6382     944.5271    1950.0000     627.8492     610.3529     216.0000      14.3768     262.7634       0.0426      -0.0358      -0.0735     322.2549      -0.0175      -0.0118       0.0117       7.0362    2771.2310     -29.3125    4412.0000
 2680.5636     100.3104    1183.7970    1950.0000     942.4044     888.2717     216.0000      13.2244     263.3217       0.0514      -0.0263      -0.0636     305.6910      -0.0142      -0.0066       0.0167       7.0765    2754.9507     -29.3125    4380.0000
 2680.7160      99.7107    1463.6929    1950.0000     936.3925     874.4236     216.0000      12.8992     265.1823       0.0662      -0.0102      -0.0470     288.1858      -0.0197      -0.0140       0.0087       7.1249    2727.4905     -29.3125    4388.0000
 2680.8684      97.1090    1443.4222    1950.0000     956.5836     873.1488     216.0000      12.2916     263.8798       0.0631      -0.0136      -0.0504     276.1397      -0.0187      -0.0123       0.0103       6.8285    2733.1733     -29.3125    4397.0000
 2681.0208      93.4739    1144.5652    1950.0000    1154.7426     997.9646     216.0000      11.4244     263.1356       0.0496      -0.0282      -0.0656     271.5528      -0.0218      -0.0161       0.0059       6.9529    2758.2109     -30.6250    4341.0000
 2681.1732      89.5055     887.4212    1950.0000     991.1974     846.2031     216.0000      10.6656     263.8798       0.0750      -0.0007      -0.0371     274.7710      -0.0255      -0.0212       0.0005       7.0803    2711.2341     -29.3125    4332.0000
 2681.3256      87.3453     774.7297    1950.0000     541.0375     502.5058     216.0000      10.6695     264.8102       0.0855       0.0106      -0.0253     288.9528      -0.0200      -0.0133       0.0087       7.1932    2691.8174     -34.0625    4319.0000
 2681.4780      87.8751     773.7596    1950.0000    1012.6422     869.2069     216.0000      11.7490     266.1126       0.0878       0.0131      -0.0228     301.5039      -0.0207      -0.0147       0.0075       7.2848    2687.6489     -30.3125    4391.0000
 2681.6304      89.6068     817.3090    1950.0000    1283.2394    1131.6119     216.0000      12.3994     267.6012       0.0733      -0.0026      -0.0391     312.8998      -0.0226      -0.0180       0.0045       7.1963    2714.4482     -34.1250    4380.0000
 2681.7828      91.6685     861.6057    1950.0000     806.8010     756.2712     216.0000      12.6780     269.0897       0.0672      -0.0092      -0.0459     319.5403      -0.0134      -0.0058       0.0178       7.2917    2725.6851     -30.6875    4357.0000
 2681.9352      94.0700     929.7295    1841.8131     625.3776     598.6650     216.0000      12.0320     269.4618       0.0582      -0.0189      -0.0559     334.5616      -0.0165      -0.0102       0.0133       7.3370    2742.2849     -39.0625    4367.0000
 2682.0876      94.6449     970.8053    1950.0000     810.7759     754.8856     216.0000      12.1404     275.0439       0.0482      -0.0297      -0.0672     357.2457      -0.0205      -0.0157       0.0074       7.2519    2760.8645     -29.7500    4383.0000
 2682.2400      90.9988     831.1743    1911.8677     533.2379     508.9864     216.0000      12.1625     271.3225       0.0460      -0.0321      -0.0696     379.8246      -0.0185      -0.0131       0.0103       7.2794    2764.8418     -34.1875    4301.0000
 2682.3924      81.8049     526.8970    1128.4529     283.0303     277.5550     216.0000      13.4633     271.4155       0.0710      -0.0050      -0.0416     392.1983      -0.0178      -0.0123       0.0113       7.6095    2718.6162     -32.0625    4328.0000
 2682.5448      81.6890     557.6789    1017.1637     282.0815     279.3843     216.0000      14.7640     276.3463       0.0715      -0.0045      -0.0411     399.1842      -0.0162      -0.0099       0.0137       7.6825    2717.7744     -32.8750    4349.0000
 2682.6972      85.6507     846.3066    1789.5420     584.0731     556.4177     216.0000      15.9343     271.6946       0.0482      -0.0297      -0.0671     399.0083      -0.0166      -0.0113       0.0128       7.4643    2760.7910     -31.3750    4342.0000
 2682.8496      87.0934     911.5303    1950.0000    1034.7499     932.3752     216.0000      15.5134     273.3693       0.0407      -0.0379      -0.0756     398.7584      -0.0157      -0.0103       0.0141       7.2871    2774.7957     -30.7500    4342.0000
 2683.0020      84.4096     552.6108     968.3734     543.2745     506.5822     216.0000      16.5911     279.7886       0.0452      -0.0329      -0.0705     399.0178      -0.0112      -0.0045       0.0204       7.3047    2766.3171     -36.1875    4390.0000
 2683.1544      72.7189     256.5536     395.2120     224.6119     216.9996     216.0000      16.5911     272.9971       0.0572      -0.0200      -0.0571     402.2367      -0.0144      -0.0087       0.0159       7.4139    2744.1782     -33.8125    4361.0000
 2683.3068      84.0515     338.5936     843.7076     410.5893     379.1516     216.0000      16.5784     282.0214       0.0615      -0.0154      -0.0523     406.1227      -0.0107      -0.0030       0.0214       7.4749    2736.2888     -34.9375    4434.0000
 2683.4592      80.5234     681.4492    1726.0963     588.4149     533.0801     216.0000      14.4634     284.5333       0.0598      -0.0171      -0.0541     404.4957      -0.0169      -0.0110       0.0126       7.6432    2739.2847     -33.8125    4374.0000
 2683.6116      77.8130     909.8977    1950.0000     562.7797     511.2298     216.0000      13.8080     280.6259       0.0543      -0.0231      -0.0603     406.8644      -0.0166      -0.0108       0.0129       7.5246    2749.4675     -33.8125    4463.0000
 2683.7640      75.9808     892.1220    1950.0000     535.2365     477.7227     216.0000      14.2319     279.6955       0.0740      -0.0018      -0.0382     407.3813      -0.0173      -0.0120       0.0119       7.4379    2713.0300     -29.5625    4409.0000
 2683.9164      77.0831     767.5540    1950.0000     704.9493     544.0558     216.0000      13.9684     278.0209       0.0748      -0.0010      -0.0374     410.6791      -0.0105      -0.0029       0.0216       7.8165    2711.6626     -36.1250    4394.0000
 2684.0688      79.1471     680.0012    1950.0000     937.0972     725.6143     216.0000      13.7519     281.7422       0.0754      -0.0003      -0.0367     421.0310      -0.0189      -0.0145       0.0094       7.6317    2710.5432     -29.3125    4429.0000
 2684.2212      80.1039     671.5856    1950.0000     738.2100     544.7969     216.0000      14.3567     284.5333       0.0752      -0.0006      -0.0370     431.7963      -0.0137      -0.0079       0.0168       7.5931    2710.9692     -38.0625    4441.0000
 2684.3736      79.8801     776.4754    1950.0000    1544.7701    1099.3716     216.0000      15.6575     288.6267       0.0853       0.0104      -0.0256     437.4258      -0.0094      -0.0029       0.0227       7.6095    2692.1846     -33.5625    4448.0000
 2684.5260      78.3758     989.5850    1950.0000    1770.0673    1309.1572     216.0000      16.0958     284.8124       0.0799       0.0046      -0.0316     432.2565      -0.0092      -0.0038       0.0226       7.9454    2702.1560     -39.0625    4368.0000
 2684.6784      76.2837    1133.8867    1950.0000    1545.4628    1242.2485     216.0000      14.1999     290.1153       0.0634      -0.0133      -0.0502     421.0031      -0.0039       0.0037       0.0304       7.3599    2732.7954     -33.7500    4452.0000
 2684.8308      75.7369    1013.7652    1950.0000    1363.4602    1092.0366     216.0000      13.1587     287.8825       0.0648      -0.0118      -0.0486     416.2140      -0.0116      -0.0059       0.0195       7.3817    2730.2026     -37.3750    4511.0000
 2684.9832      77.2051     847.4053    1950.0000     682.4356     600.4671     216.0000      11.7496     285.3705       0.0677      -0.0086      -0.0453     419.5230      -0.0164      -0.0116       0.0129       7.4845    2724.7310     -33.4375    4383.0000
 2685.1356      78.7507     808.8608    1950.0000     364.5767     339.8196     216.0000      11.9664     282.4865       0.0812       0.0060      -0.0301     425.5986      -0.0153      -0.0095       0.0147       7.6098    2699.6995     -32.3125    4365.0000
 2685.2880      78.9933     916.8545    1950.0000     620.5509     534.1642     216.0000      11.5984     285.3705       0.0773       0.0017      -0.0346     423.5842      -0.0165      -0.0105       0.0131       7.5825    2707.0254     -29.3125    4391.0000
 2685.4404      78.3626    1028.8472    1950.0000     853.4142     716.3514     216.0000      12.7858     283.4169       0.0940       0.0198      -0.0159     406.3597      -0.0180      -0.0124       0.0110       7.4893    2676.1882     -34.1875    4405.0000
 2685.5928      77.6453     882.7988    1950.0000     847.7079     727.5658     216.0000      13.0026     290.9526       0.1172       0.0449       0.0102     391.3979      -0.0206      -0.0157       0.0073       7.5837    2633.1995     -34.3750    4452.0000
 2685.7452      77.1076     639.5660    1888.0542     570.3594     516.5362     216.0000      14.3905     284.5333       0.1224       0.0506       0.0160     383.6491      -0.0184      -0.0130       0.0104       7.6861    2623.5276     -29.8750    4428.0000
 2685.8976      77.6244     508.2389    1659.1832     417.9420     392.2795     216.0000      13.8535     290.3944       0.1243       0.0526       0.0181     388.6969      -0.0187      -0.0138       0.0099       7.4405    2620.0884     -33.5000    4508.0000
 2686.0500      77.8785     565.9373    1907.2888     739.0831     672.6881     216.0000      14.3954     292.1620       0.0985       0.0247      -0.0108     388.9275      -0.0144      -0.0083       0.0160       7.4206    2667.7700     -32.3125    4477.0000
 2686.2024      78.0601     728.8930    1950.0000    1532.3439    1359.2853     216.0000      14.1950     294.2088       0.0929       0.0187      -0.0170     383.0378      -0.0149      -0.0088       0.0153       7.5541    2678.0789     -33.7500    4417.0000
 2686.3548      77.9391     978.4572    1950.0000    1272.2620    1172.5319     216.0000      15.9293     295.6973       0.0809       0.0057      -0.0305     367.3618      -0.0174      -0.0120       0.0118       7.1932    2700.2949     -35.9375    4378.0000
 2686.5072      78.5968    1148.5182    1950.0000    1271.6807    1233.9219     216.0000      15.9352     296.8137       0.1054       0.0321      -0.0031     357.3248      -0.0167      -0.0107       0.0128       7.2279    2655.0967     -32.8750    4380.0000
 2686.6596      79.2729    1122.4670    1950.0000     750.1760     750.7837     216.0000      15.6150     288.7198       0.1315       0.0604       0.0262     352.2921      -0.0163      -0.0106       0.0133       7.3096    2606.7820     -37.2500    4367.0000
 2686.8120      78.4787     978.0521    1950.0000     522.3400     526.3035     216.0000      15.7234     284.9054       0.1346       0.0638       0.0297     359.0467      -0.0125      -0.0059       0.0187       7.5878    2600.9458     -29.3125    4388.0000
 2686.9644      77.3941     833.1998    1950.0000     560.3982     567.9603     216.0000      15.6044     286.5800       0.1370       0.0664       0.0324     357.2068      -0.0135      -0.0077       0.0171       7.6107    2596.4624     -31.3125    4304.0000
 2687.1168      78.7647     731.5168    1950.0000     383.0921     386.2071     216.0000      16.7968     294.0227       0.1355       0.0647       0.0307     343.6577      -0.0169      -0.0118       0.0123       7.3686    2599.3560     -37.1875    4400.0000
 2687.2692      83.5199     669.8444    1950.0000     928.3170     943.2194     216.0000      14.9803     294.8600       0.1372       0.0665       0.0326     333.0874      -0.0162      -0.0105       0.0135       7.2687    2596.2666     -30.2500    4410.0000
 2687.4216      90.9255     676.3414    1622.7764     984.9161     992.0546     216.0000      15.9605     297.5580       0.1228       0.0510       0.0165     342.7587      -0.0131      -0.0057       0.0181       7.1648    2622.8267     -32.0000    4402.0000
 2687.5740     100.3734     695.4568    1073.5544     694.1405     694.2020     216.0000      15.1967     290.1153       0.0887       0.0141      -0.0218     371.9537      -0.0176      -0.0116       0.0117       7.4139    2685.9272     -34.1875    4431.0000
 2687.7264     105.7263     943.4570     862.7954     407.8343     406.1701     216.0000      15.6040     288.4407       0.0649      -0.0117      -0.0485     383.6060      -0.0179      -0.0117       0.0114       7.1981    2729.9763     -29.3125    4453.0000
 2687.8788      98.9636     527.3637     403.8819     198.6323     197.4196     216.0000      14.1331     279.5095       0.0748      -0.0010      -0.0374     372.9424      -0.0197      -0.0144       0.0086       7.0699    2711.7031     -33.5000    4334.0000
 2688.0312      65.2486     218.2472     147.7628      97.3176      96.5976     216.0000      13.9214     282.5796       0.0906       0.0162      -0.0196     329.6571      -0.0210      -0.0158       0.0069       6.8930    2682.3506     -29.3125    4348.0000
 2688.1836      70.6749     524.8195     258.0131     117.3031     115.7148     216.0000      13.2710     279.1374       0.1038       0.0304      -0.0048     260.3667      -0.0172      -0.0106       0.0124       6.4812    2657.9502     -33.5000    4352.0000
 2688.3360      62.9827     782.9348     254.9538     139.2460     137.1289     216.0000      13.1656     282.3004       0.0965       0.0225      -0.0131     193.8403      -0.0208      -0.0150       0.0073       6.8888    2671.5569     -29.3125    4307.0000
 2688.4884      54.6251     565.6176     151.3779     102.0697     100.4727     216.0000      11.7565     231.5042       0.0516      -0.0261      -0.0634     118.2156      -0.0157      -0.0101       0.0141       6.4566    2754.5957     -39.0625    4356.0000
 2688.6408      30.4507     274.6758      98.5320      83.9161      82.9056     216.0000      11.1867     222.5730       0.0498      -0.0280      -0.0653      60.1678      -0.0142      -0.0085       0.0161       5.4490    2757.8125     -29.3125    4342.0000
 2688.7932      23.6394     135.6953      99.8523      77.5472      76.8979     216.0000      12.2159     222.2008       0.0692      -0.0070      -0.0436       9.5382      -0.0122      -0.0057       0.0191       5.3977    2721.9763     -33.5625    4360.0000
 2688.9456      29.8823      76.8186     111.2903      73.4971      73.0221     216.0000      12.3243     221.2705       0.0833       0.0082      -0.0278      -7.6272      -0.0132      -0.0071       0.0175       5.3654    2695.9290     -30.4375    4426.0000
 2689.0980      44.6371      57.6219     132.5184      54.6710      54.3543     216.0000      11.9185     221.4566       0.0994       0.0257      -0.0098      -6.8243      -0.0114      -0.0045       0.0203       5.2089    2666.1274     -32.3125    4358.0000
 2689.2504      69.6710      59.4247     178.7166      97.0796      96.6682     216.0000      10.1819     221.4566       0.1062       0.0331      -0.0021      -3.9775      -0.0122      -0.0059       0.0189       5.2649    2653.4788     -29.3750    4348.0000
 2689.4028      90.2552      64.2276     247.0841     118.9516     118.5318     216.0000      10.0735     221.2705       0.0774       0.0019      -0.0344       0.0560      -0.0146      -0.0096       0.0154       5.3097    2706.7930     -29.3750    4376.0000
 2689.5552      48.3952      53.5496     114.5119      56.0838      55.8628     216.0000      11.4780     221.1775       0.0688      -0.0074      -0.0441      -0.2112      -0.0076      -0.0002       0.0253       5.2194    2722.7122     -29.3125    4353.0000
 2689.7076      68.7985      83.6980     234.5672     147.0865     146.2188     216.0000      11.4811     220.8984       0.0730      -0.0029      -0.0393      -2.0351      -0.0100      -0.0033       0.0220       5.2929    2714.8904     -31.3125    4384.0000
 2689.8600      99.1647     113.2098     299.9785     240.3348     237.7818     216.0000      11.3727     220.8984       0.0766       0.0010      -0.0354      -4.4162      -0.0150      -0.0097       0.0150       5.3856    2708.3689     -29.3125    4401.0000
 2690.0124     104.6824     168.7583     520.5103     467.7637     456.5660     216.0000      10.7230     221.1775       0.0720      -0.0040      -0.0405      -3.4873      -0.0148      -0.0093       0.0153       5.2047    2716.8064     -29.6250    4331.0000
 2690.1648     134.8000     237.9855     828.7410     811.1347     792.5413     216.0000      10.8356     221.1775       0.0644      -0.0122      -0.0490      -4.0228      -0.0138      -0.0076       0.0168       5.1942    2730.7925     -33.2500    4380.0000
 2690.3172     116.5611     200.6331     465.8109     347.2406     344.5111     216.0000      11.2655     220.8984       0.0595      -0.0175      -0.0545      -1.5626      -0.0137      -0.0076       0.0169       5.1621    2739.9236     -29.2500    4272.0000
 2690.4696     139.5005     342.2371    1152.3301     782.9641     778.9297     216.0000      10.1855     220.8984       0.0779       0.0024      -0.0339      -0.7055      -0.0123      -0.0054       0.0190       5.1463    2705.8708     -30.0000    4317.0000
 2690.6220     125.1609     359.4895    1191.7974     584.2922     586.5446     216.0000      10.2729     220.7123       0.0692      -0.0070      -0.0436       0.4878      -0.0125      -0.0060       0.0186       5.1933    2721.9360     -28.5000    4322.0000
 2690.7744     111.9963     339.9348     861.6751     412.3465     411.4700     216.0000      10.7103     220.8984       0.0707      -0.0053      -0.0419      -2.8443      -0.0136      -0.0075       0.0170       5.2113    2719.1228     -30.4375    4342.0000
 2690.9268     115.7473     310.0455     614.2588     260.3643     261.0419     216.0000      11.5737     220.8984       0.0643      -0.0123      -0.0491      -5.9397      -0.0117      -0.0053       0.0196       5.2632    2731.0012     -28.6250    4391.0000
 2691.0792     142.2082     537.6991     824.3777     280.8570     282.1892     216.0000      13.7126     220.8984       0.0691      -0.0072      -0.0438      -5.2032      -0.0103      -0.0038       0.0215       5.1430    2722.2493     -29.3125    4319.0000
 2691.2316     171.1185     453.5282     544.0039     261.6841     263.2122     216.0000      14.1462     220.7123       0.0661      -0.0103      -0.0471      -2.3103      -0.0106      -0.0043       0.0210       5.0764    2727.6638     -28.3750    4375.0000
 2691.3840     121.9462     327.7889     463.9529     248.8120     250.7936     216.0000      16.4203     220.8984       0.0585      -0.0185      -0.0556      -0.0865      -0.0124      -0.0069       0.0185       5.0085    2741.7085     -29.0000    4398.0000
 2691.5364     103.4177     234.6935     419.4435     279.6759     281.6994     216.0000      16.0085     220.8984       0.0588      -0.0182      -0.0552       0.0331      -0.0073       0.0001       0.0258       5.0287    2741.1340     -29.3125    4349.0000
 2691.6888     122.3037     181.4164     338.3557     304.4685     305.4537     216.0000      15.7917     220.8984       0.0622      -0.0145      -0.0514      -1.0083      -0.0127      -0.0076       0.0180       5.0490    2734.8728     -29.3125    4330.0000
 2691.8412     106.6429     308.4786     610.7081     457.8654     458.2856     216.0000      15.3642     220.8984       0.0563      -0.0210      -0.0581      -1.5233      -0.0063       0.0008       0.0270       5.0253    2745.8325     -26.5000    4399.0000
 2691.9936     122.9781     528.7058    1318.1433     801.7037     794.2183     216.0000      14.4457     220.8984       0.0557      -0.0216      -0.0587      -2.6915      -0.0046       0.0025       0.0292       4.9809    2746.8740     -27.0000    4305.0000
 2692.1460     133.7742     602.3751    1283.6719     561.4504     556.7469     216.0000      14.6625     220.8984       0.0545      -0.0229      -0.0601      -1.9197      -0.0038       0.0033       0.0303       4.8816    2749.2097     -29.3125    4369.0000
 2692.2984     148.0568     593.1274    1218.4917     380.9005     376.5940     216.0000      14.2289     220.8984       0.0547      -0.0227      -0.0599      -4.3170      -0.0050       0.0018       0.0287       4.9332    2748.8845     -27.8750    4324.0000
 2692.4508     168.6107     590.4838    1950.0000     618.6063     609.5764     216.0000      15.2839     221.0844       0.0636      -0.0131      -0.0499      -5.7707      -0.0074      -0.0013       0.0252       5.0817    2732.3813     -25.8750    4354.0000
 2692.6032     154.5676     377.7553     873.8940     539.1254     532.5320     216.0000      16.7133     220.8984       0.0840       0.0090      -0.0271      -6.3794      -0.0081      -0.0018       0.0244       5.2949    2694.6575     -23.8125    4405.0000
 2692.7556     107.4068     268.1679     452.4535     394.0091     389.3933     216.0000      15.4126     221.2705       0.0897       0.0152      -0.0206      -1.8227      -0.0068       0.0000       0.0263       5.3298    2683.9792     -24.6875    4429.0000
 2692.9080      95.4820     233.7020     215.1733     312.8074     308.0596     216.0000      14.8742     221.0844       0.0900       0.0155      -0.0203      -1.8935      -0.0088      -0.0028       0.0233       5.4186    2683.5769     -27.0000    4409.0000
 2693.0604      84.0409     161.3874     180.0942     245.2536     243.5562     216.0000      11.9241     220.8984       0.0940       0.0198      -0.0159      -3.8350      -0.0048       0.0026       0.0290       5.4664    2676.1917     -26.1250    4388.0000
 2693.2128     148.5654     410.3286     512.8378     547.5695     542.5967     216.0000      12.5745     221.4566       0.0879       0.0132      -0.0227      -8.0373      -0.0144      -0.0097       0.0156       5.4529    2687.4517     -24.9375    4308.0000
 2693.3652     203.8423    1177.4061    1926.0386    1101.4574    1067.5516     216.0000      12.1635     221.0844       0.0869       0.0121      -0.0238      -8.0078      -0.0111      -0.0048       0.0205       5.3491    2689.2839     -22.1250    4360.0000
 2693.5176     191.5307    1655.6805    1950.0000    1007.4203     975.8611     216.0000      12.7087     221.4566       0.0780       0.0025      -0.0338      -5.8382      -0.0085      -0.0013       0.0241       5.2538    2705.7197     -20.8125    4436.0000
 2693.6700     181.1243    1721.2762    1841.4196     704.8957     692.6985     216.0000      13.6787     221.1775       0.0748      -0.0009      -0.0373      -4.0104      -0.0105      -0.0046       0.0211       5.2254    2711.5728     -19.8750    4518.0000
 2693.8224     178.6069    1302.5901    1064.7378     447.6289     443.6335     216.0000      14.0851     221.4566       0.0668      -0.0096      -0.0463      -3.5996      -0.0094      -0.0033       0.0227       5.2456    2726.4399     -20.0625    4533.0000
 2693.9748     194.0397     777.7432     680.7790     356.9111     354.3839     216.0000      16.5782     220.8984       0.0681      -0.0082      -0.0448      -4.7779      -0.0109      -0.0053       0.0204       5.2153    2723.9856     -23.6875    4422.0000
 2694.1272     169.6181    1564.8304    1377.3351     417.4443     414.7955     216.0000      15.0662     221.1775       0.0765       0.0009      -0.0354      -3.4909      -0.0071      -0.0003       0.0259       5.2365    2708.4675     -21.1250    4408.0000
 2694.2796     180.1146    1369.4141    1501.8630     602.3920     598.6578     216.0000      13.1160     221.0844       0.0649      -0.0117      -0.0485      -1.5116      -0.0091      -0.0031       0.0230       5.2097    2729.9719     -22.5000    4455.0000
 2694.4320     191.5780    1863.9790    1890.3696     849.0235     846.6833     216.0000      11.5052     221.1775       0.0648      -0.0118      -0.0486      -1.9441      -0.0039       0.0037       0.0303       5.2035    2730.1323     -21.2500    4409.0000
 2694.5844     189.3470    1578.5691    1950.0000     969.3220     973.3096     216.0000      11.6136     221.1775       0.0760       0.0003      -0.0360      -5.3124      -0.0110      -0.0058       0.0202       5.4145    2709.4243     -21.2500    4367.0000
 2694.7368     195.5591    1126.0522     951.6116     742.9695     744.4877     216.0000      13.5638     221.2705       0.0761       0.0005      -0.0359      -7.6046      -0.0110      -0.0062       0.0201       5.2845    2709.1995     -21.6250    4343.0000
 2694.8892     178.0567     939.2156    1528.7051     896.5327     905.3394     216.0000      13.1110     221.0844       0.0851       0.0102      -0.0258      -7.9303      -0.0054       0.0013       0.0280       5.3083    2692.5002     -21.1250    4346.0000
 2695.0416     173.2362    1242.3163    1839.0723     725.9800     736.1325     216.0000      13.6529     220.8984       0.0830       0.0079      -0.0282      -5.8968      -0.0137      -0.0099       0.0162       5.1875    2696.4856     -21.0000    4381.0000
 2695.1940     167.1044    1591.5743    1540.3922     584.5457     592.9374     216.0000      13.1490     221.0844       0.0752      -0.0005      -0.0369      -3.7074      -0.0073      -0.0007       0.0255       5.1305    2710.8152     -20.3750    4388.0000
 2695.3464     171.1685    1820.8834    1683.8914     515.9580     524.5549     216.0000      13.1490     221.4566       0.0649      -0.0116      -0.0484      -4.4789      -0.0132      -0.0086       0.0172       5.1392    2729.8813     -20.8125    4417.0000
 2695.4988     180.9518    1907.5536    1746.6907     493.1514     501.6261     216.0000      13.4665     221.4566       0.0617      -0.0151      -0.0520      -6.6791      -0.0110      -0.0052       0.0204       5.2206    2735.8511     -20.0000    4429.0000
 2695.6512     185.1007    1930.9208    1802.4508     583.3334     593.7128     216.0000      13.7545     221.4566       0.0717      -0.0043      -0.0408      -9.0544      -0.0094      -0.0034       0.0226       5.2648    2717.3066     -19.5625    4392.0000
 2695.8036     187.9653    1946.5040    1938.6652     833.4153     849.2725     216.0000      14.5174     221.4566       0.0786       0.0032      -0.0331      -9.3269      -0.0066       0.0006       0.0267       5.3028    2704.5869     -19.5625    4415.0000
 2695.9560     188.8314    1727.7050    1950.0000    1126.7142    1145.2406     216.0000      14.5128     221.2705       0.0949       0.0207      -0.0149      -8.5020      -0.0088      -0.0024       0.0235       5.2930    2674.5222     -19.5625    4369.0000
 2696.1084     190.6806    1543.4690    1950.0000    1301.0132    1358.6761     216.0000      13.8624     221.0844       0.0943       0.0201      -0.0155      -8.6949      -0.0117      -0.0063       0.0194       5.3489    2675.5950     -19.5625    4364.0000
 2696.2608     192.0612    1497.5310    1950.0000     742.6544     777.4102     216.0000      14.0792     221.4566       0.0788       0.0034      -0.0328      -8.5659      -0.0099      -0.0042       0.0218       5.2802    2704.1682     -18.9375    4415.0000
 2696.4132     191.5343    1608.7408    1950.0000     890.5747     918.6158     216.0000      13.5758     221.1775       0.0890       0.0144      -0.0215      -8.9834      -0.0081      -0.0019       0.0243       5.3431    2685.4302     -19.0625    4404.0000
 2696.5656     190.8470    1812.2334    1950.0000     829.6440     855.5616     216.0000      12.9221     221.4566       0.0848       0.0099      -0.0261      -8.4298      -0.0070      -0.0003       0.0260       5.3228    2693.0525     -19.5625    4381.0000
 2696.7180     192.4364    1950.0000    1950.0000     772.1807     795.9778     216.0000      12.0549     221.4566       0.0842       0.0092      -0.0268      -6.9845      -0.0120      -0.0071       0.0188       5.3356    2694.2405     -19.5625    4374.0000
 2696.8704     195.2254    1950.0000    1837.0277     732.6875     755.7803     216.0000      13.3812     221.7357       0.0775       0.0020      -0.0343      -5.4674      -0.0072      -0.0006       0.0257       5.3015    2706.6384     -18.5625    4380.0000
 2697.0228     187.3739    1950.0000    1789.1206     742.7238     767.9099     216.0000      14.8972     221.4566       0.0714      -0.0046      -0.0412      -5.8043      -0.0107      -0.0052       0.0207       5.1520    2717.9429     -19.5625    4402.0000
 2697.1752     196.9559    1950.0000    1837.0625     823.9150     856.0960     216.0000      14.8972     221.8287       0.0704      -0.0057      -0.0423      -6.0201      -0.0095      -0.0033       0.0225       5.2264    2719.7178     -17.9375    4401.0000
 2697.3276     194.9806    1950.0000    1940.2058     925.1238     969.8463     216.0000      13.3237     221.6427       0.0835       0.0085      -0.0276      -5.7764      -0.0087      -0.0019       0.0238       5.3267    2695.4678     -16.8750    4358.0000
 2697.4800     192.9706    1920.8717    1950.0000     980.2245    1032.4404     216.0000      13.7390     221.8287       0.0749      -0.0008      -0.0372      -5.6648      -0.0139      -0.0090       0.0163       5.3757    2711.3643     -18.9375    4372.0000
 2697.6324     193.3686    1894.5942    1950.0000     942.7117     988.9697     216.0000      14.4978     221.8287       0.0773       0.0018      -0.0345      -4.9717      -0.0105      -0.0042       0.0212       5.3737    2706.9758     -19.5625    4338.0000
 2697.7848     195.5696    1894.1685    1950.0000    1156.4982    1217.1281     216.0000      14.6061     221.4566       0.0928       0.0185      -0.0172      -4.7359      -0.0137      -0.0086       0.0166       5.5014    2678.3594     -19.2500    4389.0000
 2697.9372     198.8368    1883.5173    1950.0000    1299.8879    1356.9542     216.0000      13.8659     222.0148       0.0716      -0.0045      -0.0410      -4.6923      -0.0098      -0.0031       0.0222       5.3836    2717.6306     -18.1250    4400.0000
 2698.0896     202.8639    1781.1749    1950.0000    1237.9155    1284.0076     216.0000      14.9815     221.6427       0.0966       0.0227      -0.0129      -5.3961      -0.0126      -0.0069       0.0182       5.4677    2671.2388     -19.5625    4381.0000
 2698.2420     205.6378    1612.8894    1950.0000    1009.9982    1043.7804     216.0000      15.4194     221.4566       0.0852       0.0103      -0.0257      -5.8947      -0.0123      -0.0066       0.0187       5.4704    2692.3723     -17.3125    4367.0000
 2698.3944     204.8424    1502.9316    1916.5215     718.7658     733.9601     216.0000      14.7286     221.7357       0.0795       0.0041      -0.0321      -5.2438      -0.0116      -0.0058       0.0196       5.3562    2702.9636     -16.5000    4429.0000
 2698.5468     201.1580    1537.2114    1950.0000     779.2590     802.0195     216.0000      13.3962     222.0148       0.0759       0.0002      -0.0362      -4.5536      -0.0107      -0.0045       0.0210       5.1563    2709.6606     -15.8125    4405.0000
 2698.6992     195.3611    1643.2838    1950.0000     718.0284     736.6241     216.0000      12.9957     222.0148       0.0827       0.0076      -0.0284      -3.8362      -0.0111      -0.0051       0.0203       5.3010    2696.9412     -17.1250    4421.0000
 2698.8516     190.3239    1720.9127    1950.0000     685.8875     703.9512     216.0000      12.7154     221.4566       0.0769       0.0013      -0.0350      -3.5717      -0.0099      -0.0031       0.0221       5.3786    2707.7371     -16.1875    4385.0000
 2699.0040     187.7664    1764.4459    1950.0000     528.5810     545.6152     216.0000      13.1438     222.0148       0.0801       0.0048      -0.0314      -3.1562      -0.0098      -0.0026       0.0224       5.4447    2701.8279     -16.9375    4388.0000
 2699.1564     188.2112    1798.2163    1950.0000     712.0425     728.2020     216.0000      13.1479     222.0148       0.0820       0.0069      -0.0292      -3.0019      -0.0148      -0.0094       0.0152       5.4687    2698.2214     -16.7500    4413.0000
 2699.3088     188.8783    1852.6156    1950.0000     824.6398     841.2406     216.0000      13.6858     222.2939       0.0773       0.0017      -0.0346      -3.2358      -0.0141      -0.0085       0.0162       5.5028    2707.0173     -16.6250    4405.0000
 2699.4612     187.1149    1754.5220    1950.0000     858.7924     871.8644     216.0000      13.2574     222.5730       0.0639      -0.0127      -0.0495      -5.4202      -0.0080      -0.0003       0.0249       5.2496    2731.7034     -16.5000    4392.0000
 2699.6136     182.7592    1564.3873    1462.3435     804.2585     813.8575     216.0000      12.2413     222.2939       0.0782       0.0027      -0.0335      -8.4214      -0.0155      -0.0103       0.0143       5.3638    2705.3477     -16.8125    4385.0000
 2699.7660     189.1400    1089.7465    1950.0000     769.3212     777.9468     216.0000      11.8892     222.2939       0.0905       0.0161      -0.0197      -8.1947      -0.0131      -0.0072       0.0176       5.3713    2682.5535     -15.5000    4321.0000
 2699.9184     187.3786     791.6279    1653.3069     651.6962     658.4014     216.0000       9.2877     222.2008       0.0842       0.0092      -0.0268      -8.1882      -0.0139      -0.0081       0.0165       5.3319    2694.2761     -14.2500    4346.0000
 2700.0708     175.3382     710.3918    1461.8533     413.2798     419.6172     216.0000       9.1790     222.5730       0.0715      -0.0045      -0.0410      -7.3755      -0.0165      -0.0116       0.0128       5.2733    2717.7026     -15.3750    4377.0000
 2700.2232     165.0594     897.1142    1878.5718     829.7784     830.2207     216.0000       9.1017     222.5730       0.0805       0.0052      -0.0309      -7.4685      -0.0120      -0.0056       0.0193       5.2266    2701.0667     -14.2500    4327.0000
 2700.3756     158.3253    1259.5366    1893.9242     938.0965     925.0759     216.0000      11.8107     222.5730       0.0727      -0.0033      -0.0398      -4.8666      -0.0152      -0.0104       0.0145       5.2381    2715.5901     -14.2500    4399.0000
 2700.5280     161.4696    1644.8654    1950.0000     680.4229     665.5685     216.0000      12.7857     222.8521       0.0723      -0.0036      -0.0401      -3.2461      -0.0104      -0.0041       0.0214       5.3025    2716.1614     -14.7500    4376.0000
 2700.6804     168.4181    1410.6561    1231.7418     571.5422     557.5892     216.0000      13.1681     231.8763       0.0714      -0.0046      -0.0412      -2.7342      -0.0129      -0.0070       0.0180       5.3118    2717.9163     -16.3125    4368.0000
 2700.8328     198.7901    1624.9773    1152.3265     565.0289     551.0558     216.0000      11.1095     223.5033       0.0691      -0.0071      -0.0437      -2.0096      -0.0117      -0.0058       0.0195       5.1899    2722.1655     -15.2500    4369.0000
 2700.9852     187.5914    1719.2887    1430.0212     712.3331     692.8521     216.0000      12.3006     223.6894       0.0621      -0.0147      -0.0516       0.4556      -0.0073       0.0004       0.0259       5.3356    2735.1443     -16.2500    4332.0000
 2701.1376     174.7402    1570.8992    1950.0000     865.2769     835.4807     216.0000      13.7193     223.6894       0.0540      -0.0234      -0.0606       3.7322      -0.0140      -0.0085       0.0164       5.1475    2750.0679     -11.1250    4373.0000
 2701.2900     165.9571    1117.7667    1749.2863     757.8747     729.2735     216.0000      14.1529     224.8058       0.0583      -0.0188      -0.0558       4.0617      -0.0158      -0.0110       0.0137       5.2090    2742.1111     -19.5625    4378.0000
 2701.4424     160.8933     961.9767    1501.7659     507.6278     497.6472     216.0000      14.1183     223.6894       0.0587      -0.0184      -0.0554       2.1927      -0.0102      -0.0037       0.0217       5.1473    2741.4231     -16.4375    4345.0000
 2701.5948     159.2927     877.3763    1867.5164     818.6231     776.9863     216.0000      13.5133     224.6197       0.0617      -0.0151      -0.0520       1.6503      -0.0105      -0.0044       0.0212       5.1326    2735.8184     -16.6250    4375.0000
 2701.7472     142.2150     646.8524    1063.6383     783.4273     743.1617     216.0000      15.1392     224.4336       0.0622      -0.0146      -0.0515       1.4989      -0.0136      -0.0083       0.0168       5.2497    2735.0022     -16.8125    4366.0000
 2701.8996     137.4473     710.0346    1459.0582     806.1860     766.4920     216.0000      13.8196     226.2943       0.0604      -0.0166      -0.0535       4.1728      -0.0142      -0.0082       0.0162       5.2760    2738.3391     -17.1875    4350.0000
 2702.0520     134.2399    1001.1973    1950.0000     584.9915     553.8915     216.0000      14.5748     225.0849       0.0625      -0.0143      -0.0512       5.0650      -0.0170      -0.0110       0.0125       5.2831    2734.4192     -11.4375    4400.0000
 2702.2044     127.4367     943.7267    1531.4298     425.3952     408.2076     216.0000      14.3706     225.6431       0.0723      -0.0037      -0.0402       4.0894      -0.0167      -0.0098       0.0132       5.4215    2716.3208     -17.6250    4360.0000
 2702.3568     120.5484     753.4359    1950.0000     394.7071     385.1705     216.0000      13.8839     225.7361       0.0706      -0.0055      -0.0420      -0.0408      -0.0211      -0.0160       0.0067       5.3420    2719.3826     -15.8125    4351.0000
 2702.5092     110.0482     473.8940    1950.0000     438.7451     421.5545     216.0000      12.7219     226.4804       0.0671      -0.0093      -0.0460      11.0586      -0.0191      -0.0135       0.0095       5.5028    2725.9150     -17.5000    4346.0000
 2702.6616      94.7795     285.6286    1116.4034     340.4985     327.3781     216.0000      12.8191     226.7595       0.0685      -0.0078      -0.0444      67.0772      -0.0211      -0.0163       0.0066       5.8079    2723.2898     -16.8125    4366.0000
 2702.8140      92.2520     259.2205    1662.8209     804.8056     775.0460     216.0000      13.0394     230.3878       0.0807       0.0055      -0.0307     156.6558      -0.0177      -0.0114       0.0116       6.5966    2700.6672     -17.8125    4355.0000
 2702.9664      94.3832     247.8747    1779.7350    1110.6470    1074.8196     216.0000      13.4462     245.8313       0.1396       0.0691       0.0353     261.6329      -0.0162      -0.0088       0.0140       7.8531    2591.7859     -18.3750    4393.0000
 2703.1188     102.9721     272.3981    1910.6224    1547.2460    1517.7438     216.0000      13.5477     259.1351       0.0779       0.0025      -0.0338     341.2907      -0.0168      -0.0097       0.0131       7.8494    2705.8103     -19.5625    4415.0000
 2703.2712     111.6057     336.7643    1950.0000    1826.5066    1810.5078     216.0000      14.7401     265.2753       0.0937       0.0195      -0.0161     400.1572      -0.0177      -0.0114       0.0117       7.9924    2676.6421     -19.5625    4397.0000
 2703.4236     114.6341     463.8712    1950.0000    1643.5914    1618.2961     216.0000      13.7195     260.9027       0.0860       0.0112      -0.0248     439.7814      -0.0180      -0.0126       0.0110       8.1623    2690.8557     -19.5625    4392.0000
 2703.5760     113.5827     712.9648    1950.0000    1950.0000    1950.0000     216.0000      12.7455     269.2758       0.0775       0.0019      -0.0344     455.0595      -0.0183      -0.0127       0.0107       7.9609    2706.6826     -19.6875    4408.0000
 2703.7284     110.3895    1138.0840    1950.0000     957.8237     910.5598     216.0000      11.1196     269.7409       0.0792       0.0038      -0.0324     454.9067      -0.0140      -0.0066       0.0169       7.9381    2703.4905     -19.5625    4434.0000
 2703.8808     104.3346    1486.7596    1950.0000     549.2855     523.1201     216.0000      11.6317     265.8335       0.0845       0.0095      -0.0265     439.5821      -0.0182      -0.0126       0.0108       8.0237    2693.7024     -25.7500    4415.0000
 2704.0332      97.2490    1366.6345    1950.0000     376.6085     364.0052     216.0000      12.1731     263.3217       0.0774       0.0019      -0.0344     434.3133      -0.0217      -0.0176       0.0056       7.9051    2706.7847     -19.5625    4430.0000
 2704.1856      91.5195    1004.2136    1950.0000     320.7299     309.8612     216.0000      12.1731     257.1814       0.0614      -0.0155      -0.0524     430.0637      -0.0156      -0.0095       0.0143       7.6488    2736.4326     -22.8750    4416.0000
 2704.3380      87.2998     714.0392    1950.0000     303.1093     292.2450     216.0000      12.4738     253.6461       0.0757       0.0001      -0.0363     430.0616      -0.0184      -0.0133       0.0103       7.7671    2709.8809     -21.0000    4436.0000
 2704.4904      85.4434     556.4724    1950.0000     480.0842     466.2801     216.0000      12.4783     269.1827       0.0879       0.0133      -0.0226     431.3846      -0.0163      -0.0099       0.0135       7.8292    2687.3320     -19.3750    4449.0000
 2704.6428      86.6101     473.2838    1798.0548     736.2497     720.6151     216.0000      13.3412     269.0897       0.0836       0.0085      -0.0275     437.7778      -0.0166      -0.0105       0.0131       7.8495    2695.3887     -26.5625    4429.0000
 2704.7952      87.9631     439.5742    1495.6133    1093.5488    1076.0420     216.0000      14.7377     270.9504       0.0908       0.0164      -0.0194     438.2029      -0.0171      -0.0110       0.0124       7.8014    2682.0291     -23.4375    4421.0000
 2704.9476      82.5247     362.6443     927.4155     885.4064     873.0268     216.0000      14.7640     279.5095       0.0872       0.0125      -0.0234     428.3755      -0.0155      -0.0084       0.0148       7.8742    2688.6262     -23.0000    4465.0000
 2705.1000      76.9402     230.5485     642.3698     643.9039     630.4847     216.0000      15.0934     276.7184       0.0722      -0.0038      -0.0403     416.5475      -0.0177      -0.0116       0.0116       7.6405    2716.4463     -24.4375    4453.0000
 2705.2524      62.4077     330.5662     410.6433     441.7479     435.0332     216.0000      13.2506     281.3701       0.0710      -0.0051      -0.0417     406.9614      -0.0211      -0.0165       0.0065       7.6558    2718.7385     -23.3750    4447.0000
 2705.4048      75.3489     498.7440     568.2366     704.8791     691.5743     216.0000      12.3536     280.2537       0.0990       0.0252      -0.0103     402.9231      -0.0214      -0.0172       0.0060       7.8097    2666.9353     -23.0625    4446.0000
 2705.5572     109.8740     921.1875     588.3425     618.3958     616.0286     216.0000      10.3410     276.9045       0.0909       0.0165      -0.0193     402.9276      -0.0170      -0.0114       0.0123       7.7973    2681.7664     -27.5000    4432.0000
 2705.7096     122.3912     334.9059     194.4002     196.8998     197.7249     216.0000       9.4739     268.9037       0.0911       0.0167      -0.0191     404.0380      -0.0164      -0.0104       0.0132       7.7254    2681.4724     -24.8125    4474.0000
 2705.8620      41.4099     146.1346      77.2630      80.7693      81.0461     216.0000      10.4530     263.3217       0.1060       0.0328      -0.0024     395.3085      -0.0146      -0.0076       0.0160       7.6234    2653.9878     -24.4375    4455.0000
 2706.0144      52.6228      67.0190      48.6134      50.6494      50.7720     216.0000      13.3944     272.9971       0.1391       0.0686       0.0348     382.6480      -0.0189      -0.0136       0.0097       7.8521    2592.6450     -21.9375    4446.0000
 2706.1668      27.9061      41.6563      56.9194      56.5054      56.5859     216.0000      16.4295     280.6259       0.1509       0.0814       0.0480     373.0659      -0.0168      -0.0121       0.0123       8.1441    2570.7825     -24.0625    4424.0000
 2706.3192      32.9357      77.5316      66.2751      61.2817      61.2157     216.0000      23.4752     281.7422       0.1350       0.0642       0.0302     361.9752      -0.0086      -0.0027       0.0236       7.8808    2600.1755     -23.1875    4448.0000
 2706.4716      25.4496      41.6285      40.0608      34.3663      34.2928     216.0000      29.7006     284.8124       0.1481       0.0784       0.0449     366.7614       0.0270       0.0399       0.0714       7.6109    2575.9373     -25.6250    4445.0000
 2706.6240      21.6886      22.9617      20.9119      20.2696      20.2462     216.0000      31.4350     278.0209       0.1268       0.0553       0.0209     390.8343       0.0448       0.0608       0.0945       7.8932    2615.4973     -24.8750    4470.0000
 2706.7764      40.4927      67.3576      56.5140      43.3989      43.2746     216.0000      24.7089     263.1356       0.1116       0.0389       0.0039     428.1549      -0.0084      -0.0046       0.0232       8.1444    2643.5024     -24.8125    4467.0000
 2706.9288      75.9463     343.1386     203.6482     107.5378     106.9313     216.0000      16.4708     272.8111       0.1035       0.0301      -0.0052     451.1158      -0.0202      -0.0168       0.0074       7.9987    2658.4988     -23.5000    4464.0000
 2707.0812      88.9202    1950.0000     744.0481     161.1141     159.4323     216.0000      12.7853     270.7643       0.0913       0.0170      -0.0188     452.6169      -0.0218      -0.0169       0.0058       7.8531    2681.0039     -20.2500    4543.0000
 2707.2336      91.0082    1950.0000    1152.2260     118.2667     116.8468     216.0000      12.3572     269.2758       0.0661      -0.0104      -0.0471     448.2956      -0.0225      -0.0176       0.0048       7.8345    2727.7874     -24.9375    4506.0000
 2707.3860      80.7293     571.9774     800.6072     106.0697     104.4556     216.0000      13.0076     272.8111       0.0626      -0.0141      -0.0510     447.5226      -0.0212      -0.0155       0.0068       7.6014    2734.1580     -23.7500    4519.0000
 2707.5384      64.1099     196.7795     221.6600     103.8000     101.8910     216.0000      11.4871     266.8569       0.0631      -0.0136      -0.0505     446.5620      -0.0196      -0.0137       0.0090       7.7071    2733.2605     -24.0625    4476.0000
 2707.6908      74.0554     313.4804     596.3755     190.9160     185.2637     216.0000      11.5134     268.3454       0.0691      -0.0071      -0.0437     448.9331      -0.0168      -0.0097       0.0131       7.8265    2722.1436     -27.9375    4518.0000
 2707.8432      87.9605     592.2528    1017.1932     325.1449     309.7813     216.0000      12.1637     269.2758       0.0745      -0.0012      -0.0377     445.7984      -0.0228      -0.0179       0.0044       7.7937    2712.1353     -25.9375    4432.0000
 2707.9956      93.5167     884.9718    1443.1830     557.5334     551.5508     216.0000      13.9010     264.7171       0.0682      -0.0081      -0.0448     443.9964      -0.0218      -0.0172       0.0056       7.6610    2723.8777     -29.3125    4413.0000
 2708.1480      90.4244    1006.7276    1950.0000     696.1155     573.4875     216.0000      14.4167     265.9265       0.0828       0.0077      -0.0284     440.7570      -0.0189      -0.0134       0.0097       7.7662    2696.7930     -29.3125    4449.0000
 2708.3004      82.8315     803.8132    1112.3474     359.4800     336.6915     216.0000      14.3166     265.1823       0.1063       0.0331      -0.0020     439.2495      -0.0171      -0.0106       0.0126       7.8388    2653.3591     -39.0625    4429.0000
 2708.4528      82.2966     420.0272     541.1273     248.1297     236.5953     216.0000      13.3411     266.9500       0.1062       0.0330      -0.0022     431.2060      -0.0228      -0.0178       0.0044       7.8552    2653.6038     -40.4375    4434.0000
 2708.6052      79.3743     829.3719     916.9024     273.2928     262.0792     216.0000      12.5823     270.3922       0.0965       0.0226      -0.0130     425.1721      -0.0171      -0.0097       0.0128       7.6794    2671.4382     -41.0625    4492.0000
 2708.7576      87.9945     903.9227    1833.3766     313.6895     294.4253     216.0000      12.6824     271.1364       0.0860       0.0111      -0.0248     414.5086      -0.0178      -0.0104       0.0118       7.5696    2690.9602     -43.4375    4460.0000
 2708.9100      85.3367     787.6977    1632.5680     329.0995     308.2236     216.0000      12.4482     263.8798       0.0839       0.0089      -0.0272     402.8697      -0.0262      -0.0223      -0.0006       7.5561    2694.8621     -42.0000    4441.0000
 2709.0624      82.3104     569.4062    1950.0000     436.5159     415.3594     216.0000      13.7489     260.9027       0.0776       0.0021      -0.0342     385.9045      -0.0223      -0.0169       0.0052       7.5255    2706.3850     -41.5000    4480.0000
 2709.2148      83.1375     413.9331    1950.0000     566.6490     516.0399     216.0000      13.5321     260.8097       0.0945       0.0204      -0.0152     366.9672      -0.0224      -0.0172       0.0050       7.6526    2675.1106     -40.7500    4474.0000
 2709.3672      86.4347     352.2891    1950.0000     411.6035     354.4918     216.0000      14.9587     264.1589       0.0770       0.0015      -0.0349     352.7789      -0.0213      -0.0158       0.0066       7.4942    2707.5120     -40.3750    4484.0000
 2709.5196      88.4117     379.7228    1950.0000    1110.8895    1020.0608     216.0000      14.0998     271.5086       0.0814       0.0062      -0.0299     351.8691      -0.0173      -0.0101       0.0125       7.5305    2699.3210     -40.3750    4506.0000
 2709.6720      86.0685     510.0091    1950.0000    1388.8015    1291.2061     216.0000      14.5334     273.6484       0.0713      -0.0048      -0.0413     362.9680      -0.0160      -0.0089       0.0141       7.5986    2718.1338     -40.3125    4501.0000
 2709.8244      79.5338     730.7018    1950.0000    1950.0000    1950.0000     216.0000      13.9914     272.8111       0.0720      -0.0040      -0.0405     379.9033      -0.0223      -0.0187       0.0046       7.5740    2716.8303     -39.6250    4466.0000
 2709.9768      73.0861     836.4425    1950.0000    1950.0000    1817.5101     216.0000      13.8747     272.6250       0.0871       0.0124      -0.0235     400.1021      -0.0124      -0.0061       0.0187       7.6625    2688.8167     -39.3125    4436.0000
 2710.1292      69.4391     647.2745    1705.2938     875.1685     761.8461     216.0000      13.9831     269.4618       0.1107       0.0379       0.0029     405.3542      -0.0101      -0.0034       0.0218       7.6426    2645.2083     -40.9375    4472.0000
 2710.2816      67.7523     428.5953    1933.5676     486.4590     415.8858     216.0000      14.8451     268.5315       0.1394       0.0689       0.0351     410.1400      -0.0116      -0.0045       0.0200       7.8962    2592.1621     -39.3125    4456.0000
 2710.4340      66.5785     284.3301     842.7520     411.8435     355.4297     216.0000      13.8696     274.6717       0.1255       0.0539       0.0195     411.5946      -0.0173      -0.0119       0.0119       7.9393    2617.8494     -39.0625    4444.0000
 2710.5864      69.6419     312.6677    1452.9187     620.2552     560.3652     216.0000      12.7374     267.2290       0.1226       0.0508       0.0163     410.0368      -0.0145      -0.0082       0.0159       7.7886    2623.1421     -39.0625    4437.0000
 2710.7388      70.2355     372.0042    1950.0000    1126.0624     993.4926     216.0000      11.3335     275.6021       0.1346       0.0637       0.0297     389.8304      -0.0138      -0.0065       0.0171       7.8997    2601.0073     -35.7500    4449.0000
 2710.8912      68.5748     374.0106    1842.5009     591.0875     531.4201     216.0000      11.7670     278.6721       0.1110       0.0382       0.0032     361.5296      -0.0189      -0.0131       0.0099       7.7858    2644.6980     -29.3125    4448.0000
 2711.0436      67.8925     387.1151    1835.0745     403.6819     363.2399     216.0000      11.7029     281.5562       0.0715      -0.0045      -0.0410     330.1818      -0.0158      -0.0087       0.0144       7.2460    2717.6416     -30.5625    4474.0000
 2711.1960      69.0010     458.5650    1950.0000     269.0133     259.8774     216.0000      12.3533     281.1841       0.0726      -0.0033      -0.0398     318.8741      -0.0199      -0.0151       0.0083       6.9605    2715.7141     -23.4375    4448.0000
 2711.3484      68.0451     535.0706    1950.0000     480.4267     453.1488     216.0000      13.9308     285.3705       0.0830       0.0079      -0.0281     319.6480      -0.0210      -0.0173       0.0064       7.4753    2696.4260     -47.4375    4461.0000
 2711.5008      64.2053     498.0067    1762.6427     340.1381     308.9950     216.0000      14.2599     274.6717       0.0749      -0.0008      -0.0372     337.1315      -0.0115      -0.0054       0.0198       7.5497    2711.3916     -44.3125    4523.0000
 2711.6532      61.7861     368.1332     831.8306     195.9329     188.5893     216.0000      15.0186     278.1140       0.0537      -0.0238      -0.0611     354.0757      -0.0045       0.0040       0.0298       7.6559    2750.7339     -47.5625    4484.0000
 2711.8056      65.5908     521.0157    1898.4990     469.4513     442.7025     216.0000      13.4908     282.5796       0.0668      -0.0096      -0.0464     362.3953      -0.0118      -0.0054       0.0195       7.1276    2726.4917     -42.3750    4463.0000
 2711.9580      69.3471     637.4611    1564.8511     734.2331     689.0168     216.0000      13.4908     281.1841       0.0939       0.0198      -0.0159     374.6014      -0.0070       0.0011       0.0263       7.6451    2676.2112     -45.2500    4517.0000
 2712.1104      71.4426     901.6987    1950.0000     849.1761     780.1080     216.0000      13.4908     284.1611       0.0864       0.0116      -0.0243     388.3076      -0.0148      -0.0087       0.0154       7.9742    2690.1182     -39.2500    4464.0000
 2712.2628      70.5242    1157.0767    1592.9395     641.9990     601.4990     216.0000      13.8747     272.6250       0.0743      -0.0015      -0.0379     396.4422      -0.0188      -0.0135       0.0099       7.4931    2712.4985     -46.6875    4473.0000
 2712.4152      72.3440    1741.4269    1754.6884     464.3681     430.4158     216.0000      12.8959     271.6946       0.0649      -0.0116      -0.0484     398.1690      -0.0198      -0.0139       0.0087       7.3987    2729.8721     -41.1250    4485.0000
 2712.5676      70.9022    1609.0905    1581.7140     270.1351     255.8682     216.0000      10.8426     270.5782       0.0676      -0.0088      -0.0455     395.6017      -0.0203      -0.0139       0.0082       7.6201    2725.0017     -46.5000    4577.0000
 2712.7200      65.0197     591.6733     688.5917     164.3858     158.1472     216.0000      10.1922     267.9733       0.0379      -0.0409      -0.0788     394.0976      -0.0244      -0.0200       0.0020       7.3120    2779.9666     -43.8125    4559.0000
 2712.8724      63.2159     612.9175     364.7946     127.1251     123.0497     216.0000      11.2794     270.9504       0.0441      -0.0342      -0.0718     396.2560      -0.0232      -0.0186       0.0038       7.0465    2768.4719     -40.3750    4523.0000
 2713.0248      61.6331     301.1382     280.9204     131.1494     127.7735     216.0000      13.0021     268.3454       0.0623      -0.0145      -0.0513     402.1654      -0.0231      -0.0189       0.0038       7.3250    2734.7158     -45.9375    4497.0000
 2713.1772      65.1641     527.2340     708.7352     256.6784     247.6019     216.0000      14.4113     271.6946       0.0709      -0.0052      -0.0417     400.0523      -0.0161      -0.0084       0.0143       7.3313    2718.8176     -40.7500    4456.0000
 2713.3296      73.3183     336.2281     900.1989     614.6477     568.6973     216.0000      14.3029     271.4155       0.0696      -0.0065      -0.0431     374.9440      -0.0175      -0.0104       0.0121       7.1821    2721.1838     -44.7500    4448.0000
 2713.4820      61.3803     219.2303     387.2042     374.1273     355.3216     216.0000      14.4167     263.6007       0.0623      -0.0144      -0.0513     345.9110      -0.0203      -0.0150       0.0078       7.0889    2734.7087     -42.4375    4562.0000
 2713.6344      63.1013      76.9302     150.6087     153.2247     146.0112     216.0000      14.4167     262.2052       0.0367      -0.0422      -0.0801     318.9287      -0.0175      -0.0124       0.0116       7.1645    2782.1450     -40.0000    4518.0000
 2713.7868      62.2084     114.5725     370.6380     346.8016     331.7899     216.0000      16.0427     285.0915       0.0170      -0.0635      -0.1022     294.6148      -0.0223      -0.0182       0.0048       6.5704    2818.6284     -39.0625    4449.0000
 2713.9392      67.9467     272.2777     774.2780     456.7751     432.4666     216.0000      18.4200     285.4636       0.0278      -0.0518      -0.0901     264.1544      -0.0168      -0.0102       0.0130       6.3604    2798.6506     -43.5000    4502.0000
 2714.0916      65.8801     643.7769    1950.0000     240.3084     232.9598     216.0000      19.0084     285.6496       0.0338      -0.0453      -0.0833     243.4792      -0.0220      -0.0173       0.0054       6.5300    2787.4463     -40.2500    4481.0000
 2714.2440      65.7981    1210.8040    1631.4139     185.6697     178.9076     216.0000      20.4175     285.6496       0.0404      -0.0382      -0.0760     237.1113      -0.0171      -0.0113       0.0123       6.4828    2775.3193     -45.4375    4458.0000
 2714.3964      69.8415    1568.7061    1741.0739     179.4767     172.7262     216.0000      19.9913     285.6496       0.0566      -0.0206      -0.0578     232.8775      -0.0127      -0.0069       0.0181       6.6585    2745.3110     -41.0625    4494.0000
 2714.5488      75.6226    1533.1915    1891.0909     244.0351     232.9936     216.0000      21.6718     286.2079       0.0593      -0.0177      -0.0547     223.6326      -0.0035       0.0047       0.0310       6.8724    2740.2563     -42.0625    4570.0000
 2714.7012      78.0097    1026.8958    1950.0000     415.1438     388.7201     216.0000      22.0295     284.5333       0.0837       0.0087      -0.0273     229.6963      -0.0069      -0.0005       0.0260       6.9186    2695.0791     -42.2500    4447.0000
 2714.8536      76.6888     732.6519    1908.5562     611.7808     497.8426     216.0000      21.0539     289.7431       0.1194       0.0474       0.0127     277.6179      -0.0124      -0.0083       0.0180       7.3044    2629.0215     -40.5000    4452.0000
 2715.0060      75.8181     640.5344    1908.1860     682.6902     641.8715     216.0000      19.5438     281.5562       0.1168       0.0445       0.0098     360.4763      -0.0031       0.0037       0.0311       8.0430    2633.8735     -40.0000    4510.0000
 2715.1584      76.0869     668.3082    1950.0000     530.7921     504.7933     216.0000      17.6686     276.3463       0.0886       0.0140      -0.0219     434.6459      -0.0072       0.0001       0.0258       7.8975    2686.1047     -39.8125    4589.0000
 2715.3108      75.4540     717.2167    1950.0000     338.6659     324.1174     216.0000      17.0129     264.7171       0.0891       0.0145      -0.0213     465.5979      -0.0151      -0.0086       0.0151       7.8221    2685.1260     -39.3750    4542.0000
 2715.4632      74.1456     673.2221    1192.3057     218.9615     211.5958     216.0000      16.3345     277.8349       0.0860       0.0112      -0.0248     465.2569      -0.0233      -0.0174       0.0040       7.9306    2690.9087     -40.1250    4515.0000
 2715.6156      73.3694     704.2609    1732.0284     227.7713     217.8302     216.0000      14.7085     275.4160       0.0793       0.0039      -0.0323     443.0406      -0.0274      -0.0230      -0.0020       7.8366    2703.3132     -41.5000    4543.0000
 2715.7680      66.8420     499.9088     858.9556     259.1321     238.2352     216.0000      13.8467     269.6479       0.0830       0.0079      -0.0282     421.0215      -0.0222      -0.0161       0.0055       7.8278    2696.5081     -40.0625    4546.0000
 2715.9204      62.8244     260.6872     402.9303     180.9882     176.1016     216.0000      12.1404     272.2528       0.0738      -0.0020      -0.0384     393.5447      -0.0277      -0.0240      -0.0026       7.6063    2713.4338     -41.1875    4493.0000
 2716.0728      68.8814     629.9002    1226.8157     384.5503     363.8834     216.0000      12.4612     275.4160       0.0758       0.0001      -0.0363     388.0463      -0.0208      -0.0141       0.0076       7.5579    2709.8552     -39.3125    4539.0000
 2716.2252      74.3016     537.9990    1950.0000     696.5997     643.9631     216.0000      12.5890     276.4393       0.0747      -0.0010      -0.0374     386.2474      -0.0256      -0.0207       0.0006       7.7524    2711.7668     -40.4375    4521.0000
 2716.3776      77.0866     469.3473    1418.8669     531.3174     498.6181     216.0000      11.3967     276.1603       0.0739      -0.0019      -0.0383     394.4802      -0.0217      -0.0152       0.0064       7.6572    2713.2161     -40.8125    4543.0000
 2716.5300      76.1777     346.4416     920.5986     287.7762     275.8046     216.0000      11.0759     277.5558       0.0773       0.0017      -0.0346     386.8563      -0.0193      -0.0119       0.0099       7.7052    2707.0518     -41.3125    4478.0000
 2716.6824      81.7339     533.3154    1950.0000     529.1819     489.4787     216.0000      11.2746     279.6955       0.0770       0.0014      -0.0349     384.3589      -0.0235      -0.0181       0.0036       7.7164    2707.5452     -39.6875    4456.0000
 2716.8348      79.2367     712.3911    1950.0000     619.8629     573.7852     216.0000      12.4670     275.6021       0.0625      -0.0143      -0.0512     377.9359      -0.0260      -0.0212       0.0001       7.6061    2734.4192     -40.5000    4479.0000
 2716.9872      75.5003     779.6948    1715.0402     356.0748     338.1071     216.0000      12.3586     273.1832       0.0726      -0.0034      -0.0399     390.6627      -0.0268      -0.0224      -0.0012       7.6531    2715.7668     -39.0625    4490.0000
 2717.1396      73.2827     662.0739    1950.0000     639.9758     587.2377     216.0000      11.4900     274.4857       0.0751      -0.0007      -0.0370     402.2882      -0.0230      -0.0164       0.0047       7.7594    2711.1145     -39.5625    4546.0000
 2717.2920      72.3303     460.3125     930.1884     395.0796     374.7645     216.0000      11.6687     271.6946       0.0872       0.0125      -0.0234     412.7829      -0.0234      -0.0173       0.0039       7.8678    2688.6055     -39.0625    4536.0000
 2717.4444      72.2017     296.3003     521.3954     210.2766     205.0644     216.0000      11.4519     272.2528       0.0880       0.0133      -0.0226     413.1937      -0.0310      -0.0283      -0.0076       7.9221    2687.2485     -39.0625    4458.0000
 2717.5968      74.8137     422.7466     750.4933     393.3605     371.5282     216.0000      12.1023     278.3931       0.0856       0.0108      -0.0252     407.2080      -0.0227      -0.0163       0.0049       7.7379    2691.5823     -38.3750    4497.0000
 2717.7492      83.7069     725.1431    1445.8026     709.5115     673.8672     216.0000      11.5984     282.0214       0.0964       0.0224      -0.0131     406.5540      -0.0205      -0.0135       0.0081       7.8953    2671.6477     -39.0625    4496.0000
 2717.9016      85.9495    1176.9984    1950.0000    1257.3546    1155.9851     216.0000      12.8992     280.6259       0.0957       0.0217      -0.0139     408.9355      -0.0253      -0.0206       0.0009       7.8256    2672.9575     -39.0625    4460.0000
 2718.0540      84.8696    1267.8378    1950.0000     755.4219     714.8101     216.0000      14.5251     274.4857       0.1020       0.0285      -0.0069     414.9294      -0.0204      -0.0145       0.0079       7.7649    2661.3308     -39.0625    4504.0000
 2718.2064      83.4678     704.1133    1498.8080     464.3864     417.8221     216.0000      18.0742     275.8812       0.1128       0.0402       0.0053     423.1131      -0.0227      -0.0179       0.0044       7.8580    2641.3345     -39.0625    4455.0000
 2718.3588      87.7513     923.3573     673.0756     368.8600     352.1801     216.0000      20.0254     279.7886       0.1012       0.0276      -0.0077     444.4032      -0.0208      -0.0149       0.0074       7.9377    2662.7771     -39.0625    4478.0000
 2718.5112      89.0614     724.3802    1477.4827     521.4796     487.2521     216.0000      21.3261     282.3004       0.0865       0.0117      -0.0243     468.0467      -0.0210      -0.0148       0.0072       7.6866    2690.0647     -39.0625    4492.0000
 2718.6636      91.8374     889.0764    1950.0000     433.2629     398.6444     216.0000      20.9201     281.9283       0.0958       0.0218      -0.0138     480.5934      -0.0203      -0.0142       0.0081       7.7616    2672.7236     -39.0625    4498.0000
 2718.8160      90.6059     975.3168    1950.0000     483.4241     457.2867     216.0000      21.3537     281.7422       0.1159       0.0435       0.0088     477.9601      -0.0192      -0.0127       0.0097       7.7059    2635.5354     -39.0625    4492.0000
 2718.9684      88.2985     908.8086    1879.6658     351.9819     338.4319     216.0000      21.5705     278.5792       0.1308       0.0596       0.0254     459.4109      -0.0219      -0.0174       0.0055       7.5857    2608.0134     -39.0625    4546.0000
 2719.1208      85.2187     714.7190    1950.0000     348.2535     330.6696     216.0000      22.9989     283.4169       0.1402       0.0698       0.0360     428.7789      -0.0193      -0.0136       0.0093       7.5973    2590.6213     -39.0625    4518.0000
 2719.2732      79.2436     506.6261    1803.7817     342.3391     324.7413     216.0000      22.3485     281.9283       0.1342       0.0633       0.0293     366.4148      -0.0176      -0.0115       0.0117       7.6011    2601.6997     -39.0625    4510.0000
 2719.4256      71.6154     369.7123    1020.3810     200.9447     184.9234     216.0000      21.3663     285.0915       0.1353       0.0645       0.0305     275.6360      -0.0220      -0.0171       0.0054       7.3116    2599.6431     -38.7500    4487.0000
 2719.5780      68.6521     345.4333     839.8281     314.0331     300.9378     216.0000      19.0345     279.3234       0.1380       0.0674       0.0335     184.1688      -0.0219      -0.0171       0.0055       6.6455    2594.7642     -37.8750    4521.0000
 2719.7304      71.0274     493.1093    1677.3627     649.8539     617.2399     216.0000      16.2122     286.2079       0.1383       0.0678       0.0339     122.2987      -0.0180      -0.0116       0.0113       6.3821    2594.0742     -39.0625    4529.0000
 2719.8828      71.9988     560.7761    1950.0000     910.5628     779.3607     216.0000      13.4609     292.6272       0.1189       0.0468       0.0121      98.2389      -0.0168      -0.0096       0.0131       6.4185    2629.9812     -39.0625    4469.0000
 2720.0352      74.1648     580.8096    1796.2803     762.1414     628.6855     216.0000      11.6547     287.3243       0.1086       0.0356       0.0005      84.7046      -0.0172      -0.0102       0.0125       6.1983    2649.1023     -39.0625    4328.0000
 2720.1876      76.4583     684.3824    1942.8898     810.5682     739.1857     216.0000      11.6586     284.2542       0.1110       0.0382       0.0032     101.3143      -0.0256      -0.0213       0.0003       6.3516    2644.6897     -39.0000    4314.0000
 2720.3400      76.8600     909.2200    1950.0000    1048.0967     912.2763     216.0000      12.3655     283.6029       0.1133       0.0407       0.0058     149.6377      -0.0244      -0.0191       0.0023       6.4912    2640.3723     -37.0000    4464.0000
 2720.4924      74.4582    1076.3250    1950.0000     666.9515     591.4940     216.0000      14.0998     271.1364       0.0914       0.0170      -0.0187     238.5111      -0.0239      -0.0185       0.0030       7.4887    2680.9143     -37.0625    4795.0000
 2720.6448      71.1404     943.2434    1950.0000     538.3649     482.7001     216.0000      14.7629     266.1126       0.0809       0.0057      -0.0305     321.0585      -0.0267      -0.0224      -0.0011       7.7670    2700.3352     -39.3125    4808.0000
 2720.7972      68.1077     689.1690    1950.0000     536.6586     464.5949     216.0000      13.4538     271.1364       0.0696      -0.0065      -0.0431     386.6062      -0.0254      -0.0200       0.0011       7.8081    2721.1487     -39.4375    4673.0000
 2720.9496      65.8706     522.4391    1950.0000     451.0804     389.9359     216.0000      13.0153     277.2766       0.0917       0.0173      -0.0184     420.4883      -0.0251      -0.0194       0.0016       7.8123    2680.3933     -39.3750    4693.0000
 2721.1020      65.2768     463.2223    1950.0000     419.3947     349.6541     216.0000      12.1354     273.5553       0.1132       0.0406       0.0057     438.8480      -0.0250      -0.0200       0.0015       8.1270    2640.6301     -39.0625    4602.0000
 2721.2544      66.2634     458.6668    1950.0000     875.0318     755.9836     216.0000      13.3278     282.8586       0.1100       0.0371       0.0021     448.2572      -0.0201      -0.0129       0.0088       7.9456    2646.5283     -39.0625    4528.0000
 2721.4068      67.3828     438.3425    1950.0000    1107.7659     968.5161     216.0000      13.0202     279.8816       0.1161       0.0437       0.0090     455.9858      -0.0217      -0.0159       0.0062       7.9830    2635.2107     -39.0625    4468.0000
 2721.5592      66.6323     365.4788    1950.0000    1286.1112    1131.6747     216.0000      14.4294     275.9742       0.0968       0.0229      -0.0127     458.8051      -0.0203      -0.0142       0.0081       7.8909    2670.9114     -39.0625    4439.0000
 2721.7116      63.6798     285.6466    1950.0000    1950.0000    1741.4785     216.0000      14.5505     289.7431       0.0941       0.0200      -0.0157     462.2080      -0.0247      -0.0197       0.0018       7.7879    2675.8647     -39.0625    4434.0000
 2721.8640      61.5013     245.4936    1950.0000    1435.9706    1217.4603     216.0000      14.4294     281.1841       0.0983       0.0245      -0.0110     460.3159      -0.0246      -0.0200       0.0018       7.9610    2668.0679     -36.2500    4424.0000
 2722.0164      62.8115     260.8276    1950.0000    1089.7209     903.0441     216.0000      14.3210     284.3472       0.1075       0.0345      -0.0006     455.6677      -0.0213      -0.0148       0.0069       7.8828    2651.0706     -37.6250    4466.0000
 2722.1688      67.4515     357.5978    1950.0000     828.2948     726.9908     216.0000      12.7876     285.6496       0.1055       0.0323      -0.0029     449.8627      -0.0213      -0.0152       0.0068       7.9127    2654.7803     -34.6250    4440.0000
 2722.3212      72.5172     606.2233    1950.0000     662.4253     592.7059     216.0000      10.6735     288.6267       0.1043       0.0310      -0.0043     451.8757      -0.0196      -0.0130       0.0093       7.9595    2657.0188     -38.0625    4463.0000
 2722.4736      75.1586    1047.5974    1950.0000     485.0477     422.9204     216.0000       8.5055     289.8362       0.1001       0.0264      -0.0090     461.2496      -0.0210      -0.0152       0.0071       7.9584    2664.8711     -36.6250    4512.0000
 2722.6260      75.0315    1302.1776    1950.0000     414.6875     375.9829     216.0000       9.4842     280.9980       0.0934       0.0192      -0.0165     468.5104      -0.0192      -0.0129       0.0097       7.8525    2677.2092     -39.0625    4479.0000
 2722.7784      74.1113    1074.6130    1950.0000     490.8528     430.3602     216.0000      10.9441     280.8119       0.0893       0.0147      -0.0211     466.0275      -0.0158      -0.0078       0.0147       7.7670    2684.8074     -34.9375    4436.0000
 2722.9308      74.3957     836.3500    1950.0000     447.6875     391.2859     216.0000      12.0816     279.2304       0.0949       0.0208      -0.0148     457.6776      -0.0198      -0.0127       0.0091       7.8913    2674.4578     -33.5000    4488.0000
 2723.0832      76.0003     760.3887    1950.0000     332.1369     285.4160     216.0000      12.0816     276.7184       0.0844       0.0095      -0.0265     454.0262      -0.0280      -0.0242      -0.0030       7.8651    2693.7900     -33.8125    4530.0000
 2723.2356      77.5165     804.5229    1950.0000     673.2281     564.5496     216.0000      12.5521     277.8349       0.0728      -0.0031      -0.0396     446.3797      -0.0223      -0.0161       0.0055       7.7654    2715.3745     -35.5000    4497.0000
 2723.3880      78.2172     877.7971    1950.0000     713.5744     612.8126     216.0000      11.8449     276.7184       0.0684      -0.0079      -0.0445     438.0279      -0.0234      -0.0178       0.0038       7.6228    2723.4854     -35.7500    4474.0000
 2723.5404      78.2769     929.3244    1913.6632     495.3550     448.4014     216.0000      11.5904     275.4160       0.0719      -0.0041      -0.0406     428.6328      -0.0255      -0.0205       0.0007       7.6451    2717.0027     -34.5000    4416.0000
 2723.6928      77.6970     946.8576    1777.2668     649.4970     565.6962     216.0000      13.7188     278.7652       0.0787       0.0033      -0.0329     427.1371      -0.0297      -0.0259      -0.0054       7.5222    2704.3491     -33.3750    4399.0000
 2723.8452      75.7919    1067.9791    1950.0000     616.7047     535.2269     216.0000      14.4259     278.3931       0.0965       0.0225      -0.0130     425.5207      -0.0265      -0.0214      -0.0006       7.7615    2671.5134     -31.6875    4450.0000
 2723.9976      74.1868     854.8065    1146.7800     382.2160     364.1539     216.0000      15.7644     272.2528       0.0951       0.0211      -0.0145     410.8684      -0.0214      -0.0146       0.0069       7.8394    2673.9846     -33.5000    4493.0000
 2724.1500      78.3582     436.1534     504.4885     243.2688     227.4214     216.0000      13.8392     279.2304       0.0668      -0.0097      -0.0464     391.6245      -0.0209      -0.0140       0.0076       7.5842    2726.5054     -33.8750    4568.0000
 2724.3024      81.8434    1102.5723    1472.4816     319.2601     296.1084     216.0000      15.5144     282.1144       0.0580      -0.0192      -0.0562     371.9425      -0.0267      -0.0223      -0.0010       7.4323    2742.7678     -35.1875    4526.0000
 2724.4548      83.3142    1294.0953    1950.0000     507.0328     449.4812     216.0000      15.8396     282.5796       0.0467      -0.0314      -0.0689     369.0584      -0.0252      -0.0198       0.0013       7.4258    2763.6438     -31.8750    4465.0000
 2724.6072      81.0077     833.6414    1950.0000     709.5873     643.4008     216.0000      17.6745     277.2766       0.0789       0.0035      -0.0328     372.2405      -0.0205      -0.0135       0.0082       7.5158    2704.0933     -34.4375    4470.0000
 2724.7596      74.6935     492.5189    1827.4163     743.4824     667.9586     216.0000      20.0568     275.7881       0.0830       0.0079      -0.0282     381.9699      -0.0213      -0.0143       0.0070       7.6245    2696.4636     -33.5625    4421.0000
 2724.9120      69.4287     329.0294    1494.4850     819.3208     732.1993     216.0000      27.2289     278.9513       0.0872       0.0125      -0.0234     386.4121      -0.0252      -0.0194       0.0014       7.7785    2688.6416     -30.8125    4441.0000
 2725.0644      67.5332     255.9023    1214.2709     776.3408     705.4191     216.0000      35.0219     276.5324       0.0688      -0.0074      -0.0440     387.6860      -0.0294      -0.0253      -0.0048       7.5625    2722.6648     -30.4375    4592.0000
 2725.2168      63.5699     182.8610     569.4099     426.6305     399.1131     216.0000      40.1978     278.3931       0.0887       0.0141      -0.0218     390.4409      -0.0251      -0.0191       0.0016       7.4973    2685.9517     -30.2500    4689.0000
 2725.3692      71.5508     373.9364    1280.6563     809.2676     721.1412     216.0000      38.1203     281.1841       0.0828       0.0077      -0.0284     391.2618      -0.0238      -0.0169       0.0037       7.4586    2696.8557     -32.0625    4651.0000
 2725.5216      73.8059     557.9559    1950.0000     911.3376     832.4777     216.0000      33.5816     282.8586       0.0816       0.0064      -0.0298     389.8866      -0.0250      -0.0189       0.0018       7.6027    2699.1096     -32.0000    4536.0000
 2725.6740      73.5456     704.1516    1950.0000     689.5727     611.6262     216.0000      31.2213     284.5333       0.0826       0.0074      -0.0286     381.7785      -0.0267      -0.0215      -0.0008       7.4563    2697.2632     -30.1250    4472.0000
 2725.8264      70.9695     564.7361    1239.5540     468.4755     428.7950     216.0000      32.2827     283.0447       0.0588      -0.0182      -0.0553     366.7634      -0.0234      -0.0176       0.0038       7.3480    2741.1758     -29.3125    4474.0000
 2725.9788      63.0866     302.8864     473.2665     199.1281     189.3453     216.0000      34.0030     279.7886       0.0484      -0.0295      -0.0669     359.3743      -0.0186      -0.0117       0.0106       7.2564    2760.3716     -29.3125    4561.0000
 2726.1312      75.9902     489.0712     996.9185     389.1400     368.3984     216.0000      33.4197     283.0447       0.0575      -0.0197      -0.0568     358.9020      -0.0225      -0.0169       0.0050       7.1991    2743.6702     -29.3125    4565.0000
 2726.2836      79.6035     579.5410    1859.5159     372.5909     352.3785     216.0000      30.1903     283.4169       0.0788       0.0033      -0.0329     376.3246      -0.0230      -0.0171       0.0044       7.3813    2704.2891     -31.7500    4600.0000
 2726.4360      76.3782     379.0749     754.4694     214.2525     207.4727     216.0000      27.3513     273.6484       0.0748      -0.0010      -0.0374     400.3003      -0.0214      -0.0150       0.0067       7.6786    2711.6880     -36.0000    4573.0000
 2726.5884      76.5131     308.1885     425.6691     182.9175     175.3841     216.0000      22.4119     280.8119       0.0615      -0.0154      -0.0523     419.8268      -0.0238      -0.0180       0.0033       7.6374    2736.2612     -31.5000    4504.0000
 2726.7408      87.1857     314.2498     378.6804     295.2303     278.8258     216.0000      20.3580     284.9054       0.0483      -0.0296      -0.0670     430.8686      -0.0261      -0.0212      -0.0001       7.5348    2760.5908     -29.3125    4490.0000
 2726.8932     109.1850     627.7733     565.9109     452.9408     466.5277     216.0000      19.0779     282.4865       0.0784       0.0029      -0.0334     435.5175      -0.0236      -0.0178       0.0036       7.3057    2705.0513     -29.3125    4454.0000
 2727.0456      96.3164     426.9428     339.3995     335.4636     319.5947     216.0000      19.9505     282.8586       0.0850       0.0101      -0.0259     432.2293      -0.0233      -0.0169       0.0041       7.6883    2692.7788     -29.3125    4438.0000
 2727.1980      97.5854     106.3420      87.7280      85.2569      84.4178     216.0000      21.2641     285.6496       0.0694      -0.0068      -0.0434     420.1682      -0.0238      -0.0174       0.0035       7.4351    2721.6350     -27.8125    4506.0000
 2727.3504      44.7806      44.9367      38.5936      54.9318      54.4448     216.0000      19.8550     281.9283       0.0721      -0.0039      -0.0404     390.9564      -0.0262      -0.0214      -0.0003       7.0111    2716.6699     -29.0625    4506.0000
 2727.5028      45.3591      88.7442      59.1785      39.9703      39.6233     216.0000      20.4770     272.2528       0.0725      -0.0034      -0.0399     356.8127      -0.0229      -0.0180       0.0042       7.1614    2715.8032     -29.3125    4550.0000
 2727.6552      34.6649     221.3525     145.5123      62.7973      62.0732     216.0000      18.4521     281.7422       0.0847       0.0098      -0.0262     308.5511      -0.0156      -0.0072       0.0151       7.1318    2693.2466     -27.6250    4550.0000
 2727.8076      40.1123     298.7371     238.3862      61.9540      61.2191     216.0000      20.7285     286.9521       0.1070       0.0339      -0.0013     253.5105      -0.0215      -0.0148       0.0066       7.0139    2652.0989     -26.8125    4498.0000
 2727.9600      50.2153     791.6686     694.5198      79.6908      78.3390     216.0000      20.7568     285.8357       0.1109       0.0381       0.0032     200.6147      -0.0237      -0.0174       0.0037       6.8306    2644.7659     -26.3125    4523.0000
 2728.1124      69.4780     542.1318     541.6168     115.6557     113.5122     216.0000      21.6651     278.3931       0.1176       0.0454       0.0107     170.0273      -0.0242      -0.0189       0.0026       6.6728    2632.4036     -24.8750    4487.0000
 2728.2648      83.6652     425.4385    1083.1760     201.5553     197.1625     216.0000      18.7384     279.6955       0.0960       0.0220      -0.0136     165.2737      -0.0215      -0.0152       0.0066       6.5366    2672.4377     -28.3125    4573.0000
 2728.4172      85.0617     433.1222    1334.8459     323.3753     314.5960     216.0000      15.3781     275.4160       0.1274       0.0559       0.0216     178.7651      -0.0162      -0.0082       0.0142       6.7191    2614.3330     -27.8125    4469.0000
 2728.5696      79.9612     454.6279    1610.5209     385.7324     371.6980     216.0000      10.8396     275.6021       0.1106       0.0377       0.0027     195.0440      -0.0220      -0.0156       0.0060       7.1821    2645.4646     -26.6250    4446.0000
 2728.7220      75.9065     512.9865    1492.7046     277.0579     268.3270     216.0000       7.9713     271.9737       0.1045       0.0312      -0.0041     204.7520      -0.0265      -0.0218      -0.0007       6.9603    2656.6899     -24.1250    4545.0000
 2728.8744      77.7056     698.2200    1950.0000     472.4963     419.4410     216.0000       6.9957     271.3225       0.1066       0.0335      -0.0016     215.3928      -0.0234      -0.0170       0.0041       6.6592    2652.7104     -25.8125    4520.0000
 2729.0268      78.8597     800.9839    1950.0000     492.6380     465.9411     216.0000       7.0718     279.7886       0.0861       0.0113      -0.0247     244.9806      -0.0257      -0.0194       0.0009       6.8661    2690.6741     -26.8750    4497.0000
 2729.1792      75.4570     571.2461    1360.8818     395.3353     377.8903     216.0000       6.9029     273.7414       0.0811       0.0058      -0.0303     292.3319      -0.0249      -0.0181       0.0021       7.2833    2700.0247     -23.8125    4463.0000
 2729.3316      66.4320     251.5796     483.7321     262.4402     254.5206     216.0000       8.1623     273.6484       0.0700      -0.0062      -0.0428     331.4881      -0.0311      -0.0267      -0.0070       7.4028    2720.5740     -24.1250    4447.0000
 2729.4840      79.5154     411.0752    1171.5771     390.3297     369.8969     216.0000       9.8205     276.7184       0.0420      -0.0364      -0.0741     344.2142      -0.0312      -0.0269      -0.0073       7.2961    2772.2996     -22.1875    4499.0000
 2729.6364      76.5085     436.3279    1950.0000     469.4915     437.6917     216.0000      11.3090     278.1140       0.0662      -0.0102      -0.0469     339.2663      -0.0260      -0.0191       0.0007       7.1316    2727.4570     -24.3750    4497.0000
 2729.7888      73.2684     447.4598    1764.7217     270.0574     248.5384     216.0000      10.7000     277.2766       0.0833       0.0083      -0.0278     337.7697      -0.0291      -0.0238      -0.0041       7.4191    2695.8552     -28.1875    4436.0000
 2729.9412      74.8762     530.4611    1892.3695     352.6984     317.7751     216.0000      11.6860     272.8111       0.0691      -0.0071      -0.0437     346.1978      -0.0275      -0.0217      -0.0017       7.3735    2722.1323     -22.1250    4454.0000
 2730.0936      84.5863     763.3879    1950.0000     335.6455     314.2827     216.0000      12.9047     273.5553       0.0716      -0.0045      -0.0410     343.9760      -0.0265      -0.0209      -0.0004       7.2411    2717.6233     -22.3750    4448.0000
 2730.2460      97.9709    1177.7833    1950.0000     311.7817     290.8744     216.0000      12.4711     277.4627       0.0786       0.0031      -0.0331     324.9872      -0.0270      -0.0220      -0.0013       7.0638    2704.6458     -21.9375    4479.0000
 2730.3984     102.2731    1526.5088    1950.0000     283.6043     266.0287     216.0000      11.1458     278.9513       0.0838       0.0087      -0.0273     284.3018      -0.0234      -0.0171       0.0040       7.0568    2695.0383     -22.8750    4481.0000
 2730.5508      87.2574     696.3264     873.2499     329.9617     306.6577     216.0000      10.9421     278.3931       0.0485      -0.0294      -0.0668     239.2819      -0.0224      -0.0153       0.0056       6.6673    2760.3000     -22.3750    4454.0000
 2730.7032      74.8901     371.0320     515.0735     208.5966     199.6787     216.0000      11.3757     276.9976       0.0503      -0.0274      -0.0648     197.0358      -0.0254      -0.0193       0.0012       6.5007    2756.8875     -23.5000    4478.0000
 2730.8556      68.3915     230.7931     361.5644     310.6159     289.5011     216.0000      12.1925     277.6488       0.0652      -0.0114      -0.0481     154.9549      -0.0262      -0.0201       0.0002       6.4881    2729.4290     -23.4375    4501.0000
 2731.0080      76.2906     369.2045     727.0746     282.1130     260.8499     216.0000      10.7718     281.1841       0.0571      -0.0201      -0.0572     130.1467      -0.0288      -0.0235      -0.0036       6.0475    2744.4390     -23.5000    4484.0000
 2731.1604      80.5285     501.9317    1063.1498     323.0911     293.9274     216.0000      11.0760     277.2766       0.0603      -0.0166      -0.0536     124.5806      -0.0281      -0.0225      -0.0026       5.9041    2738.4028     -23.0000    4491.0000
 2731.3128      81.7794     624.7162    1928.8411     365.2409     323.0871     216.0000      12.1897     275.8812       0.0775       0.0019      -0.0344     137.6619      -0.0312      -0.0265      -0.0071       6.4953    2706.6992     -23.8125    4521.0000
 2731.4652      81.7354     584.1167    1950.0000     438.3575     384.1826     216.0000      12.9477     264.6241       0.0618      -0.0150      -0.0519     144.6636      -0.0268      -0.0204      -0.0005       6.5165    2735.6045     -23.3125    4504.0000
 2731.6176      78.4665     376.3682    1559.4313     559.1281     452.9742     216.0000      13.7275     263.8798       0.0529      -0.0247      -0.0619     140.9285      -0.0270      -0.0208      -0.0009       6.2158    2752.1833     -25.1250    4493.0000
 2731.7700      72.9995     193.5456     764.1068     419.9972     370.6710     216.0000      12.1053     265.5544       0.0516      -0.0261      -0.0634     150.7287      -0.0282      -0.0229      -0.0028       6.2151    2754.5981     -26.2500    4501.0000
 2731.9224      55.4850     157.8169     488.0796     273.8099     237.9989     216.0000      12.2136     267.7872       0.0614      -0.0154      -0.0523     191.5271      -0.0296      -0.0249      -0.0049       6.5345    2736.3628     -26.4375    4539.0000
 2732.0748      63.3136     192.0700     740.5465     377.4335     323.5902     216.0000      11.4339     275.2299       0.0872       0.0124      -0.0235     254.8211      -0.0302      -0.0253      -0.0056       7.1608    2688.7598     -28.6875    4539.0000
 2732.2272      66.6467     233.5250     944.0533     271.9612     228.0862     216.0000      11.2481     277.8349       0.0819       0.0067      -0.0294     300.4868      -0.0243      -0.0171       0.0032       7.4205    2698.5500     -28.7500    4550.0000
 2732.3796      63.4022     245.2318    1017.2877     479.2250     420.1315     216.0000      11.2522     287.8825       0.0709      -0.0052      -0.0417     321.2750      -0.0251      -0.0189       0.0017       7.4526    2718.8127     -31.7500    4563.0000
 2732.5320      63.6797     266.0316     990.0903     412.0097     374.0055     216.0000      11.4519     287.0452       0.0608      -0.0161      -0.0530     323.6046      -0.0255      -0.0206       0.0008       7.4140    2737.4895     -29.3125    4512.0000
 2732.6844      65.1814     272.2211     885.3616     410.9813     364.2257     216.0000      13.8366     295.6973       0.0404      -0.0382      -0.0759     331.6367      -0.0233      -0.0174       0.0041       7.0473    2775.2869     -29.3125    4454.0000
 2732.8368      68.8717     231.6011     532.2603     231.8299     201.9984     216.0000      15.2041     296.4416       0.0819       0.0067      -0.0294     347.1696      -0.0219      -0.0156       0.0061       7.2013    2698.5525     -29.3125    4504.0000
 2732.9892      71.5029     303.2722     618.5045     232.8141     217.9121     216.0000      14.5918     305.0006       0.0748      -0.0010      -0.0374     353.4570      -0.0166      -0.0086       0.0137       7.4062    2711.6445     -32.8750    4498.0000
 2733.1416      76.5343     464.1433    1059.2913     448.3882     418.2837     216.0000      10.5792     317.2810       0.0598      -0.0171      -0.0541     349.9563      -0.0233      -0.0175       0.0040       7.2873    2739.2971     -31.3125    4473.0000
 2733.2940      72.7801     736.4100    1407.7089     747.6824     685.4333     216.0000       7.7368     304.8145       0.0679      -0.0085      -0.0451     334.4457      -0.0253      -0.0198       0.0012       7.2225    2724.4714     -32.3125    4515.0000
 2733.4464      70.9449     942.8904    1921.8573    1284.3746    1230.4575     216.0000       6.8697     306.5822       0.0731      -0.0028      -0.0393     329.3669      -0.0279      -0.0225      -0.0024       7.3585    2714.7996     -37.5000    4586.0000
 2733.5988      71.1488    1175.9497    1950.0000    1899.3944    1541.4501     216.0000       7.6612     307.7916       0.0663      -0.0102      -0.0469     325.8026      -0.0265      -0.0202      -0.0002       7.3929    2727.3997     -36.6250    4655.0000
 2733.7512      72.0493    1278.8468    1950.0000    1156.8527     863.9020     216.0000       6.4262     302.0236       0.0610      -0.0159      -0.0529     327.9240      -0.0295      -0.0248      -0.0048       7.1273    2737.2378     -39.0625    4584.0000
 2733.9036      72.6734    1150.4130    1950.0000     705.7488     600.3218     216.0000       7.1850     303.5121       0.0783       0.0029      -0.0334     327.0381      -0.0285      -0.0231      -0.0031       7.3768    2705.0737     -37.8750    4508.0000
 2734.0560      73.1170     693.7369    1287.4562     508.5179     442.4648     216.0000       6.6774     304.6285       0.0835       0.0085      -0.0276     327.4317      -0.0253      -0.0186       0.0016       7.5131    2695.5251     -41.5000    4568.0000
 2734.2084      76.0014     619.1219     635.1495     354.3510     323.4610     216.0000       8.3192     302.7678       0.0687      -0.0075      -0.0442     313.1576      -0.0270      -0.0212      -0.0010       7.2760    2722.8965     -39.0625    4571.0000
 2734.3608      76.2315     462.2848    1110.7903     420.1704     375.7498     216.0000       8.3192     309.9314       0.0921       0.0177      -0.0180     285.3646      -0.0282      -0.0222      -0.0025       7.4306    2679.6672     -39.0625    4539.0000
 2734.5132      81.8760     763.4337    1844.3693     442.6228     387.4372     216.0000       9.0298     300.7211       0.0575      -0.0196      -0.0567     247.7117      -0.0301      -0.0249      -0.0054       7.0288    2743.5764     -39.0625    4520.0000
 2734.6656      78.1877     734.4178    1911.8206     341.2961     310.6499     216.0000       9.1223     291.7899       0.0659      -0.0106      -0.0473     223.0017      -0.0317      -0.0273      -0.0079       6.5187    2728.0740     -45.5000    4630.0000
 2734.8180      71.1739     430.3280     692.7593     195.1174     176.9373     216.0000       9.3385     290.1153       0.0572      -0.0200      -0.0571     212.1081      -0.0281      -0.0223      -0.0025       6.6752    2744.2168     -44.1875    4619.0000
 2734.9704      67.6572     531.6078    1350.6395     257.7180     236.6153     216.0000       9.3186     288.8128       0.0689      -0.0074      -0.0440     224.3154      -0.0256      -0.0187       0.0013       6.7439    2722.5962     -42.8750    4606.0000
 2735.1228      62.9745     482.2393    1061.5240     148.0828     132.4897     216.0000       9.6328     289.2780       0.0698      -0.0064      -0.0429     243.8107      -0.0262      -0.0199       0.0002       7.0617    2720.8616     -42.7500    4538.0000
 2735.2752      61.8960     593.4592    1343.6329     319.0550     281.3676     216.0000      11.0426     295.1391       0.0646      -0.0119      -0.0487     268.3084      -0.0253      -0.0186       0.0016       7.0367    2730.4128     -40.0625    4589.0000
 2735.4276      64.0313     965.4166    1950.0000     523.3696     481.9206     216.0000      12.2337     293.7436       0.0820       0.0069      -0.0293     279.3734      -0.0308      -0.0271      -0.0069       7.2996    2698.2834     -45.2500    4616.0000
 2735.5800      62.9679    1156.9873    1310.9644     506.6514     439.0214     216.0000      13.9790     290.1153       0.0790       0.0036      -0.0327     279.8219      -0.0227      -0.0156       0.0052       7.6037    2703.9060     -46.3125    4567.0000
 2735.7324      52.3349     419.2712     629.4366     416.1495     379.3648     216.0000      13.6869     292.3481       0.0628      -0.0139      -0.0508     267.1900      -0.0208      -0.0134       0.0079       7.1986    2733.8113     -43.9375    4565.0000
 2735.8848      41.1980     421.0853    1015.9757     396.7364     361.9410     216.0000      15.7505     294.9530       0.0723      -0.0037      -0.0402     263.9155      -0.0270      -0.0221      -0.0014       6.9374    2716.3247     -45.5000    4539.0000
 2736.0372      38.5120     351.9713     955.5079     357.2457     332.3238     216.0000      14.4048     296.8137       0.0720      -0.0040      -0.0405     274.2433      -0.0286      -0.0241      -0.0037       7.1550    2716.8523     -48.8125    4506.0000
 2736.1896      45.9885     291.5821     894.1665     281.3834     262.7072     216.0000      13.6130     296.6276       0.1009       0.0273      -0.0080     306.4036      -0.0292      -0.0242      -0.0042       7.2118    2663.2556     -46.8125    4526.0000
 2736.3420      64.6961     170.3093     385.4816     214.1758     201.9097     216.0000      11.4450     294.3018       0.0802       0.0049      -0.0313     348.1198      -0.0259      -0.0201       0.0005       7.7141    2701.5674     -43.7500    4460.0000
 2736.4944      81.8806     348.9167    1046.5616     317.9671     293.9328     216.0000      12.3572     293.2784       0.0750      -0.0007      -0.0371     380.5578      -0.0202      -0.0122       0.0089       7.7275    2711.1831     -43.8125    4539.0000
 2736.6468      74.3160     412.5873    1950.0000     783.9803     733.2643     216.0000      13.9570     293.1854       0.0633      -0.0134      -0.0503     388.2329      -0.0226      -0.0162       0.0051       7.5694    2732.9524     -48.8125    4525.0000
 2736.7992      64.8851     333.2033    1950.0000    1372.9825     968.3625     216.0000      15.2578     291.2317       0.0660      -0.0104      -0.0472     374.3570      -0.0254      -0.0196       0.0011       7.3507    2727.8540     -43.6250    4544.0000
 2736.9516      60.0407     260.6678    1148.6642     916.3256     644.1202     216.0000      13.6380     292.9063       0.0783       0.0029      -0.0334     354.5885      -0.0298      -0.0254      -0.0053       7.5550    2705.0552     -48.8125    4587.0000
 2737.1040      62.0795     267.1390    1356.8938    1123.8962     903.0423     216.0000      12.7970     295.1391       0.0684      -0.0079      -0.0445     334.7571      -0.0307      -0.0258      -0.0063       7.5586    2723.4604     -44.0625    4579.0000
 2737.2564      68.0734     411.5815    1950.0000    1950.0000    1278.5334     216.0000      11.3839     286.0218       0.0409      -0.0376      -0.0753     312.6714      -0.0299      -0.0247      -0.0051       7.1853    2774.2981     -42.8125    4532.0000
 2737.4088      69.5352     611.2957    1950.0000     833.1641     659.1652     216.0000      12.0987     287.1382       0.0431      -0.0353      -0.0729     297.7362      -0.0300      -0.0245      -0.0052       7.1391    2770.2847     -43.8125    4549.0000
 2737.5612      65.4713     648.4670    1950.0000     647.8572     430.4293     216.0000      12.8575     285.3705       0.0546      -0.0228      -0.0600     293.4515      -0.0277      -0.0211      -0.0017       7.3006    2748.9299     -43.4375    4525.0000
 2737.7136      61.7366     514.5043    1950.0000     371.4207     307.4850     216.0000      14.6984     286.2079       0.0602      -0.0167      -0.0537     301.5673      -0.0288      -0.0231      -0.0035       7.3128    2738.5845     -44.2500    4529.0000
 2737.8660      61.4674     407.6521    1950.0000     453.0043     373.1104     216.0000      14.1868     291.2317       0.0564      -0.0209      -0.0580     310.9005      -0.0278      -0.0213      -0.0019       7.3432    2745.7261     -42.5625    4490.0000
 2738.0184      63.5751     354.9164    1950.0000     738.7947     631.3613     216.0000      12.9531     290.3013       0.0594      -0.0176      -0.0547     318.6266      -0.0276      -0.0208      -0.0015       7.5351    2740.1738     -42.9375    4541.0000
 2738.1708      64.6459     325.9597    1950.0000    1354.2101    1197.6921     216.0000      10.7873     292.1620       0.0528      -0.0247      -0.0620     323.7851      -0.0302      -0.0240      -0.0052       7.6160    2752.3145     -43.8125    4603.0000
 2738.3232      63.2144     305.3766    1950.0000    1716.7192    1621.5284     216.0000      11.0115     299.8838       0.0306      -0.0488      -0.0870     323.9517      -0.0351      -0.0308      -0.0125       7.1788    2793.4810     -44.1250    4542.0000
 2738.4756      61.6545     306.4814    1950.0000    1950.0000    1916.1544     216.0000      11.2185     290.6735       0.0624      -0.0143      -0.0512     328.8920      -0.0302      -0.0241      -0.0052       7.1874    2734.4907     -44.1250    4512.0000
 2738.6280      61.9945     350.7863    1950.0000    1888.6578    1790.5179     216.0000      10.5688     292.6272       0.1106       0.0378       0.0028     340.7538      -0.0341      -0.0296      -0.0111       7.7735    2645.4365     -43.8750    4496.0000
 2738.7804      63.5080     450.7623    1950.0000    1719.0442    1500.8378     216.0000      10.0268     299.3256       0.1033       0.0299      -0.0054     358.2704      -0.0317      -0.0256      -0.0073       8.0048    2658.9458     -43.5000    4504.0000
 2738.9328      64.1810     566.6248    1950.0000    1950.0000    1746.5658     216.0000       9.2075     294.8600       0.0804       0.0052      -0.0310     372.2582      -0.0336      -0.0287      -0.0103       7.7300    2701.1775     -45.1875    4542.0000
 2739.0852      63.5356     612.5072    1950.0000     981.2747     715.7711     216.0000       8.3177     303.5121       0.0731      -0.0028      -0.0393     379.5133      -0.0353      -0.0310      -0.0128       7.5527    2714.8376     -43.8125    4496.0000
 2739.2376      62.5781     607.8898    1950.0000     446.2348     378.0880     216.0000       9.1849     294.7670       0.0665      -0.0099      -0.0467     380.7189      -0.0284      -0.0216      -0.0026       7.7511    2726.9907     -43.5625    4446.0000
 2739.3900      61.7960     605.3732    1950.0000     801.5074     536.1868     216.0000       9.4890     295.6973       0.0532      -0.0243      -0.0615     383.9738      -0.0311      -0.0255      -0.0066       7.6737    2751.5127     -43.0625    4495.0000
 2739.5424      61.0526     598.1326    1950.0000     658.9771     456.1674     216.0000       9.7314     297.3719       0.0652      -0.0113      -0.0481     388.0153      -0.0321      -0.0267      -0.0081       7.7282    2729.3699     -43.4375    4497.0000
 2739.6948      60.9317     581.7043    1950.0000     518.1264     382.5039     216.0000       9.1820     296.8137       0.0644      -0.0122      -0.0490     392.6911      -0.0296      -0.0234      -0.0044       7.7432    2730.9153     -43.8125    4476.0000
 2739.8472      61.6935     544.0618    1950.0000     683.9147     495.9333     216.0000       8.1198     299.3256       0.0620      -0.0148      -0.0517     401.4258      -0.0297      -0.0236      -0.0045       7.6352    2735.2759     -42.9375    4452.0000
 2739.9996      62.0858     451.4095    1950.0000     906.4237     641.3560     216.0000       9.6063     294.5809       0.0719      -0.0041      -0.0406     407.9153      -0.0329      -0.0289      -0.0096       7.6804    2717.0342     -41.8750    4418.0000
 2740.1520      61.4580     361.4727    1950.0000     840.5316     585.7821     216.0000      10.5893     294.3948       0.0882       0.0135      -0.0224     416.4479      -0.0276      -0.0216      -0.0018       7.8979    2686.9058     -43.8750    4462.0000
 2740.3044      61.1450     325.0063    1950.0000    1118.3702     822.7271     216.0000      11.4556     307.4195       0.0839       0.0089      -0.0272     430.8631      -0.0301      -0.0251      -0.0055       8.0606    2694.8064     -40.9375    4448.0000
 2740.4568      61.2522     331.1479    1950.0000    1950.0000    1597.3213     216.0000      13.4378     304.6285       0.0642      -0.0125      -0.0493     441.3371      -0.0268      -0.0206      -0.0005       7.8355    2731.2913     -42.0000    4452.0000
 2740.6092      60.2997     342.7984    1950.0000    1419.8707    1006.7487     216.0000      14.3853     303.6982       0.0710      -0.0051      -0.0416     455.3228      -0.0283      -0.0233      -0.0031       7.6920    2718.6570     -43.8125    4514.0000
 2740.7616      58.7557     349.7508    1950.0000    1180.6479     499.0507     216.0000      18.2909     309.0941       0.0886       0.0140      -0.0219     459.5616      -0.0280      -0.0227      -0.0026       7.8573    2686.1411     -46.6875    4510.0000
 2740.9140      58.2935     385.1762    1950.0000    1106.9545     696.1198     216.0000      21.1740     306.8613       0.0908       0.0164      -0.0194     459.6372      -0.0260      -0.0204       0.0003       7.9939    2681.9595     -43.1250    4491.0000
 2741.0664      59.0068     483.5165    1950.0000     685.9414     382.2328     216.0000      24.3456     305.0006       0.0788       0.0033      -0.0329     446.7385      -0.0172      -0.0086       0.0131       7.9854    2704.2844     -42.5625    4535.0000
 2741.2188      59.6337     612.9510    1950.0000    1045.0060     617.6112     216.0000      22.3945     309.2802       0.0541      -0.0234      -0.0606     411.6030      -0.0232      -0.0168       0.0043       7.6811    2749.9739     -41.7500    4488.0000
 2741.3712      59.5272     628.1839    1950.0000     888.8779     618.5004     216.0000      18.7449     306.3031       0.0660      -0.0104      -0.0472     371.4135      -0.0286      -0.0241      -0.0036       7.4389    2727.8184     -42.7500    4479.0000
 2741.5236      58.8719     523.2670    1950.0000     476.2091     291.5102     216.0000      14.8381     304.9076       0.0841       0.0091      -0.0270     336.6852      -0.0306      -0.0268      -0.0066       7.6337    2694.4768     -42.5000    4444.0000
 2741.6760      58.4768     428.7281    1950.0000     605.9708     361.6393     216.0000      14.4081     308.1638       0.0723      -0.0037      -0.0402     333.7703      -0.0255      -0.0195       0.0011       7.3864    2716.2803     -43.1250    4445.0000
 2741.8284      59.1531     378.4169    1950.0000     971.6982     750.7207     216.0000      15.2830     306.0240       0.0710      -0.0050      -0.0416     353.2927      -0.0274      -0.0225      -0.0019       7.7498    2718.5923     -43.3750    4478.0000
 2741.9808      61.2498     369.4327    1950.0000    1198.9713     953.1084     216.0000      14.3892     308.3498       0.0949       0.0208      -0.0148     384.8057      -0.0273      -0.0219      -0.0016       7.7631    2674.4971     -42.6875    4522.0000
 2742.1332      63.9809     401.0739    1950.0000    1301.2482    1019.5679     216.0000      12.6512     312.2572       0.1146       0.0422       0.0073     414.9072      -0.0240      -0.0166       0.0036       8.2660    2637.9158     -45.5625    4479.0000
 2742.2856      65.8781     481.3001    1950.0000    1184.1204     848.4227     216.0000      12.1092     308.5359       0.1002       0.0265      -0.0089     447.0663      -0.0248      -0.0173       0.0026       8.0918    2664.6404     -41.6875    4465.0000
 2742.4380      65.4904     614.6709    1950.0000     950.6819     668.7437     216.0000      15.3574     307.4195       0.0876       0.0129      -0.0230     474.3330      -0.0347      -0.0317      -0.0125       7.9975    2687.9834     -42.2500    4480.0000
 2742.5904      63.0102     713.1688    1950.0000     995.9188     661.2536     216.0000      16.5498     313.0015       0.0781       0.0026      -0.0336     482.8949      -0.0289      -0.0228      -0.0035       8.0808    2705.5066     -42.6875    4481.0000
 2742.7428      59.2937     594.1306    1950.0000     584.4138     448.1278     216.0000      16.8750     313.5597       0.0925       0.0182      -0.0175     461.2510      -0.0327      -0.0282      -0.0093       8.1586    2678.9202     -40.6250    4577.0000
 2742.8952      56.5746     411.6341    1294.2803     295.9366     250.6291     216.0000      14.9587     305.1867       0.0808       0.0056      -0.0306     423.3568      -0.0301      -0.0249      -0.0055       7.9308    2700.4600     -41.6250    4499.0000
 2743.0476      56.3719     365.7938    1302.7372     170.5452     146.1383     216.0000      14.1789     305.3728       0.0672      -0.0092      -0.0459     382.4928      -0.0280      -0.0220      -0.0023       7.7168    2725.7705     -41.5000    4560.0000
 2743.2000      59.3225     411.8206    1950.0000     319.5151     263.2304     216.0000      13.3070     308.5359       0.0748      -0.0009      -0.0373     358.3634      -0.0277      -0.0222      -0.0020       7.6124    2711.6145     -40.3125    4542.0000
 2743.3524      62.4285     494.9813    1713.9047     390.9887     294.0434     216.0000      13.3070     308.5359       0.0967       0.0228      -0.0127     344.5954      -0.0248      -0.0186       0.0021       7.6054    2671.0205     -39.2500    4488.0000
 2743.5048      63.7121     620.7315    1950.0000     386.1618     279.0529     216.0000      15.4407     305.9310       0.1016       0.0281      -0.0073     346.1204      -0.0245      -0.0187       0.0024       7.8986    2661.9868     -40.3750    4558.0000
 2743.6572      63.2370     745.6061    1950.0000     762.8796     625.6833     216.0000      16.3126     305.9310       0.0792       0.0038      -0.0324     363.4920      -0.0216      -0.0141       0.0068       8.1503    2703.4517     -39.0625    4499.0000
 2743.8096      63.0566     689.5743    1950.0000    1053.4393     825.1879     216.0000      16.3076     304.8145       0.0759       0.0003      -0.0361     393.0118      -0.0279      -0.0224      -0.0024       7.7312    2709.5537     -40.7500    4479.0000
 2743.9620      64.2018     500.1547    1950.0000     900.9023     496.1290     216.0000      16.0079     304.3494       0.0929       0.0187      -0.0170     423.2755      -0.0304      -0.0255      -0.0059       8.0800    2678.0637     -38.6250    4536.0000
 2744.1144      65.0228     375.5511    1950.0000    1179.8199     867.2451     216.0000      15.6827     309.4662       0.1187       0.0466       0.0119     446.8531      -0.0266      -0.0197      -0.0001       8.2897    2630.3154     -39.0625    4551.0000
 2744.2668      64.3423     345.3683    1950.0000    1174.8799     883.2791     216.0000      16.3858     309.3732       0.1167       0.0444       0.0097     459.2171      -0.0268      -0.0202      -0.0005       8.3370    2634.0171     -39.0625    4560.0000
 2744.4192      63.7913     406.2480    1915.3064     983.4816     778.7178     216.0000      17.1744     313.0015       0.1136       0.0410       0.0062     470.2969      -0.0295      -0.0245      -0.0047       8.4330    2639.8181     -39.8125    4557.0000
 2744.5716      64.1865     558.4031    1950.0000    1110.9265     743.1690     216.0000      18.2584     308.9080       0.1057       0.0325      -0.0027     467.9096      -0.0270      -0.0214      -0.0010       8.2599    2654.4009     -39.2500    4589.0000
 2744.7240      63.2028     656.9890    1950.0000     424.7120     359.2023     216.0000      19.7810     303.5121       0.1104       0.0375       0.0025     458.3979      -0.0266      -0.0215      -0.0007       8.3351    2645.8523     -41.1875    4577.0000
 2744.8764      60.0825     648.6249    1378.5272     286.4252     240.2899     216.0000      21.4332     298.7674       0.1138       0.0413       0.0064     430.0919      -0.0243      -0.0189       0.0025       8.1279    2639.4226     -39.0625    4486.0000
 2745.0288      57.3834     390.3334     812.4380     186.4123     169.8017     216.0000      22.8423     307.6056       0.1054       0.0322      -0.0030     401.4487      -0.0217      -0.0147       0.0065       8.1586    2654.9980     -39.0625    4472.0000
 2745.1812      60.4033     534.9564    1465.5560     409.8215     342.0314     216.0000      20.6091     302.1166       0.0848       0.0099      -0.0261     396.3993      -0.0207      -0.0132       0.0080       7.8405    2693.1052     -39.0625    4559.0000
 2745.3336      64.1095     516.0615    1950.0000    1052.1653     768.5027     216.0000      19.6074     303.1400       0.0933       0.0190      -0.0166     403.5830      -0.0263      -0.0209      -0.0002       7.9213    2677.4666     -39.0625    4574.0000
 2745.4860      64.0667     390.1807    1612.8046     698.8109     572.1296     216.0000      17.7974     301.0002       0.1201       0.0480       0.0134     419.3621      -0.0293      -0.0250      -0.0046       8.1480    2627.8435     -39.0625    4590.0000
 2745.6384      60.8219     265.1536     741.0919     266.6928     217.0074     216.0000      21.1617     299.9768       0.1498       0.0802       0.0468     426.1775      -0.0244      -0.0177       0.0028       8.4552    2572.7910     -39.0625    4659.0000
 2745.7908      61.5321     284.7550    1006.8294     497.7058     422.6003     216.0000      20.7397     305.7449       0.1325       0.0615       0.0274     444.6182      -0.0293      -0.0243      -0.0044       8.3668    2604.8101     -39.0625    4563.0000
 2745.9432      60.9227     311.3569     774.5974     349.3697     307.0219     216.0000      21.4657     308.5359       0.1290       0.0577       0.0234     456.6889      -0.0287      -0.0233      -0.0035       8.1338    2611.4070     -38.3125    4651.0000
 2746.0956      61.0934     183.6027     543.3458     219.6141     198.4654     216.0000      20.7406     300.1629       0.1131       0.0404       0.0056     458.2922      -0.0272      -0.0216      -0.0013       8.1657    2640.8311     -39.0625    4602.0000
 2746.2480      49.0763     253.8170     343.8802     164.5579     149.3524     216.0000      21.8130     301.8375       0.1048       0.0315      -0.0037     460.0203      -0.0280      -0.0228      -0.0025       8.2817    2656.1042     -39.0625    4605.0000
 2746.4004      63.2463     369.1231     602.6488     235.9012     202.9460     216.0000      21.7046     308.8150       0.0783       0.0029      -0.0334     461.0496      -0.0271      -0.0214      -0.0011       8.1992    2705.0808     -38.0625    4621.0000
 2746.5528      61.4862     634.2745    1290.8535     536.7847     390.2686     216.0000      18.3588     296.6276       0.0635      -0.0132      -0.0500     459.9965      -0.0284      -0.0241      -0.0034       7.9627    2732.5339     -37.6875    4558.0000
 2746.7052      59.4090     430.9944    1950.0000    1340.9817     518.2484     216.0000      16.0773     302.3957       0.0740      -0.0018      -0.0382     444.2987      -0.0218      -0.0137       0.0068       7.8397    2713.0359     -39.0625    4525.0000
 2746.8576      58.0971     269.9567    1734.4806    1104.3431     703.2537     216.0000      13.3297     299.4186       0.0781       0.0026      -0.0337     442.2534      -0.0254      -0.0187       0.0015       8.0090    2705.6042     -37.5000    4543.0000
 2747.0100      58.9874     208.6971    1950.0000    1650.7256    1095.6177     216.0000      14.1519     301.6514       0.0703      -0.0058      -0.0424     462.7821      -0.0253      -0.0185       0.0016       8.0928    2719.9014     -38.1875    4423.0000
 2747.1624      61.2440     203.3054    1950.0000    1858.8307    1435.0637     216.0000      14.0342     300.4420       0.0429      -0.0354      -0.0731     496.9330      -0.0313      -0.0276      -0.0075       8.0533    2770.5513     -31.1875    4502.0000
 2747.3148      63.0963     246.6072    1950.0000    1838.8533    1546.1263     216.0000      15.0475     308.3498       0.0638      -0.0129      -0.0497     525.0249      -0.0305      -0.0257      -0.0061       8.0929    2732.0505     -39.0625    4501.0000
 2747.4672      64.1908     363.3836    1950.0000    1950.0000    1950.0000     216.0000      17.6798     309.9314       0.0820       0.0068      -0.0293     524.9412      -0.0290      -0.0231      -0.0037       8.2212    2698.3740     -36.8125    4472.0000
 2747.6196      64.3815     564.6071    1950.0000    1218.7327     977.2740     216.0000      21.8041     314.8622       0.0962       0.0223      -0.0133     504.5950      -0.0288      -0.0225      -0.0032       8.2270    2671.9434     -36.9375    4528.0000
 2747.7720      62.8444     642.3508    1950.0000     665.0762     532.0758     216.0000      25.3672     306.3031       0.1036       0.0302      -0.0051     477.2256      -0.0277      -0.0218      -0.0019       8.1383    2658.4319     -37.3750    4538.0000
 2747.9244      59.9931     505.8517    1950.0000     282.4695     246.6857     216.0000      25.6588     302.3957       0.1078       0.0348      -0.0003     464.3853      -0.0261      -0.0203       0.0002       8.1716    2650.5049     -34.0625    4517.0000
 2748.0768      58.1882     392.2169    1950.0000     254.2376     209.4504     216.0000      22.8552     303.3260       0.1035       0.0301      -0.0051     464.8988      -0.0265      -0.0214      -0.0006       8.0961    2658.4731     -33.6875    4586.0000
 2748.2292      58.6106     347.9751    1950.0000     610.3662     501.7711     216.0000      21.1349     299.0465       0.0963       0.0223      -0.0132     465.0540      -0.0294      -0.0263      -0.0051       8.1947    2671.8286     -38.0625    4544.0000
 2748.3816      60.9546     365.1377    1950.0000     916.2822     802.2239     216.0000      19.4209     303.6982       0.0972       0.0233      -0.0122     456.7974      -0.0207      -0.0135       0.0079       7.9148    2670.1147     -35.4375    4553.0000
 2748.5340      64.9246     455.5038    1950.0000    1373.6410    1274.9246     216.0000      18.0012     306.1170       0.1187       0.0465       0.0118     450.8765      -0.0233      -0.0168       0.0043       8.0886    2630.4893     -36.3750    4471.0000
 2748.6864      69.8753     642.4677    1950.0000    1950.0000    1950.0000     216.0000      16.4672     302.9539       0.1278       0.0563       0.0220     463.2332      -0.0210      -0.0130       0.0079       8.0577    2613.6433     -36.2500    4486.0000
 2748.8388      72.0205     812.1281    1950.0000    1950.0000    1950.0000     216.0000      15.6906     302.1166       0.1061       0.0329      -0.0023     482.9869      -0.0249      -0.0188       0.0020       8.3396    2653.7834     -33.6875    4480.0000
 2748.9912      69.0668     752.4749    1950.0000     667.5622     580.8198     216.0000      16.8055     305.3728       0.0838       0.0088      -0.0273     495.6005      -0.0288      -0.0241      -0.0038       8.1676    2695.0229     -32.7500    4466.0000
 2749.1436      64.8189     640.9350    1511.3724     223.3917     200.2152     216.0000      17.1471     290.8595       0.0624      -0.0144      -0.0513     485.9731      -0.0270      -0.0225      -0.0014       8.0356    2734.6245     -32.3125    4462.0000
 2749.2960      63.2698     710.9700    1950.0000     435.3479     474.5284     216.0000      18.7366     294.5809       0.0794       0.0040      -0.0322     464.6800      -0.0268      -0.0219      -0.0011       7.7833    2703.1516     -32.1250    4513.0000
 2749.4484      63.0301     753.4786    1950.0000     541.4476     429.4558     216.0000      17.8382     293.0923       0.0994       0.0257      -0.0098     436.0964      -0.0257      -0.0195       0.0009       8.0697    2666.1118     -31.4375    4484.0000
 2749.6008      61.9188     613.3572    1950.0000     440.3299     351.2128     216.0000      15.5619     289.1849       0.0790       0.0036      -0.0326     414.2492      -0.0339      -0.0312      -0.0115       7.9398    2703.8262     -31.0000    4547.0000
 2749.7532      59.5910     449.5008    1762.3650     373.6785     284.1823     216.0000      12.9244     289.2780       0.0555      -0.0218      -0.0589     402.6504      -0.0271      -0.0215      -0.0012       7.6138    2747.2576     -30.0625    4508.0000
 2749.9056      58.1680     383.7842    1676.8599     577.2368     448.3040     216.0000      13.2493     291.6038       0.0595      -0.0175      -0.0545     400.9204      -0.0251      -0.0188       0.0017       7.4567    2739.9160     -30.0000    4471.0000
 2750.0580      58.5525     390.5971    1335.0552     703.9194     590.2153     216.0000      14.8743     295.4182       0.0758       0.0001      -0.0363     403.6326      -0.0257      -0.0197       0.0008       7.8396    2709.8557     -29.5625    4539.0000
 2750.2104      58.7380     475.8981    1728.3337     625.8112     544.8036     216.0000      14.9523     297.9301       0.0822       0.0071      -0.0290     415.9849      -0.0216      -0.0140       0.0069       7.7518    2697.8757     -29.3125    4476.0000
 2750.3628      57.0046     299.1174     470.2339     245.4749     232.6096     216.0000      15.5200     299.2325       0.0835       0.0085      -0.0276     418.7334      -0.0243      -0.0183       0.0027       7.8592    2695.4739     -29.3125    4536.0000
 2750.5152      55.1589     265.9904     342.4583     175.8808     159.1335     216.0000      16.1713     293.4644       0.0919       0.0176      -0.0181     414.5267      -0.0265      -0.0218      -0.0007       7.9271    2679.9233     -29.3125    4510.0000
 2750.6676      47.6983     250.3585     339.7310     118.8391     117.8985     216.0000      17.5171     295.4182       0.0602      -0.0167      -0.0537     395.4604      -0.0222      -0.0157       0.0057       7.7448    2738.5867     -29.3125    4462.0000
 2750.8200      46.8565     227.1167     456.5025     206.0114     195.1894     216.0000      15.3251     296.4416       0.0534      -0.0241      -0.0613     379.4687      -0.0248      -0.0191       0.0019       7.4125    2751.1794     -28.6875    4484.0000
 2750.9724      52.3065     233.2479     547.4946     234.7613     220.0863     216.0000      13.6991     291.5108       0.0611      -0.0158      -0.0527     366.9531      -0.0315      -0.0280      -0.0079       7.5743    2736.9775     -29.3125    4456.0000
 2751.1248      60.7281     225.5814     688.9724     204.5894     182.8288     216.0000      12.2712     292.3481       0.0665      -0.0099      -0.0466     365.0610      -0.0297      -0.0249      -0.0050       7.4652    2726.9404     -33.1250    4416.0000
 2751.2772      74.2928     137.4986     345.6906     212.4531     198.6497     216.0000      12.3834     285.3705       0.1093       0.0364       0.0013     376.1802      -0.0307      -0.0266      -0.0066       7.7874    2647.7932     -29.3125    4517.0000
 2751.4296      56.8280     140.9892     590.4161     310.7932     283.1000     216.0000      12.0339     294.9530       0.1105       0.0376       0.0026     379.4344      -0.0285      -0.0229      -0.0031       8.1209    2645.6406     -28.7500    4563.0000
 2751.5820      58.5910     195.9531     809.8090     456.4718     407.5644     216.0000      11.0212     301.8375       0.0798       0.0044      -0.0318     371.5269      -0.0267      -0.0200      -0.0003       7.6784    2702.4360     -26.1250    4503.0000
 2751.7344      63.5118     274.4421    1260.0608     684.1313     593.2595     216.0000      10.6923     298.6743       0.0622      -0.0145      -0.0514     367.5530      -0.0234      -0.0159       0.0044       7.4800    2734.8477     -26.0000    4529.0000
 2751.8868      71.0460     479.4185    1950.0000     622.5682     477.4068     216.0000      10.2892     292.3481       0.0603      -0.0166      -0.0536     377.4345      -0.0266      -0.0213      -0.0007       7.7875    2738.4214     -28.7500    4567.0000
 2752.0392      76.6788     872.6212    1950.0000    1142.9808     907.7979     216.0000       9.8666     291.4177       0.0565      -0.0207      -0.0578     396.3053      -0.0310      -0.0271      -0.0071       7.9827    2745.4326     -24.7500    4511.0000
 2752.1916      75.6873    1199.8398    1950.0000    1434.1406    1108.1713     216.0000       9.7375     285.8357       0.0440      -0.0343      -0.0719     403.0628      -0.0269      -0.0209      -0.0008       7.6490    2768.6882     -25.7500    4463.0000
 2752.3440      69.7064     850.0466    1918.3972     926.5366     709.2001     216.0000      10.3507     286.7661       0.0595      -0.0175      -0.0545     408.2539      -0.0279      -0.0222      -0.0022       7.7479    2739.9280     -22.0000    4494.0000
 2752.4964      64.7519     399.6717    1417.3749     610.2306     528.7589     216.0000      10.1339     288.7198       0.0787       0.0033      -0.0329     397.9178      -0.0309      -0.0268      -0.0069       7.7227    2704.3362     -22.3125    4537.0000
 2752.6488      63.7798     252.2370    1067.1162     612.5803     524.9371     216.0000       9.3966     285.3705       0.1092       0.0363       0.0012     391.7079      -0.0204      -0.0123       0.0087       7.8778    2647.9709     -24.9375    4583.0000
 2752.8012      69.4381     178.6425    1176.1591     564.4864     481.2800     216.0000       9.3931     290.3013       0.0952       0.0211      -0.0145     396.2972      -0.0247      -0.0180       0.0023       7.9387    2673.9626     -24.1875    4517.0000
 2752.9536      68.7589     159.7375    1463.4133     586.3629     511.0854     216.0000      10.1519     290.6735       0.0771       0.0015      -0.0348     410.3730      -0.0273      -0.0216      -0.0015       7.8428    2707.4492     -22.1250    4498.0000
 2753.1060      64.0283     187.6125    1783.9829     511.6623     426.3896     216.0000      10.1786     293.4644       0.0624      -0.0143      -0.0512     420.5682      -0.0249      -0.0178       0.0022       7.7744    2734.5081     -21.6250    4460.0000
 2753.2584      62.4813     271.8330    1950.0000     502.4432     445.0352     216.0000      10.2132     292.5341       0.0598      -0.0171      -0.0541     417.4201      -0.0305      -0.0261      -0.0062       8.0441    2739.3030     -21.8125    4561.0000
 2753.4108      65.4147     399.1714    1950.0000     390.6205     370.4795     216.0000       9.1785     285.8357       0.0179      -0.0625      -0.1012     409.2851      -0.0243      -0.0170       0.0031       7.6677    2816.9426     -22.4375    4584.0000
 2753.5632      68.4031     479.6982    1895.4385     525.3343     472.4445     216.0000       9.5846     279.2304       0.0368      -0.0421      -0.0800     406.3625      -0.0300      -0.0253      -0.0054       7.4611    2781.9319     -21.3750    4544.0000
 2753.7156      67.2180     477.6069    1950.0000     530.4453     473.6227     216.0000      10.2349     282.8586       0.0648      -0.0118      -0.0485     408.8891      -0.0264      -0.0197       0.0001       7.7535    2730.1033     -19.8750    4508.0000
 2753.8680      63.8660     442.3424    1674.2064     312.7043     295.8904     216.0000      12.1367     280.3468       0.0649      -0.0117      -0.0485     418.0071      -0.0264      -0.0199       0.0001       7.9249    2729.9712     -19.5625    4626.0000
 2754.0204      63.3159     471.3028    1675.5128     523.6671     426.6397     216.0000      13.0503     285.0915       0.0643      -0.0123      -0.0491     424.7880      -0.0283      -0.0230      -0.0030       7.9328    2731.0872     -19.5625    4690.0000
 2754.1728      66.1162     621.2101    1950.0000     635.1089     553.1547     216.0000      12.1831     290.1153       0.0594      -0.0176      -0.0546     418.2046      -0.0296      -0.0249      -0.0049       7.9196    2740.0225     -20.0625    4618.0000
 2754.3252      69.8978     878.2858    1915.1365     742.2181     613.7697     216.0000      11.8580     290.3944       0.0706      -0.0054      -0.0420     401.3257      -0.0263      -0.0206      -0.0001       7.6620    2719.3171     -19.5625    4575.0000
 2754.4776      72.1036    1208.0565    1950.0000     589.7145     526.1067     216.0000      12.0651     292.3481       0.0721      -0.0039      -0.0404     378.8531      -0.0272      -0.0219      -0.0015       7.8004    2716.6902     -19.5625    4543.0000
 2754.6300      72.7507    1443.7606    1950.0000     557.3219     482.1049     216.0000      12.4986     287.3243       0.0671      -0.0093      -0.0460     360.9602      -0.0262      -0.0210      -0.0001       7.6789    2725.9324     -19.5625    4515.0000
 2754.7824      72.8870    1252.5409    1950.0000     541.0526     476.3558     216.0000      11.3034     291.2317       0.0551      -0.0223      -0.0594     355.8626      -0.0237      -0.0172       0.0037       7.7241    2748.0874     -19.5625    4530.0000
 2754.9348      72.1773     778.0479    1950.0000     735.8521     633.8762     216.0000      10.7283     281.9283       0.0510      -0.0267      -0.0640     360.0242      -0.0252      -0.0193       0.0015       7.6444    2755.6445     -17.4375    4551.0000
 2755.0872      69.3332     440.9301    1255.2711     414.1166     377.1185     216.0000       9.9720     286.4870       0.0695      -0.0067      -0.0433     376.9672      -0.0283      -0.0231      -0.0030       7.5968    2721.4978     -18.5000    4517.0000
 2755.2396      64.1107     263.6073     593.2928     160.3382     147.9244     216.0000      11.1632     286.7661       0.0871       0.0124      -0.0235     398.5128      -0.0261      -0.0197       0.0004       8.0903    2688.8230     -16.1875    4570.0000
 2755.3920      71.2736     428.0783    1095.8573     361.5743     328.0977     216.0000      11.1286     288.0685       0.0832       0.0081      -0.0279     414.9234      -0.0282      -0.0234      -0.0029       7.9750    2696.0662     -17.0000    4587.0000
 2755.5444      73.5695     526.1966    1950.0000     546.3192     481.0387     216.0000      12.8605     290.3944       0.0951       0.0210      -0.0146     431.5865      -0.0262      -0.0214      -0.0002       7.9658    2674.0396     -16.1875    4538.0000
 2755.6968      77.1609     737.0209    1709.7300     511.0414     420.0678     216.0000      12.4310     293.6506       0.1057       0.0325      -0.0027     455.7195      -0.0203      -0.0139       0.0082       8.1255    2654.4436     -15.4375    4490.0000
 2755.8492      78.0997     813.5667    1950.0000     633.5438     584.6797     216.0000      12.2245     291.2317       0.1104       0.0376       0.0026     473.4144      -0.0211      -0.0152       0.0069       8.1841    2645.7441     -15.6250    4529.0000
 2756.0016      76.1719     665.0920    1950.0000     948.1745     860.5802     216.0000       9.8398     294.5809       0.1095       0.0366       0.0016     477.7574      -0.0247      -0.0200       0.0018       8.2378    2647.4214     -14.0625    4547.0000
 2756.1540      72.7360     460.8043    1950.0000    1315.9722    1179.4468     216.0000      10.3817     287.3243       0.0931       0.0188      -0.0169     472.2037      -0.0205      -0.0143       0.0078       8.0769    2677.8435     -15.6250    4533.0000
 2756.3064      70.3493     333.3696    1950.0000    1524.9324    1345.8674     216.0000      10.5144     293.8366       0.0843       0.0094      -0.0266     470.2177      -0.0243      -0.0194       0.0023       7.9804    2693.9531     -11.2500    4583.0000
 2756.4588      71.1552     287.6609    1950.0000    1474.0999    1296.7024     216.0000      12.1763     300.1629       0.0840       0.0090      -0.0270     468.1141      -0.0209      -0.0144       0.0074       7.9968    2694.6274     -14.7500    4498.0000
 2756.6112      75.6988     318.2831    1822.0001     979.4002     857.8740     216.0000      12.3218     298.6743       0.0734      -0.0025      -0.0389     449.4610      -0.0134      -0.0035       0.0185       7.8051    2714.2063      -9.7500    4499.0000
 2756.7636      80.0829     471.2723    1950.0000     619.8602     570.3580     216.0000      14.0507     288.2546       0.0721      -0.0038      -0.0404     425.8544      -0.0252      -0.0205       0.0011       7.6710    2716.5789     -14.8125    4502.0000
 2756.9160      78.1483     969.2477    1646.7269     353.0477     336.1908     216.0000      13.5813     291.2317       0.0738      -0.0020      -0.0384     399.2684      -0.0279      -0.0238      -0.0028       7.7356    2713.4294     -14.1875    4480.0000
 2757.0684      72.3268    1156.0598    1125.0238     223.5340     213.5789     216.0000      13.2724     291.4177       0.0673      -0.0091      -0.0458     383.4076      -0.0236      -0.0179       0.0035       7.4843    2725.5776     -13.8125    4498.0000
 2757.2208      72.6819    1578.6241     928.7043     204.4082     195.2382     216.0000      10.8931     285.6496       0.0757       0.0001      -0.0363     373.1461      -0.0231      -0.0171       0.0043       7.4228    2709.8640     -13.8750    4491.0000
 2757.3732      81.9190    1514.0752    1075.3214     261.3465     246.8392     216.0000      11.0598     285.6496       0.0856       0.0108      -0.0252     361.5584      -0.0233      -0.0172       0.0040       7.6932    2691.5781     -14.8750    4499.0000
 2757.5256      84.3905    1011.4093    1950.0000     407.0374     372.5377     216.0000      11.3316     283.7890       0.0880       0.0133      -0.0225     350.3716      -0.0245      -0.0184       0.0025       7.6364    2687.1794      -9.7500    4486.0000
 2757.6780      79.5858     545.0792    1819.7318     380.7671     329.1638     216.0000      12.1968     276.1603       0.0746      -0.0012      -0.0376     340.8034      -0.0278      -0.0237      -0.0026       7.5239    2711.9690      -9.7500    4527.0000
 2757.8304      74.4454     386.7132    1490.1342     383.9765     324.4965     216.0000      12.8083     272.8111       0.0675      -0.0089      -0.0456     329.4721      -0.0232      -0.0172       0.0042       7.4550    2725.1758     -10.7500    4557.0000
 2757.9828      74.1682     365.7245    1340.3630     633.6334     539.7591     216.0000      12.3728     267.2290       0.0643      -0.0123      -0.0491     312.2659      -0.0225      -0.0166       0.0051       7.6212    2731.0652      -9.7500    4591.0000
 2758.1352      78.0589     496.7220    1950.0000     766.6678     665.0723     216.0000      13.1335     270.0200       0.0471      -0.0309      -0.0684     291.7199      -0.0280      -0.0240      -0.0030       7.1793    2762.9229     -12.8125    4592.0000
 2758.2876      80.1873     684.0325    1950.0000     625.3022     574.3113     216.0000      13.3367     261.0888       0.0493      -0.0285      -0.0659     284.3583      -0.0227      -0.0170       0.0047       7.1102    2758.8076      -7.9375    4534.0000
 2758.4400      78.6382     650.6191    1950.0000     468.6984     432.5329     216.0000      14.5285     264.9962       0.0525      -0.0251      -0.0624     297.9126      -0.0248      -0.0195       0.0018       7.5641    2752.8835     -11.4375    4529.0000
 2758.5924      71.7188     484.3517    1335.7048     278.3715     255.9526     216.0000      13.8781     265.8335       0.0406      -0.0379      -0.0757     323.9322      -0.0249      -0.0201       0.0015       7.4157    2774.8442      -9.7500    4508.0000
 2758.7448      73.0027     349.9581     919.9614     178.2793     169.9005     216.0000      12.6588     270.9504       0.0673      -0.0091      -0.0457     364.5141      -0.0236      -0.0185       0.0034       7.6331    2725.4763      -9.7500    4490.0000
 2758.8972      76.8136     409.5325    1645.2906     518.1300     494.5565     216.0000      16.0175     273.3693       0.0910       0.0166      -0.0191     408.8511      -0.0224      -0.0173       0.0050       8.0370    2681.5842      -2.3125    4547.0000
 2759.0496      78.8111     459.2432    1473.1436     828.5768     784.5401     216.0000      23.0815     278.2070       0.0762       0.0006      -0.0358     445.2033      -0.0160      -0.0092       0.0141       7.9762    2709.0593      -5.8750    4490.0000
 2759.2020      77.0050     419.2449    1865.0488    1214.4779    1071.0383     216.0000      28.8428     280.3468       0.0729      -0.0030      -0.0395     467.5135      -0.0089      -0.0011       0.0238       7.9748    2715.1743      -1.6875    4463.0000
 2759.3544      73.2642     347.2814    1129.0286     661.5776     622.4851     216.0000      29.1300     281.1841       0.0574      -0.0198      -0.0569     461.6556      -0.0121      -0.0058       0.0191       7.7864    2743.8088      -3.5000    4480.0000
 2759.5068      73.9600     380.6120    1302.0814     290.6087     270.5312     216.0000      25.5346     278.5792       0.0789       0.0035      -0.0327     455.2112      -0.0172      -0.0122       0.0119       7.8335    2704.0063      -0.5000    4547.0000
 2759.6592      77.9306     586.6799    1950.0000     406.4721     388.5138     216.0000      24.0178     287.8825       0.0851       0.0102      -0.0258     448.0145      -0.0207      -0.0158       0.0072       8.0071    2692.5864      -2.3750    4550.0000
 2759.8116      79.9197     998.3821    1932.1484     299.8914     289.0497     216.0000      23.6265     282.5796       0.0915       0.0171      -0.0186     447.8116      -0.0156      -0.0087       0.0147       7.8684    2680.7708       0.0000    4492.0000
 2759.9640      77.2731     793.6929    1147.1075     256.9482     249.5028     216.0000      26.1042     284.9054       0.0993       0.0256      -0.0098     440.4681      -0.0194      -0.0136       0.0092       7.9128    2666.2039       0.0000    4469.0000
 2760.1164      83.7789    1421.1033    1950.0000     320.8590     310.3939     216.0000      27.5127     282.3004       0.1035       0.0301      -0.0052     434.9072      -0.0166      -0.0096       0.0133       7.8909    2658.5613       5.5000    4479.0000
 2760.2688      80.4742     916.7473    1950.0000     554.0134     526.7906     216.0000      26.0751     280.6259       0.0970       0.0231      -0.0124     441.1838      -0.0173      -0.0109       0.0122       7.9272    2670.4980       2.5000    4542.0000
 2760.4212      72.9189     589.4427    1749.8187     674.5231     607.0728     216.0000      23.1638     279.8816       0.0797       0.0044      -0.0318     445.8027      -0.0202      -0.0145       0.0081       7.9860    2702.5166       4.9375    4570.0000
 2760.5736      66.9425     413.1109    1711.6404     559.0590     521.7691     216.0000      19.8449     274.8578       0.0675      -0.0089      -0.0455     433.5778      -0.0229      -0.0180       0.0042       7.8637    2725.1338       3.6250    4505.0000
 2760.7260      67.0042     336.2977    1238.9611     373.4680     345.3161     216.0000      17.9222     272.2528       0.0714      -0.0046      -0.0411     412.4958      -0.0225      -0.0167       0.0051       7.7368    2717.8772       7.3750    4525.0000
 2760.8784      73.8466     381.8588    1597.6267     308.4676     296.3737     216.0000      16.5102     273.9275       0.0767       0.0011      -0.0352     408.1972      -0.0261      -0.0212      -0.0001       7.6214    2708.0437       2.4375    4491.0000
 2761.0308      79.0852     555.8123    1950.0000     412.1842     394.4977     216.0000      16.6146     279.5095       0.0793       0.0039      -0.0323     416.0924      -0.0257      -0.0207       0.0004       7.7223    2703.2988       9.7500    4504.0000
 2761.1832      76.8120     711.4818    1950.0000     554.1212     522.4532     216.0000      17.1566     278.9513       0.0834       0.0084      -0.0277     435.8130      -0.0239      -0.0184       0.0030       8.0199    2695.7175       8.4375    4578.0000
 2761.3356      73.5109     724.5045    1950.0000     470.8619     451.0917     216.0000      18.6734     279.8816       0.0704      -0.0057      -0.0423     443.8376      -0.0202      -0.0132       0.0085       7.9885    2719.7925       9.3750    4529.0000
 2761.4880      74.7402     688.7397    1950.0000     753.2459     714.6765     216.0000      19.1814     272.8111       0.0706      -0.0055      -0.0420     441.3748      -0.0252      -0.0210       0.0009       7.6962    2719.3701       9.7500    4551.0000
 2761.6404      78.1683     707.0067    1826.8463     914.2725     857.5292     216.0000      18.0974     276.1603       0.0752      -0.0005      -0.0369     418.7825      -0.0200      -0.0141       0.0085       7.8853    2710.8999       9.7500    4523.0000
 2761.7928      79.1666     774.5646    1874.8696     930.7289     880.8294     216.0000      18.3603     280.0677       0.0690      -0.0072      -0.0438     405.1364      -0.0243      -0.0203       0.0021       7.7654    2722.3325       8.8125    4535.0000
 2761.9452      78.0851     787.6083    1635.7156     687.3331     657.4866     216.0000      17.9280     281.7422       0.0639      -0.0127      -0.0495     402.2524      -0.0197      -0.0136       0.0090       7.4064    2731.7537       9.1875    4555.0000
 2762.0976      79.1884    1070.9667    1950.0000     642.3702     610.3057     216.0000      19.4783     282.4865       0.0814       0.0062      -0.0300     415.3831      -0.0238      -0.0189       0.0030       7.9770    2699.4795       9.7500    4536.0000
 2762.2500      83.4298    1247.2155    1950.0000     646.0857     612.1167     216.0000      18.1319     281.7422       0.0815       0.0063      -0.0298     428.6594      -0.0231      -0.0179       0.0040       7.8624    2699.2122       9.7500    4476.0000
 2762.4024      86.1760    1254.4091    1950.0000     756.4070     714.2067     216.0000      16.4306     283.4169       0.0886       0.0139      -0.0219     445.9350      -0.0187      -0.0118       0.0105       7.9448    2686.1577      13.2500    4591.0000
 2762.5548      84.4560     889.5119    1950.0000     913.8698     844.4300     216.0000      15.6391     278.9513       0.0972       0.0233      -0.0122     450.8095      -0.0189      -0.0126       0.0100       7.9338    2670.0950       8.9375    4510.0000
 2762.7072      81.5604     552.7709    1639.8838     568.5799     486.3730     216.0000      13.4723     274.4857       0.0934       0.0192      -0.0165     445.3351      -0.0227      -0.0186       0.0042       8.0709    2677.2266      15.5000    4511.0000
 2762.8596      79.2019     430.9167    1318.3585     382.0474     345.0021     216.0000      16.7235     273.0901       0.0926       0.0183      -0.0174     437.1102      -0.0208      -0.0162       0.0070       7.7667    2678.7051      11.8125    4522.0000
 2763.0120      76.4808     436.3033    1478.6002     328.9686     309.3746     216.0000      20.9463     270.7643       0.0914       0.0170      -0.0187     429.2858      -0.0111      -0.0044       0.0205       7.6082    2680.9094      17.6875    4525.0000
 2763.1644      69.2560     465.1459    1351.0868     237.5825     225.2659     216.0000      23.9834     272.8111       0.1335       0.0625       0.0285     415.1764      -0.0108      -0.0051       0.0207       7.6690    2603.0549      18.7500    4526.0000
 2763.3168      64.6125     311.7665     498.1454     169.0782     162.1560     216.0000      23.7801     273.0901       0.2003       0.1348       0.1034     387.5639      -0.0073      -0.0014       0.0253       8.1830    2479.4363      19.5000    4544.0000
 2763.4692      73.8860     781.6224    1115.5620     202.4141     191.9262     216.0000      19.8798     283.2308       0.1889       0.1225       0.0906     374.2454      -0.0022       0.0063       0.0328       8.1592    2500.4641      19.5000    4552.0000
 2763.6216      89.7045     883.0996     985.4253     238.2536     223.3845     216.0000      16.7017     282.3004       0.1975       0.1318       0.1002     389.5540      -0.0051       0.0034       0.0290       7.7662    2484.6816      19.5000    4607.0000
 2763.7740     109.1828     512.7187     982.0708     310.9358     291.1221     216.0000      12.8618     283.2308       0.1840       0.1171       0.0850     420.8732      -0.0145      -0.0094       0.0155       8.1460    2509.6816      19.5000    4522.0000
 2763.9264     118.7891     195.4041     592.9449     505.4544     453.7428     216.0000      12.5368     288.6267       0.1700       0.1020       0.0693     422.7395      -0.0144      -0.0089       0.0158       8.0218    2535.5923      20.0000    4536.0000
 2764.0788      84.7677      88.2640     202.2716     215.2515     193.0802     216.0000      13.7560     289.5571       0.1564       0.0873       0.0542     399.7295      -0.0136      -0.0083       0.0168       8.0476    2560.6416      22.9375    4552.0000
 2764.2312      61.5076      60.9295     114.6734     123.4946     118.7966     216.0000      13.9709     295.5112       0.1966       0.1309       0.0993     390.3398      -0.0139      -0.0080       0.0166       7.4874    2486.2297      22.5625    4538.0000
 2764.3836      74.5968      79.1775     115.8506      63.7204      62.6458     216.0000      13.0378     296.9998       0.1753       0.1078       0.0753     395.2517      -0.0160      -0.0107       0.0136       7.8858    2525.6726      23.9375    4558.0000
 2764.5360      92.9521     107.9891      69.5111      51.3946      50.8292     216.0000      12.6119     290.9526       0.1565       0.0874       0.0543     383.5754      -0.0141      -0.0084       0.0163       7.5954    2560.4634      24.5000    4544.0000
 2764.6884     101.1108     169.3218      72.6233      29.8229      29.6602     216.0000      16.0337     287.5103       0.1487       0.0790       0.0455     368.1726      -0.0119      -0.0076       0.0188       7.3155    2574.8616      25.7500    4554.0000
 2764.8408      66.8789      83.7246      65.6811      27.6317      27.5201     216.0000      22.1673     280.9049       0.1131       0.0405       0.0056     317.8215      -0.0056      -0.0022       0.0268       6.9824    2640.6809      27.2500    4502.0000
 2764.9932      24.3574      25.2471      29.3177      10.9288      10.8986     216.0000      30.8230     269.4618       0.2442       0.1824       0.1526     291.6069       0.0108       0.0159       0.0487       6.6548    2398.1528      29.3125    4535.0000
 2765.1456       9.4162       9.0618       8.8492       9.5879       9.5626     216.0000      36.5019     282.5796       0.2192       0.1553       0.1246     294.9254       0.0601       0.0736       0.1127       8.1784    2444.4104      30.0000    4539.0000
 2765.2980      31.1343      29.2520      27.9597      28.6320      28.5798     216.0000      32.4004     278.9513       0.1204       0.0484       0.0138     333.3394       0.1223       0.1441       0.1881       7.3022    2627.2407      29.3125    4556.0000
 2765.4504     115.2522     118.8698      64.3043      72.5234      72.4888     216.0000      23.0530     282.6726       0.0510      -0.0267      -0.0641     366.9412       0.0266       0.0355       0.0700       6.8816    2755.7185      30.8125    4550.0000
 2765.6028     126.2947     182.3347     253.4350     171.9901     172.1972     216.0000      14.2793     281.7422       0.0659      -0.0106      -0.0474     358.8064      -0.0153      -0.0139       0.0134       6.6086    2728.1411      29.3125    4601.0000
 2765.7552     125.0917     294.3626     322.9320     426.5049     430.3817     216.0000      12.4220     285.0915       0.0695      -0.0067      -0.0433     360.2672      -0.0176      -0.0141       0.0109       6.6514    2721.3850      29.3125    4547.0000
 2765.9076     166.4360     580.7665     669.0634     352.0339     358.3403     216.0000      14.9565     278.2070       0.0651      -0.0114      -0.0482     360.6608      -0.0132      -0.0090       0.0171       6.4838    2729.4819      29.8125    4498.0000
 2766.0600     216.8862    1480.3398     892.6065     181.4177     184.3949     216.0000      16.4256     267.5081       0.0477      -0.0303      -0.0677     351.3935      -0.0044       0.0007       0.0289       6.0696    2761.7832      29.3125    4508.0000
 2766.2124     183.1431    1950.0000     417.1067     104.7925     106.1905     216.0000      19.5675     258.8560       0.0004      -0.0814      -0.1207     326.6768       0.0148       0.0232       0.0547       5.9144    2849.2107      31.8125    4522.0000
 2766.3648     162.5786     647.2771     262.9479      84.5522      85.3968     216.0000      21.1987     251.8785      -0.0288      -0.1130      -0.1535     282.8279       0.0172       0.0250       0.0577       4.8568    2903.2832      34.1875    4517.0000
 2766.5172     193.8056     412.0358     166.7768      79.7146      80.4643     216.0000      27.0917     246.5756      -0.0162      -0.0994      -0.1394     227.4408       0.0178       0.0254       0.0584       4.6206    2880.0503      39.0625    4595.0000
 2766.6696     233.4821     334.5043     159.2971      95.9232      96.6783     216.0000      29.3669     247.1338       0.0150      -0.0656      -0.1044     161.8047       0.0182       0.0259       0.0590       5.0048    2822.1841      31.5000    4563.0000
 2766.8220     160.1646     262.1214     212.1915     133.8181     134.8203     216.0000      32.2117     245.7383      -0.0193      -0.1027      -0.1428     104.7020       0.0029       0.0064       0.0381       4.2024    2885.6125      36.0000    4518.0000
 2766.9744      59.2941      64.1083      63.5242      52.0197      52.1555     216.0000      37.3153     231.1321      -0.0046      -0.0869      -0.1264      55.5646       0.0029       0.0057       0.0379       3.6526    2858.5698      39.0625    4535.0000
 2767.1268      84.5935      18.2907      18.0406      16.9864      17.0048     216.0000      46.9547     231.5042       0.0967       0.0228      -0.0127      35.0399       0.0433       0.0538       0.0913       3.5649    2671.0161      40.6250    4551.0000
 2767.2792      58.0985      40.3614      53.5271      37.7413      37.7869     216.0000      50.1748     231.5042       0.1396       0.0692       0.0353      23.9658       0.0938       0.1106       0.1539       4.4777    2591.6760      43.0000    4657.0000
 2767.4316      70.4473      70.3908      95.8981      96.6840      97.1262     216.0000      44.8577     232.6206       0.0056      -0.0758      -0.1149      18.5976       0.0412       0.0494       0.0882       3.6946    2839.5737      44.2500    4649.0000
 2767.5840      58.2026      94.3550     114.5244     115.4246     116.7478     216.0000      36.0274     231.7833       0.0066      -0.0747      -0.1138       6.5758       0.0119       0.0156       0.0499       3.3412    2837.7471      43.9375    4560.0000
 2767.7364      56.8359      95.6563     155.2825     131.7278     134.0896     216.0000      33.2091     230.9460       0.0245      -0.0554      -0.0938       1.9712       0.0186       0.0257       0.0593       3.3489    2804.6936      45.2500    4504.0000
 2767.8888      54.7926      48.1660      60.2185      70.2129      71.2545     216.0000      31.1873     231.2251       0.0446      -0.0336      -0.0712       1.2081       0.0221       0.0308       0.0642       3.3782    2767.4111      48.4375    4487.0000
 2768.0412      63.6213      52.6268      58.3056     105.5180     107.5432     216.0000      32.0034     231.5042       0.0143      -0.0664      -0.1051      10.0532       0.0055       0.0096       0.0416       3.4513    2823.4934      48.8125    4538.0000
 2768.1936      83.6695     125.2463     134.2527     131.9028     134.8193     216.0000      32.1096     229.8296       0.0169      -0.0636      -0.1023      10.8790       0.0022       0.0054       0.0371       3.3557    2818.7751      52.3125    4598.0000
 2768.3460      68.3108     288.3339     227.2804     120.1057     122.1281     216.0000      41.6070     229.0853       0.0653      -0.0113      -0.0480      32.8996       0.0216       0.0285       0.0631       3.3942    2729.2810      52.5625    4590.0000
 2768.4984     103.6698     219.9462     167.1685      92.8862      94.5331     216.0000      55.6250     229.6435       0.1458       0.0758       0.0422      37.4630       0.0541       0.0656       0.1049       4.3843    2580.3262      51.8125    4496.0000
 2768.6508     113.7092     229.9358     178.1289     119.9589     122.0049     216.0000      61.6973     232.6206       0.0231      -0.0569      -0.0954      37.2667       0.0844       0.0999       0.1424       3.7868    2807.3574      51.0000    4472.0000
 2768.8032     153.6263     411.2696     254.4661     144.9244     148.1342     216.0000      53.8256     232.8066       0.0043      -0.0772      -0.1163      13.2873       0.0400       0.0486       0.0868       3.5282    2841.9771      54.2500    4454.0000
 2768.9556     129.1324     979.5652     328.1661     188.9298     194.2754     216.0000      39.1575     233.3649       0.0021      -0.0796      -0.1188      -3.0515       0.0099       0.0138       0.0474       3.4980    2846.0596      48.8125    4520.0000
 2769.1080     136.4538     458.7141     220.6261     132.1371     135.5269     216.0000      33.0873     233.1788      -0.0015      -0.0835      -0.1229      -7.2024       0.0154       0.0217       0.0550       3.3946    2852.8188      57.0000    4479.0000
 2769.2604     129.4060     266.0217     164.9982      98.8638     101.0769     216.0000      34.3009     233.1788       0.0138      -0.0670      -0.1058      -6.9141       0.0173       0.0236       0.0575       3.2595    2824.4978      58.5625    4504.0000
 2769.4128      89.9492     176.5665     150.2186      95.7701      97.8409     216.0000      34.6315     233.1788       0.0063      -0.0751      -0.1142      -5.7704       0.0213       0.0281       0.0627       3.3611    2838.3733      58.7500    4514.0000
 2769.5652     108.5911     172.2130     151.5686     111.7401     114.5182     216.0000      37.5511     231.8763       0.0233      -0.0567      -0.0951      -3.4885       0.0133       0.0178       0.0519       3.4849    2806.9165      61.2500    4527.0000
 2769.7176      88.6877      90.3965      79.3324      71.1903      72.4343     216.0000      42.1289     229.8296       0.0742      -0.0016      -0.0380       5.7971       0.0453       0.0555       0.0937       3.5970    2712.7563      62.5625    4504.0000
 2769.8700      60.4848      31.9227      31.7990      33.9715      34.1932     216.0000      43.2128     225.3640       0.1334       0.0624       0.0283      13.3574       0.0827       0.0971       0.1403       4.0397    2603.2979      64.0000    4512.0000
 2770.0224      92.6185      92.0752      91.7777      82.7391      84.2165     216.0000      35.0078     224.6197      -0.0020      -0.0841      -0.1235      13.9110       0.0631       0.0740       0.1158       3.4376    2853.7742      67.3750    4491.0000
 2770.1748     137.6227     347.0634     310.6879     231.2571     240.3174     216.0000      23.7621     224.5267      -0.0012      -0.0831      -0.1225       2.6145       0.0287       0.0347       0.0720       3.3389    2852.1360      67.8125    4574.0000
 2770.3272     118.4071    1663.2917    1381.4341     483.6312     520.0075     216.0000      16.1743     224.9918       0.0017      -0.0800      -0.1193       2.6174       0.0185       0.0241       0.0589       3.3348    2846.8083      68.1875    4517.0000
 2770.4796     119.5833     852.9333     816.4424     408.2556     435.7645     216.0000      13.8375     224.8058       0.0228      -0.0572      -0.0957      -0.0701       0.0194       0.0258       0.0602       3.4195    2807.8860      68.3750    4567.0000
 2770.6320     129.8726     252.0542     265.6903     219.0202     231.3990     216.0000      12.3207     224.4336       0.0345      -0.0445      -0.0825      -0.6545       0.0189       0.0247       0.0594       3.4630    2786.0862      68.9375    4546.0000
 2770.7844      74.2518     101.0673     120.4320     119.3394     123.2981     216.0000      11.6221     224.2476       0.0616      -0.0152      -0.0521      -7.4215       0.0340       0.0420       0.0792       3.3327    2735.9519      68.3750    4521.0000
 2770.9368      79.7176     135.4448     161.0985     161.5079     170.6346     216.0000      12.1965     224.5267       0.0621      -0.0147      -0.0516      -4.9117       0.0544       0.0654       0.1052       3.1580    2735.0720      69.1250    4576.0000
 2771.0892      59.6768     114.2749     154.0204     141.3365     149.3493     216.0000      12.7667     224.6197       0.0739      -0.0019      -0.0383      12.5854       0.0537       0.0642       0.1042       3.3161    2713.2673      68.8750    4544.0000
 2771.2416      82.2408     127.1036     165.1623     139.6754     146.9173     216.0000      13.7904     224.9918       0.0830       0.0079      -0.0282      31.0380       0.0443       0.0531       0.0922       3.3628    2696.4907      68.4375    4536.0000
 2771.3940      74.8021     112.1947     135.2246     117.6814     121.6814     216.0000      14.8739     224.8058       0.0340      -0.0451      -0.0831      39.5961       0.0429       0.0515       0.0904       4.3797    2787.0742      71.2500    4525.0000
 2771.5464     122.7520     258.2015     275.7278     196.1647     204.8673     216.0000      15.4835     225.1779      -0.0071      -0.0895      -0.1291      27.0123       0.0426       0.0513       0.0901       3.5499    2863.0833      69.4375    4515.0000
 2771.6988     113.2275     832.3234     797.0706     343.0150     384.2635     216.0000      15.7003     225.5500      -0.0032      -0.0853      -0.1248       8.8420       0.0402       0.0490       0.0871       3.3349    2855.8389      70.0000    4551.0000
 2771.8512     130.5058    1950.0000    1602.7449     725.0693     777.8637     216.0000      15.3753     225.6431      -0.0010      -0.0830      -0.1223      -0.9830       0.0299       0.0375       0.0739       3.3759    2851.8606      68.3750    4606.0000
 2772.0036     141.0984    1950.0000    1780.5906     821.4831     895.3464     216.0000      14.7394     226.1082      -0.0039      -0.0861      -0.1256      -3.0074       0.0193       0.0259       0.0601       3.2766    2857.1746      68.3750    4539.0000
 2772.1560     148.2475    1302.0594    1797.3375     660.0568     786.1920     216.0000      14.9188     226.2943       0.0031      -0.0785      -0.1178       3.4683       0.0146       0.0212       0.0541       3.2251    2844.2974      68.3750    4590.0000
 2772.3084     145.1685    1363.7095    1331.1591     639.9418     689.2009     216.0000      14.4877     225.9222       0.0153      -0.0653      -0.1041       3.4182       0.0041       0.0081       0.0398       3.4583    2821.7202      68.3750    4601.0000
 2772.4608     131.9315    1157.4871    1950.0000     643.9532     706.4661     216.0000      14.3108     226.1082       0.0379      -0.0409      -0.0787       6.0327       0.0171       0.0240       0.0574       3.5622    2779.8904      68.3750    4505.0000
 2772.6132     111.0603     512.0680     848.9922     421.6602     447.0068     216.0000      13.9121     225.9222       0.0865       0.0117      -0.0242       1.5976       0.0410       0.0519       0.0885       3.5734    2689.9353      68.3750    4542.0000
 2772.7656      88.0877     227.4719     369.6137     233.8963     249.2822     216.0000      13.4785     225.5500       0.0425      -0.0359      -0.0736       1.8723       0.0332       0.0405       0.0779       3.6456    2771.4553      68.3750    4566.0000
 2772.9180      78.0619     162.0451     199.9807     177.8591     186.0003     216.0000      15.0026     225.9222       0.0249      -0.0549      -0.0933      -2.8002       0.0536       0.0637       0.1040       3.3559    2803.8853      68.0625    4594.0000
 2773.0704      70.0340     117.5992     177.9568     217.6467     229.9376     216.0000      15.4359     225.0849       0.0223      -0.0577      -0.0962      -8.0864       0.0548       0.0650       0.1056       3.3942    2808.6887      66.8125    4568.0000
 2773.2228      71.9442     122.6781     191.8761     211.5754     224.2494     216.0000      17.2030     224.9918       0.0394      -0.0393      -0.0771     -10.5295       0.0480       0.0576       0.0970       3.3943    2777.1677      65.4375    4565.0000
 2773.3752      77.9918     153.6874     225.5469     300.3809     320.3046     216.0000      18.4539     225.0849       0.0178      -0.0626      -0.1013     -11.0085       0.0493       0.0600       0.0989       3.4501    2817.1091      66.3125    4529.0000
 2773.5276      92.9907     224.0114     322.9656     362.8864     396.0758     216.0000      16.5055     225.3640       0.0082      -0.0730      -0.1120     -10.7603       0.0316       0.0403       0.0762       3.3899    2834.7563      65.8750    4488.0000
 2773.6800     122.8465     504.7984     799.3884     662.0441     706.0641     216.0000      13.9654     225.6431       0.0166      -0.0639      -0.1026      -9.3508       0.0086       0.0136       0.0459       3.4140    2819.2483      59.5625    4517.0000
 2773.8324     136.0542    1197.8444    1950.0000     955.4821    1026.9723     216.0000      10.8235     225.3640       0.0081      -0.0731      -0.1122      -9.5909       0.0064       0.0121       0.0432       3.3860    2835.0837      58.1250    4587.0000
 2773.9848     132.8072    1622.5912    1950.0000     948.0925    1030.3107     216.0000      12.3410     225.6431       0.0057      -0.0757      -0.1148      -6.3634       0.0056       0.0111       0.0421       3.3340    2839.4351      55.4375    4559.0000
 2774.1372     127.9002    1431.1367    1704.5465     753.6505     797.6356     216.0000      13.7635     226.1082       0.0170      -0.0635      -0.1022      -2.2478       0.0060       0.0113       0.0426       3.4409    2818.5996      52.6250    4503.0000
 2774.2896     130.9864     861.3729     847.6138     522.1507     551.9440     216.0000      13.8718     226.2013       0.0344      -0.0447      -0.0827      -0.5963       0.0078       0.0129       0.0449       3.3807    2786.4290      49.6250    4515.0000
 2774.4420     113.6247     300.5227     338.3736     263.3781     271.1849     216.0000      14.0886     225.9222       0.0359      -0.0430      -0.0809       0.7963       0.0226       0.0306       0.0647       3.5689    2783.5161      48.7500    4525.0000
 2774.5944     128.2912     655.8978     792.7960     457.2690     484.5720     216.0000      16.7268     225.9222       0.0648      -0.0118      -0.0486       3.7036       0.0296       0.0385       0.0738       3.4202    2730.1699      46.8125    4535.0000
 2774.7468     114.6738     684.4453     889.8539     495.3030     525.0958     216.0000      21.3898     225.9222       0.0373      -0.0416      -0.0794       6.4850       0.0281       0.0356       0.0715       3.7426    2781.0618      45.6875    4517.0000
 2774.8992     111.2296     402.8427     492.6453     331.8705     344.0892     216.0000      26.4793     227.5968       0.0075      -0.0738      -0.1129       5.0068       0.0373       0.0462       0.0835       3.6000    2836.2158      42.5000    4481.0000
 2775.0516     129.9169     232.1741     285.9731     234.1032     237.1544     216.0000      28.8197     225.3640       0.0073      -0.0740      -0.1131      -1.5991       0.0416       0.0507       0.0889       3.5759    2836.5627      42.1875    4491.0000
 2775.2040     152.2322     572.0256     741.3480     481.5136     501.6376     216.0000      25.3510     226.1082      -0.0068      -0.0892      -0.1288      -1.9798       0.0499       0.0608       0.0996       3.4008    2862.5640      39.8750    4518.0000
 2775.3564     146.1236    1015.5257    1950.0000     782.1192     858.0217     216.0000      18.6146     224.2476       0.0087      -0.0725      -0.1115      -4.8454       0.0251       0.0318       0.0675       3.3299    2833.8979      40.1250    4505.0000
 2775.5088     134.5387    1134.9508    1823.0746     555.1693     582.4133     216.0000      12.3344     224.2476       0.0176      -0.0628      -0.1015      -3.1862       0.0119       0.0171       0.0503       3.3652    2817.4204      40.5625    4501.0000
 2775.6612     125.9014    1014.4987    1747.5680     411.0350     440.4168     216.0000      11.4672     224.2476       0.0088      -0.0724      -0.1114      -4.6186       0.0097       0.0155       0.0475       3.3137    2833.8059      37.5000    4479.0000
 2775.8136     122.8386     767.9755    1235.9519     399.6406     429.9975     216.0000      11.6687     223.9685      -0.0010      -0.0830      -0.1224      -2.7869       0.0139       0.0209       0.0532       3.2835    2851.8958      39.0625    4454.0000
 2775.9660     107.6381     432.2167     915.8358     388.5324     411.1438     216.0000      12.6460     223.6894      -0.0037      -0.0859      -0.1254      -5.7058       0.0123       0.0189       0.0512       3.2667    2856.9246      38.0625    4494.0000
 2776.1184      96.5235     273.3209     482.7630     466.5567     496.4368     216.0000      14.1607     223.1312       0.0115      -0.0695      -0.1083      -7.3485       0.0088       0.0142       0.0463       3.2133    2828.7600      38.4375    4454.0000
 2776.2708     110.2809     381.5069     886.4949     687.1448     717.8634     216.0000      18.7346     223.4103       0.0417      -0.0367      -0.0744      -5.7907       0.0138       0.0200       0.0529       3.1268    2772.7764      33.8750    4563.0000
 2776.4232     129.1594     510.6525    1179.6227    1037.0427    1070.7454     216.0000      20.5773     236.1559       0.0173      -0.0631      -0.1018      -2.3501       0.0217       0.0286       0.0633       3.4286    2817.9226      33.6250    4454.0000
 2776.5756     150.0224     689.9004    1950.0000    1950.0000    1950.0000     216.0000      19.3855     239.0399       0.0135      -0.0673      -0.1061      -1.0965       0.0403       0.0500       0.0874       3.3784    2825.0034      31.7500    4511.0000
 2776.7280     144.4022     700.6738    1235.8527    1173.7397    1211.6030     216.0000      15.2198     223.1312       0.0057      -0.0757      -0.1148       8.9495       0.0390       0.0471       0.0855       3.3248    2839.4153      31.1250    4551.0000
 2776.8804     112.5376     785.6678     655.7612     637.5997     675.1201     216.0000      12.9435     223.1312       0.0130      -0.0678      -0.1066      17.6957       0.0439       0.0529       0.0918       3.3142    2825.8679      29.0000    4489.0000
 2777.0328     110.5160     534.8815     894.6490     509.1272     519.2289     216.0000      11.2312     223.1312       0.0164      -0.0641      -0.1028      24.4987       0.0351       0.0428       0.0805       3.3305    2819.6702      32.4375    4497.0000
 2777.1852     116.4070     607.8951     653.5715     345.9330     350.6327     216.0000       9.9908     223.1312       0.0162      -0.0643      -0.1030      22.6057       0.0323       0.0400       0.0769       3.3346    2820.0286      28.3125    4512.0000
 2777.3376     127.9482     401.2794     563.6208     289.7110     293.4637     216.0000       8.9198     223.1312       0.0198      -0.0605      -0.0990      14.4823       0.0228       0.0288       0.0644       3.3994    2813.4265      32.6250    4472.0000
 2777.4900     107.0507     311.3961     454.9178     331.3200     333.9914     216.0000       9.9820     223.1312       0.0202      -0.0601      -0.0986       7.7739       0.0333       0.0415       0.0783       3.2831    2812.7200      35.5625    4504.0000
 2777.6424     129.3905     245.9170     396.1969     332.3086     339.2004     216.0000      10.6128     222.8521       0.0139      -0.0669      -0.1057      -1.9763       0.0377       0.0457       0.0838       3.4172    2824.3589      33.6250    4534.0000
 2777.7948      69.1033      98.2302     151.3799     159.0387     164.1523     216.0000      11.4670     222.8521       0.0227      -0.0573      -0.0958      -5.4145       0.0550       0.0655       0.1059       3.3632    2808.0210      38.3750    4556.0000
 2777.9472      71.7617     134.3678     273.0056     205.8983     211.1281     216.0000      11.2503     222.9451       0.0245      -0.0553      -0.0937      -5.9946       0.0600       0.0710       0.1121       3.3506    2804.6467      33.3750    4555.0000
 2778.0996      61.6817     147.4016     252.9669     242.3662     249.4868     216.0000      12.8760     222.7590       0.0237      -0.0563      -0.0947      -7.6058       0.0561       0.0671       0.1073       3.3575    2806.2351      36.6250    4469.0000
 2778.2520      59.5643     104.5498     185.5921     216.4877     223.3334     216.0000      14.8271     223.1312       0.0031      -0.0785      -0.1177      -5.3155       0.0431       0.0519       0.0907       3.3111    2844.1973      33.9375    4492.0000
 2778.4044      76.1488     120.8770     187.1402     138.5688     143.5378     216.0000      18.0424     222.7590       0.0017      -0.0800      -0.1193      -4.9489       0.0463       0.0559       0.0949       3.4399    2846.7798      33.6250    4536.0000
 2778.5568      97.0078     229.2872     364.5382     420.1335     428.8646     216.0000      15.6790     223.3172      -0.0089      -0.0915      -0.1312      -3.6910       0.0361       0.0441       0.0818       3.2859    2866.4490      29.8750    4528.0000
 2778.7092     113.0403     574.7996     749.7557    1259.6759    1299.9753     216.0000      13.7881     223.4103      -0.0063      -0.0887      -0.1283      -2.9707       0.0318       0.0396       0.0763       3.3190    2861.7075      30.7500    4491.0000
 2778.8616     124.3091    1609.1820    1280.0797     685.6786     728.3611     216.0000      12.3063     223.5033      -0.0041      -0.0863      -0.1258      -2.4002       0.0256       0.0327       0.0683       3.3478    2857.6013      30.1250    4504.0000
 2779.0140     139.0784    1837.2925    1135.2639     415.4343     441.1866     216.0000      15.4825     223.4103      -0.0061      -0.0884      -0.1280      -1.1818       0.0316       0.0401       0.0762       3.4606    2861.2407      30.1250    4487.0000
 2779.1664     133.0974    1618.7368     935.0601     336.2205     359.0521     216.0000      15.3139     223.5033      -0.0061      -0.0885      -0.1281       0.9589       0.0233       0.0304       0.0653       3.2978    2861.3374      29.3125    4527.0000
 2779.3188     134.6624    1274.6738    1058.6534     423.4875     452.0249     216.0000      13.0382     223.5033      -0.0055      -0.0878      -0.1273       6.1376       0.0217       0.0292       0.0634       3.3208    2860.0911      28.7500    4515.0000
 2779.4712     140.0442    1950.0000    1401.2023     376.0195     424.5260     216.0000      10.7291     223.4103       0.0064      -0.0750      -0.1141       6.0101       0.0159       0.0226       0.0557       3.3028    2838.1907      29.3125    4517.0000
 2779.6236     138.4790    1950.0000    1317.7867     405.4457     448.1072     216.0000      10.9993     223.1312       0.0026      -0.0791      -0.1183       1.6568       0.0094       0.0145       0.0470       3.3146    2845.2131      25.7500    4549.0000
 2779.7760     128.4124     878.6422     708.3115     339.4853     372.1885     216.0000      10.7832     223.3172       0.0069      -0.0744      -0.1135      -4.6895       0.0176       0.0243       0.0580       3.2989    2837.2195      29.3125    4530.0000
 2779.9284      99.1875     655.6702     495.6531     300.0073     324.6539     216.0000      10.6538     223.6894       0.0019      -0.0798      -0.1191      -7.9870       0.0235       0.0306       0.0656       3.2685    2846.4917      23.9375    4542.0000
 2780.0808     106.8007     592.5919     496.2627     365.1251     416.8522     216.0000       9.9500     223.6894       0.0043      -0.0772      -0.1164      -9.3949       0.0371       0.0464       0.0833       3.3122    2842.0740      27.6250    4505.0000
 2780.2332     122.3948     804.0970     970.1936     847.3190     908.6652     216.0000      10.7084     223.3172       0.0246      -0.0552      -0.0936      -6.8471       0.0368       0.0453       0.0827       3.3846    2804.4578      22.2500    4559.0000
 2780.3856     128.6070     435.8008     703.9371    1027.1315    1126.1072     216.0000      10.5052     223.4103       0.0252      -0.0546      -0.0930      -4.3697       0.0354       0.0436       0.0809       3.4358    2803.4006      21.3750    4486.0000
 2780.5380     111.3749     164.6967     269.9511     367.0500     394.1525     216.0000      13.2120     223.1312       0.0137      -0.0671      -0.1059      -2.2588       0.0332       0.0411       0.0780       3.3980    2824.7097      20.5625    4567.0000
 2780.6904      58.5203      73.0124     106.6093     158.1119     170.3886     216.0000      18.4627     222.8521       0.0157      -0.0649      -0.1036      -4.7784       0.0288       0.0356       0.0723       3.4072    2820.9033      19.5000    4505.0000
 2780.8428      80.4279     111.5238     193.7140     206.7847     220.9544     216.0000      22.1556     223.1312       0.0297      -0.0497      -0.0879       1.9915       0.0346       0.0430       0.0800       3.0925    2794.9656      19.5000    4541.0000
 2780.9952      96.7020     219.6923     362.1355     301.1082     318.3887     216.0000      20.5304     223.5033       0.0218      -0.0583      -0.0968       3.6943       0.0411       0.0511       0.0884       3.4959    2809.7090      18.1250    4522.0000
 2781.1476     131.8282     484.6204    1397.7181     382.1433     402.8391     216.0000      16.6695     223.6894       0.0107      -0.0703      -0.1092       3.7296       0.0278       0.0363       0.0714       3.2725    2830.2119      16.7500    4506.0000
 2781.3000     126.5040     482.2303     684.1194     289.4252     316.0284     216.0000      14.1764     224.2476       0.0018      -0.0799      -0.1192      -5.3210       0.0141       0.0204       0.0533       3.3928    2846.6865      14.6875    4545.0000
 2781.4524     104.3268     285.2274     328.8590     314.1689     338.7264     216.0000      14.1764     224.4336       0.0078      -0.0734      -0.1124      -4.3797       0.0082       0.0137       0.0456       3.3040    2835.4919      15.6875    4558.0000
 2781.6048      91.9334     288.9304     330.5649     325.4686     350.6967     216.0000      12.2460     224.8058       0.0179      -0.0625      -0.1011     666.6591       0.0168       0.0238       0.0570       3.6472    2816.7961      12.5625    4565.0000
 2781.7572     111.2152     421.1624     423.4911     291.8173     315.2290     216.0000      12.2437     224.5267       0.0317      -0.0475      -0.0856    1669.4714       0.0307       0.0393       0.0751       3.3829    2791.2803       9.7500    4544.0000
 2781.9096     104.6791     396.8942     422.7696     193.4124     204.7835     216.0000      12.0291     224.8058       0.0584      -0.0187      -0.0557    2656.4158       0.0365       0.0450       0.0823       3.5211    2741.9436      13.2500    4513.0000
 2782.0620      99.1587     451.0826     386.4864     162.4572     172.8586     216.0000      15.7884     224.6197     541.6757     585.9415     607.2121 -999250.0000       0.0401       0.0483       0.0868    -999.2500 -999250.0000      11.5625    4535.0000
 2782.2144      78.8772     176.5602     162.0764     120.9520     126.5936     216.0000      16.9802     225.9222     541.6757     585.9415     607.2121 -999250.0000       0.0675       0.0803       0.1216    -999.2500 -999250.0000      11.4375    4525.0000
 2782.3668      35.3428      58.5830      56.7385      51.7113      53.2477     216.0000      17.1970     224.4336     541.6757     585.9415     607.2121 -999250.0000       0.0761       0.0897       0.1321    -999.2500 -999250.0000       9.7500    4504.0000
 2782.5192      91.3812     168.7407     149.9273     139.4655     145.5074     216.0000      13.2345     225.3640     541.6757     585.9415     607.2121 -999250.0000       0.0358       0.0434       0.0814    -999.2500 -999250.0000      14.5625    4559.0000
 2782.6716     131.5154     372.5898     376.7544     334.3701     352.3519     216.0000      10.6343     225.5500     541.6757     585.9415     607.2121 -999250.0000       0.0132       0.0175       0.0518    -999.2500 -999250.0000       9.3125    4497.0000
 2782.8240     125.8872    1384.5031    1395.9580     877.8759     971.9529     216.0000       9.9839     225.9222     541.6757     585.9415     607.2121 -999250.0000       0.0126       0.0180       0.0511    -999.2500 -999250.0000      11.0000    4580.0000
 2782.9764      91.6136    1886.7263    1130.6458     618.5490     666.8525     216.0000      10.7297     225.7361     541.6757     585.9415     607.2121 -999250.0000       0.0174       0.0245       0.0578    -999.2500 -999250.0000       0.0000    4609.0000
